/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.client.ThumbnailPanel;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.thumbnails.Thumbnail;
import COM.xerox.digipaper.util.CanGetObjects;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;

public class PreviewWindow
extends Frame {
    Client viewer;
    XIFFFile file;
    ThumbnailPanel pThumb;
    Label message = new Label("Loading Thumbnails");
    Button bOk = new Button("  Ok  ");
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);

    public PreviewWindow(Client client, ThumbnailPanel thumbnailPanel) {
        super("Document Thumbnails");
        this.pThumb = thumbnailPanel;
        this.pThumb.setMessage(this.message);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", this.message);
        panel.add("East", this.bOk);
        this.setLayout(new BorderLayout());
        this.add("Center", this.pThumb);
        this.add("South", panel);
        this.pack();
        this.file = this.file;
        this.viewer = client;
    }

    public PreviewWindow(Client client, XIFFFile xIFFFile, CanGetObjects canGetObjects) {
        super("Document Thumbnails");
        this.pThumb = new ThumbnailPanel(xIFFFile, canGetObjects, this.message);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", this.message);
        panel.add("East", this.bOk);
        this.setLayout(new BorderLayout());
        this.add("Center", this.pThumb);
        this.add("South", panel);
        this.file = xIFFFile;
        this.viewer = client;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.CloseWindow();
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Thumbnail) {
            int n = ((Thumbnail)event.target).getPageNum();
            this.viewer.commandBar.CheckNGetPage(n);
            this.viewer.window.requestFocus();
        } else if (event.target == this.bOk || event.id == 201) {
            this.CloseWindow();
        } else {
            return false;
        }
        return true;
    }

    public void CloseWindow() {
        ((Component)this).hide();
        this.viewer.commandBar.preview.enable();
        this.setLayout(null);
        this.pThumb = null;
        this.message = null;
        this.bOk = null;
        this.dispose();
    }

    public void paint(Graphics graphics) {
        this.invalidate();
        this.validate();
        this.pThumb.repaint();
        super.paint(graphics);
    }
}

