/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableEntry;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LinkRegion {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    public static final int HIGHLIGHT_MASK = 8;
    public static final String ANCHOR_FLAG = "#";
    public static final int OUTLINE = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int UNDERLINE = 4;
    public static final int MOUSE_ONLY = 5;
    public static final Color HIGHLIGHT_COLOR = Color.red;
    public Rectangle area;
    public String target;
    public int displayMode;
    public boolean highlight;
    public Color normColor;
    public Color hlColor;

    public LinkRegion(Rectangle rectangle, String string, int n, boolean bl, Color color, Color color2) {
        this.area = rectangle;
        this.target = string;
        this.displayMode = n;
        this.highlight = bl;
        this.normColor = color;
        this.hlColor = color2;
    }

    public LinkRegion(AnnotationTableEntry annotationTableEntry) {
        int n;
        this.area = new Rectangle(annotationTableEntry.x, annotationTableEntry.y, annotationTableEntry.width, annotationTableEntry.height);
        this.highlight = annotationTableEntry.data[0] >= 8;
        this.displayMode = annotationTableEntry.data[0] & 7;
        int n2 = 1;
        if (this.displayMode != 5) {
            n = annotationTableEntry.data[n2] << 16 & 0xFF0000 | annotationTableEntry.data[n2 + 1] << 8 & 0xFF00 | annotationTableEntry.data[n2 + 2] & 0xFF;
            n2 += 3;
            this.normColor = new Color(n);
        }
        if (this.highlight) {
            n = annotationTableEntry.data[n2] << 16 & 0xFF0000 | annotationTableEntry.data[n2 + 1] << 8 & 0xFF00 | annotationTableEntry.data[n2 + 2] & 0xFF;
            n2 += 3;
            this.hlColor = new Color(n);
        }
        String string = new String(annotationTableEntry.data, 0, n2, annotationTableEntry.length - n2);
        dbg.dprint("disp" + this.displayMode + "." + string + "." + this.normColor + this.hlColor + this.highlight, DebugInfoPrinter.DBUG_GRAPHICS);
        this.target = string;
    }

    public Rectangle scale(float f) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)((float)this.area.x * f);
        rectangle.y = (int)((float)this.area.y * f);
        rectangle.width = (int)((float)this.area.width * f);
        rectangle.height = (int)((float)this.area.height * f);
        return rectangle;
    }

    public void draw(Graphics graphics, float f) {
        if (this.normColor != null) {
            this.draw(graphics, this.normColor, f);
            return;
        }
        this.draw(graphics, Color.blue, f);
    }

    public void draw(Graphics graphics, Color color, float f) {
        graphics.setColor(color);
        Rectangle rectangle = this.scale(f);
        switch (this.displayMode) {
            case 1: {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                return;
            }
            case 2: {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                return;
            }
            case 3: {
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                return;
            }
            case 4: {
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                return;
            }
            case 0: {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                return;
            }
        }
    }

    public void drawHighlight(Graphics graphics, float f) {
        Rectangle rectangle = this.scale(f);
        if (this.highlight) {
            if (this.hlColor == null) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(this.hlColor);
            }
            switch (this.displayMode) {
                case 5: {
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                    return;
                }
            }
            this.draw(graphics, this.hlColor, f);
        }
    }
}

