/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class Icon
extends Panel
implements Runnable {
    Image logo;
    final int delay = 50;
    Thread thread;
    float hue;
    Color bgcolor;
    Color current;
    Image offscreen_image;
    Graphics offscreen_graphics;

    public Icon(Image image) {
        this.logo = image;
        this.current = this.bgcolor = Color.white;
    }

    void pause() {
        try {
            Thread.sleep(50L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (!this.prepareImage(this.logo, this.size().width, this.size().height, this)) {
        }
        while (true) {
            this.current = Color.getHSBColor(this.hue, 1.0f, 0.7f);
            this.repaint();
            this.pause();
            this.hue = (float)((double)this.hue + 0.005);
            if (!((double)this.hue > 1.0)) continue;
            this.hue = 0.0f;
        }
    }

    public void animate() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Icon Thread");
            this.thread.start();
        }
    }

    public void normal() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
            this.current = this.bgcolor;
            this.repaint();
        }
    }

    public Dimension minimumSize() {
        return new Dimension(20, 20);
    }

    public Dimension preferredSize() {
        if (this.logo != null) {
            return new Dimension(this.logo.getWidth(this), this.logo.getHeight(this));
        }
        return this.minimumSize();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        this.offscreen_image = this.createImage(this.size().width, this.size().height);
        this.offscreen_graphics = this.offscreen_image.getGraphics();
        this.offscreen_graphics.setColor(this.current);
        this.offscreen_graphics.fillRect(0, 0, this.size().width, this.size().height);
        if (this.logo == null) {
            this.offscreen_graphics.setColor(Color.black);
            this.offscreen_graphics.drawString("DigiPaper", 2, this.size().height / 2);
        } else {
            this.offscreen_graphics.drawImage(this.logo, 0, 0, this.size().width, this.size().height, this);
        }
        this.offscreen_graphics.setColor(Color.black);
        this.offscreen_graphics.drawRect(0, 0, this.size().width - 1, this.size().height - 1);
        this.offscreen_graphics.setColor(this.current);
        graphics.drawImage(this.offscreen_image, 0, 0, this);
    }
}

