/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.Anchor;
import COM.xerox.digipaper.applet.client.AnnotMgr;
import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.client.LinkRegion;
import COM.xerox.digipaper.applet.client.ZoomSelectPanel;
import COM.xerox.digipaper.applet.xiff.PageDescriptor;
import COM.xerox.digipaper.applet.xiff.PageInfoReader;
import COM.xerox.digipaper.applet.xiff.RenderThread;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableHeader;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClientCanvas
extends Canvas {
    public static float MAX_FACTOR = 4.0f;
    public static String CM_FOLLOW_LINK = "Hyperlinks";
    public static String CM_PAN = "Pan";
    public static String CM_ZOOM_REGION = "Zoom Region";
    public static String CM_ZOOM_IN = "Zoom In";
    public static String CM_ZOOM_OUT = "Zoom Out";
    public static String CM_THUMBNAIL = "Thumbnails";
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected Client viewer;
    public Image image;
    public AnnotMgr annotations;
    public int curPageNo = -1;
    public Anchor anchor;
    public LinkRegion current;
    public Panel pView;
    public Button bZoomIn;
    public Button bZoomOut;
    public ZoomSelectPanel zsPanel;
    public Choice cClickMode;
    public String clickMode = CM_FOLLOW_LINK;
    protected float factor = 1.0f;
    protected int dx;
    protected int dy;
    protected int px;
    protected int py;
    protected int numOfPages;
    protected RenderThread renderThread;
    protected AnnotMgr[] AnnotBuffer;
    protected Hashtable anchors;
    protected int iHeight;
    protected int iWidth;
    protected PageInfoReader pi_reader;
    protected Rectangle window;
    protected boolean zooming = false;

    public int imageHeight() {
        return (int)((float)this.iHeight * this.factor);
    }

    public int imageWidth() {
        return (int)((float)this.iWidth * this.factor);
    }

    public void kill() {
        if (this.renderThread != null) {
            this.renderThread.kill();
        }
        this.image = null;
        this.annotations = null;
        this.current = null;
        this.renderThread = null;
        this.AnnotBuffer = null;
    }

    public ClientCanvas(Client client) {
        this.viewer = client;
        this.cClickMode = new Choice();
        this.cClickMode.addItem(CM_FOLLOW_LINK);
        this.cClickMode.addItem(CM_PAN);
        this.cClickMode.addItem(CM_THUMBNAIL);
        this.cClickMode.addItem(CM_ZOOM_REGION);
        this.cClickMode.addItem(CM_ZOOM_IN);
        this.cClickMode.addItem(CM_ZOOM_OUT);
        this.zsPanel = new ZoomSelectPanel(this);
        this.bZoomOut = new Button("(-)");
        this.bZoomIn = new Button("(+)");
        Font font = new Font("Courier", 1, 10);
        if (font != null) {
            font = new Font(font.getName(), 1, font.getSize());
            this.bZoomIn.setFont(font);
            this.bZoomOut.setFont(font);
        }
        this.pView = new Panel();
        this.pView.add(new Label("Mouse:"));
        this.pView.add(this.cClickMode);
        this.pView.add(new Label("   "));
        this.pView.add(this.bZoomIn);
        this.pView.add(this.bZoomOut);
        this.pView.add(this.zsPanel);
    }

    public void disableView() {
        this.bZoomOut.disable();
        this.bZoomIn.disable();
        this.zsPanel.disable();
    }

    public void enableView() {
        this.zsPanel.enable();
        this.bZoomIn.enable();
        this.bZoomOut.enable();
        if (this.clickMode == CM_THUMBNAIL) {
            this.clickMode = CM_FOLLOW_LINK;
            this.cClickMode.select(this.clickMode);
        }
    }

    public void setPageInfoReader(PageInfoReader pageInfoReader) {
        this.pi_reader = pageInfoReader;
    }

    public void newFile(RenderThread renderThread, int n) {
        this.AnnotBuffer = new AnnotMgr[n];
        this.anchors = new Hashtable();
        this.annotations = null;
        this.renderThread = renderThread;
        this.numOfPages = n;
        this.anchor = null;
        this.image = null;
        this.factor = 1.0f;
    }

    public void newPage() {
        if (this.annotations != null) {
            this.AnnotBuffer[this.curPageNo] = this.annotations;
        }
        this.updateImageInfo(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean getAnnotations(int n) {
        if (n != this.curPageNo) return this.AnnotBuffer[this.curPageNo] != null;
        if (this.AnnotBuffer[this.curPageNo] == null) {
            if (this.renderThread.page_descriptor.annot_hdr == null) {
                this.annotations = null;
                return false;
            }
            this.parseAnnotations(this.renderThread.page_descriptor.annot_hdr, this.curPageNo);
            this.annotations = this.AnnotBuffer[this.curPageNo];
            return this.AnnotBuffer[this.curPageNo] != null;
        } else {
            this.annotations = this.AnnotBuffer[this.curPageNo];
        }
        return this.AnnotBuffer[this.curPageNo] != null;
    }

    protected void parseAnnotations(AnnotationTableHeader annotationTableHeader, int n) {
        AnnotationTableHeader annotationTableHeader2 = annotationTableHeader;
        synchronized (annotationTableHeader2) {
            if (this.AnnotBuffer[n] == null) {
                this.AnnotBuffer[n] = this.newMgr(annotationTableHeader, n);
                Enumeration enumeration = this.AnnotBuffer[n].getAnchors();
                while (enumeration.hasMoreElements()) {
                    Anchor anchor = (Anchor)enumeration.nextElement();
                    this.anchors.put(anchor.name, anchor);
                }
            }
            return;
        }
    }

    protected AnnotMgr newMgr(AnnotationTableHeader annotationTableHeader, int n) {
        return new AnnotMgr(annotationTableHeader, n);
    }

    protected void updateImageInfo(boolean bl) {
        if (!bl) {
            this.viewer.setCursor(0);
            this.viewer.icon.normal();
            return;
        }
        PageDescriptor pageDescriptor = this.renderThread.page_descriptor;
        this.image = this.renderThread.getImage();
        ClientCanvas clientCanvas = this;
        synchronized (clientCanvas) {
            this.curPageNo = pageDescriptor.getPageNumber();
            this.viewer.commandBar.UpdateLocation("Page " + (this.curPageNo + 1) + " of " + this.numOfPages);
            this.viewer.setCursor(0);
            this.viewer.icon.normal();
            this.iHeight = this.image.getHeight(this.viewer.window);
            this.iWidth = this.image.getWidth(this.viewer.window);
            this.viewer.drag.setWorld(this.image, new Dimension(this.imageWidth(), this.imageHeight()), this.size());
            this.prepareImage(this.image, this.imageWidth(), this.imageHeight(), this);
            if (this.anchor != null && this.anchor.page == this.curPageNo) {
                this.viewer.imageCanvasPanel.setCoords(this.anchor.x, this.anchor.y);
                this.viewer.drag.setCoords(this.anchor.x, this.anchor.y);
                this.anchor = null;
            } else {
                this.viewer.imageCanvasPanel.setCoords(0, 0);
            }
        }
        this.viewer.printMessage("Page " + (this.curPageNo + 1) + " loading annotations");
        this.getAnnotations(this.curPageNo);
        this.viewer.printMessage("Page " + (this.curPageNo + 1) + " loaded successfully");
    }

    public int normalize(int n) {
        return (int)((float)n / this.factor);
    }

    public int scale(int n) {
        return (int)((float)n * this.factor);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.image != null && this.clickMode.equals(CM_ZOOM_REGION)) {
            int n3;
            int n4;
            if (this.window != null) {
                this.window = null;
                this.repaint();
            }
            if ((n4 = this.normalize(n + this.dx)) < 0) {
                n4 = 0;
            }
            if (n4 > this.iWidth) {
                n4 = this.iWidth;
            }
            if ((n3 = this.normalize(n2 + this.dy)) < 0) {
                n3 = 0;
            }
            if (n3 > this.iWidth) {
                n3 = this.iWidth;
            }
            this.window = new Rectangle(n4, n3, 1, 1);
            return true;
        }
        if (this.clickMode.equals(CM_PAN)) {
            this.px = this.dx + n;
            this.py = this.dy + n2;
            return true;
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.image != null && this.clickMode.equals(CM_ZOOM_REGION) && this.window != null) {
            int n3;
            Rectangle rectangle = this.window;
            this.window = null;
            this.repaint(rectangle);
            this.window = rectangle;
            int n4 = this.normalize(n + this.dx);
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 >= this.iWidth) {
                n4 = this.iWidth - 1;
            }
            if ((n3 = this.normalize(n2 + this.dy)) < 0) {
                n3 = 0;
            }
            if (n3 >= this.iHeight) {
                n3 = this.iHeight - 1;
            }
            this.window.width = n4 - this.window.x;
            this.window.height = n3 - this.window.y;
            this.repaint();
            return true;
        }
        if (this.clickMode.equals(CM_PAN)) {
            this.viewer.imageCanvasPanel.setCoords(this.px - n, this.py - n2);
            return true;
        }
        return super.mouseDrag(event, n, n2);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.image == null) {
            return false;
        }
        if (this.window != null) {
            this.window = this.makeDrawable(this.window);
        }
        if (this.clickMode.equals(CM_FOLLOW_LINK)) {
            if (this.current == null) {
                return false;
            }
            return this.DoShowDocument(this.current.target);
        }
        if (this.clickMode.equals(CM_ZOOM_IN)) {
            this.DoZoomIn(n + this.dx, n2 + this.dy);
        } else if (this.clickMode.equals(CM_ZOOM_REGION)) {
            this.DoZoomRegion(n + this.dx, n2 + this.dy);
        } else if (this.clickMode.equals(CM_ZOOM_OUT)) {
            this.DoZoomOut(n + this.dx, n2 + this.dy);
        }
        if (this.window != null) {
            this.window = null;
            this.repaint();
        }
        return true;
    }

    public Rectangle makeDrawable(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (n3 < 0) {
            n3 = -n3;
            n -= n3;
        }
        if (n4 < 0) {
            n4 = -n4;
            n2 -= n4;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public boolean DoShowDocument(String string) {
        this.viewer.printMessage("Looking for " + string);
        if (string.startsWith("#")) {
            int n;
            this.anchor = null;
            String string2 = string.substring(1);
            try {
                n = Integer.parseInt(string2) - 1;
                if (n < 0) {
                    throw new NumberFormatException("Negative Number");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.anchor = this.GetAnchor(string2);
                if (this.anchor == null) {
                    this.viewer.printMessage("Error: " + string + " not found.");
                    return false;
                }
                n = this.anchor.page;
            }
            ClientCanvas clientCanvas = this;
            synchronized (clientCanvas) {
                if (n != this.curPageNo) {
                    this.viewer.commandBar.CheckNGetPage(n);
                } else if (this.anchor != null) {
                    this.renderThread.SetCurrentPage(this.curPageNo);
                    this.viewer.imageCanvasPanel.setCoords(this.anchor.x, this.anchor.y);
                    this.anchor = null;
                }
            }
            this.viewer.printMessage("");
        } else {
            try {
                this.viewer.showDocument(new URL(string));
                this.viewer.printMessage("");
            }
            catch (MalformedURLException malformedURLException) {
                this.viewer.printMessage("Error: " + string + " is not a valid url");
                return false;
            }
        }
        return true;
    }

    public Anchor GetAnchor(String string) {
        Anchor anchor = (Anchor)this.anchors.get(string);
        if (anchor == null) {
            new Vector();
            int n = 0;
            while (n < this.numOfPages) {
                if (this.AnnotBuffer[n] == null) {
                    PageDescriptor pageDescriptor = this.viewer.curFile.getPageDescriptor(n);
                    this.pi_reader.ReadAnnotationHeader(pageDescriptor, this.viewer.curFile);
                    this.parseAnnotations(pageDescriptor.annot_hdr, n);
                    Enumeration enumeration = this.AnnotBuffer[n].getAnchors();
                    while (enumeration.hasMoreElements()) {
                        anchor = (Anchor)enumeration.nextElement();
                        if (!anchor.name.equals(string)) continue;
                        this.viewer.setCursor(0);
                        this.viewer.icon.animate();
                        return anchor;
                    }
                    anchor = null;
                }
                ++n;
            }
            return null;
        }
        return anchor;
    }

    public void DoZoomIn(int n, int n2) {
        float f = 2.0f * this.factor;
        if (f >= MAX_FACTOR) {
            this.cClickMode.select(CM_ZOOM_OUT);
            this.clickMode = CM_ZOOM_OUT;
            f = MAX_FACTOR;
        }
        int n3 = n - (int)((double)((float)this.size().width * this.factor) / (2.0 * (double)f));
        int n4 = n2 - (int)((double)((float)this.size().height * this.factor) / (2.0 * (double)f));
        this.viewer.imageCanvasPanel.setCoords(n3, n4);
        this.setFactor(f);
    }

    public void DoZoomOut(int n, int n2) {
        float f = 0.5f * this.factor;
        if ((double)f < 0.05) {
            this.cClickMode.select(CM_ZOOM_IN);
            this.clickMode = CM_ZOOM_IN;
        }
        int n3 = n - this.size().width;
        int n4 = n2 - this.size().height;
        this.viewer.imageCanvasPanel.setCoords(n3, n4);
        this.setFactor(f);
    }

    public void DoZoomRegion(int n, int n2) {
        if (this.image == null) {
            return;
        }
        int n3 = this.size().width;
        int n4 = this.size().height;
        if (this.window == null || this.window.width + this.window.height < 6) {
            return;
        }
        int n5 = this.scale(this.window.x);
        int n6 = this.scale(this.window.y);
        float f = (float)n3 / (float)this.window.width;
        if ((float)n4 / (float)this.window.height < f) {
            f = (float)n4 / (float)this.window.height;
        }
        if (f > MAX_FACTOR) {
            f = MAX_FACTOR;
            int n7 = this.window.x + this.window.width / 2;
            int n8 = this.window.y + this.window.height / 2;
            n5 = this.scale(n7 -= (int)((double)n3 / (2.0 * (double)f)));
            n6 = this.scale(n8 -= (int)((double)n4 / (2.0 * (double)f)));
        }
        this.viewer.imageCanvasPanel.setCoords(n5, n6);
        this.setFactor(f);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.annotations == null) {
            return super.mouseMove(event, n, n2);
        }
        int n3 = this.normalize(n + this.dx);
        int n4 = this.normalize(n2 + this.dy);
        if (this.current != null) {
            if (this.current.area.inside(n3, n4)) {
                return true;
            }
            this.viewer.setCursor(0);
            Rectangle rectangle = this.current.area;
            this.current = null;
            this.repaint(rectangle);
            this.viewer.printMessage("");
        }
        this.current = this.annotations.insideHL(n3, n4);
        if (this.current != null) {
            this.repaint(this.current.area);
            this.viewer.printMessage(this.current.target.toString());
            this.viewer.setCursor(12);
        }
        return true;
    }

    public boolean handleViewEvent(Event event) {
        if (event.id == 1001) {
            if (event.target == this.bZoomIn) {
                this.setFactor(2.0f * this.factor);
            } else if (event.target == this.bZoomOut) {
                this.setFactor(0.5f * this.factor);
            } else if (event.target == this.zsPanel) {
                this.setFactor(((Float)event.arg).floatValue());
            } else if (event.target == this.cClickMode) {
                String string = this.clickMode;
                this.clickMode = (String)event.arg;
                if (string.equals(CM_THUMBNAIL)) {
                    this.viewer.commandBar.DoCanvas();
                }
                if (this.clickMode.equals(CM_THUMBNAIL)) {
                    this.viewer.commandBar.DoPreview();
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public float ZoomPageWidthFactor() {
        float f = this.size().width;
        float f2 = f / (float)this.iWidth;
        return f2;
    }

    public float ZoomWholePageFactor() {
        float f = this.size().width;
        float f2 = f / (float)this.iWidth;
        float f3 = this.size().height;
        if (f2 > f3 / (float)this.iHeight) {
            f2 = f3 / (float)this.iHeight;
        }
        return f2;
    }

    public void setFactor(float f) {
        if (f >= MAX_FACTOR) {
            f = MAX_FACTOR;
            this.bZoomIn.disable();
        } else {
            this.bZoomIn.enable();
        }
        if (f == this.factor) {
            return;
        }
        this.dx = (int)((float)this.dx * f / this.factor);
        this.dy = (int)((float)this.dy * f / this.factor);
        this.factor = f;
        this.zooming = true;
        this.viewer.printMessage("Scaling to " + (int)((double)f * 100.0 + 0.5) + "%.");
        this.viewer.icon.animate();
        this.renderThread.setFactor(f);
        this.zsPanel.postEvent(new Event(this, 1001, new Float(f)));
    }

    public void repaint(Rectangle rectangle) {
        Rectangle rectangle2 = this.makeDrawable(rectangle);
        this.repaint(this.scale(rectangle2.x - this.dx), this.scale(rectangle2.y - this.dy), this.scale(rectangle2.width) + 1, this.scale(rectangle2.height) + 1);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void drawImage(Graphics graphics) {
        if (this.renderThread != null && this.renderThread.page_descriptor != null && this.renderThread.getImage() != null) {
            if (this.renderThread.getImage() != this.image) {
                this.newPage();
                return;
            }
            this.updateImageInfo(false);
            graphics.drawImage(this.image, 0, 0, this.imageWidth(), this.imageHeight(), this);
        }
    }

    public void drawNormal(Graphics graphics) {
        if (this.image != null) {
            if (this.clickMode == CM_FOLLOW_LINK) {
                if (this.AnnotBuffer != null && this.annotations == null) {
                    if (this.getAnnotations(this.curPageNo)) {
                        this.annotations.draw(graphics, this.factor);
                    }
                } else if (this.annotations != null) {
                    this.annotations.draw(graphics, this.factor);
                }
                if (this.current != null) {
                    this.current.drawHighlight(graphics, this.factor);
                    return;
                }
            } else if (this.window != null && this.clickMode == CM_ZOOM_REGION) {
                Rectangle rectangle = this.makeDrawable(this.window);
                graphics.setColor(Color.red);
                graphics.drawRect(this.scale(rectangle.x), this.scale(rectangle.y), this.scale(rectangle.width), this.scale(rectangle.height));
            }
        }
    }

    public void paint(Graphics graphics) {
        this.viewer.drag.setWorld(this.image, new Dimension(this.imageWidth(), this.imageHeight()), this.size());
        this.viewer.drag.setCoords(this.dx, this.dy);
        Image image = this.createImage(this.size().width, this.size().height);
        Graphics graphics2 = image.getGraphics();
        graphics2.translate(-this.dx, -this.dy);
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.size().width, this.size().height);
        this.drawImage(graphics2);
        this.drawNormal(graphics2);
        graphics.drawImage(image, 0, 0, this);
        if (this.zooming) {
            this.zooming = false;
            this.viewer.icon.normal();
            this.viewer.printMessage("");
        }
    }
}

