/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.ClientCanvas;
import COM.xerox.digipaper.applet.client.ClientFrame;
import COM.xerox.digipaper.applet.client.DragSurface;
import COM.xerox.digipaper.applet.client.Icon;
import COM.xerox.digipaper.applet.client.LimitedAccessCommandBar;
import COM.xerox.digipaper.applet.client.ScrollClientCanvas;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Label;
import java.net.URL;

public class Client
extends Applet {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected static String APPLET_THREAD_NAME = "Applet(main)";
    protected static int DEFAULT_SIZE_OF_PAGE_INFO_CACHE = 25;
    protected static int DEFAULT_SIZE_OF_IMAGE_CACHE = 3;
    protected static int DEFAULT_SIZE_OF_THUMBNAIL_CACHE = 30;
    public static int DEFAULT_SIZE_OF_TOKEN_DECODER_CACHE = 7;
    public int size_page_info_cache;
    public int size_image_cache;
    public int size_thumbnail_cache;
    public static final int FRAME_X_DIMENSION = 640;
    public static final int FRAME_Y_DIMENSION = 480;
    public boolean isApplet = false;
    public ClientCanvas imageCanvas;
    public LimitedAccessCommandBar commandBar;
    public ScrollClientCanvas imageCanvasPanel;
    public Container window;
    public Label message;
    public Icon icon;
    public DragSurface drag;
    public XIFFFile curFile;
    public URL url;

    public void init() {
        this.isApplet = true;
        this.url = this.getDocumentBase();
        super.init();
        String string = this.getParameter("fileLoc");
        String string2 = this.getParameter("PAGE");
        this.getParameter("NOFRAME");
        String string3 = this.getParameter("FRAME");
        String string4 = this.getParameter("ANCHOR");
        if (string3 != null) {
            int n;
            int n2;
            try {
                n2 = Integer.parseInt(this.getParameter("F_WIDTH"));
            }
            catch (Exception exception) {
                n2 = 640;
            }
            try {
                n = Integer.parseInt(this.getParameter("F_HEIGHT"));
            }
            catch (Exception exception) {
                n = 480;
            }
            ClientFrame clientFrame = new ClientFrame(this, "DigiPaper Viewer");
            clientFrame.resize(n2, n);
            this.setUp(clientFrame);
        } else {
            this.setUp(this);
        }
        string4 = string4 == null ? string2 : string4.substring(1, string4.length());
        try {
            this.commandBar.DoOpenURL(string, string4);
            return;
        }
        catch (Exception exception) {
            dbg.dprint(String.valueOf(string) + " could not be opened. Exiting.", DebugInfoPrinter.DBUG_ERROR);
            dbg.dprint(exception.toString(), DebugInfoPrinter.DBUG_ERROR);
            exception.printStackTrace();
            this.add("Center", new Label("file access failure, please notify author."));
            return;
        }
    }

    public void showDocument(URL uRL) {
        if (this.isApplet) {
            this.getAppletContext().showDocument(uRL, "xiff_link");
        }
    }

    public void setCursor(int n) {
        if (this.window instanceof Frame) {
            ((Frame)this.window).setCursor(n);
        }
    }

    public URL printLoc() {
        try {
            this.getAppletContext();
            return new URL(this.getParameter("PRINT"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void kill() {
        if (this.isApplet) {
            this.destroy();
            return;
        }
        ((Frame)this.window).dispose();
        this.commandBar.kill();
        this.imageCanvas.kill();
        System.exit(0);
    }

    public void stop() {
        this.commandBar.flush_caches();
        System.gc();
    }

    public void destroy() {
        if (this.window instanceof Frame) {
            ((Frame)this.window).dispose();
            ((Component)((Frame)this.window)).hide();
        }
        if (this.commandBar != null) {
            this.commandBar.kill();
        }
        if (this.imageCanvas != null) {
            this.imageCanvas.kill();
        }
        this.commandBar = null;
        this.imageCanvas = null;
        this.imageCanvasPanel = null;
        this.message = null;
        this.window = null;
        this.curFile = null;
        this.url = null;
        this.removeAll();
        this.invalidate();
        this.validate();
        super.destroy();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.isApplet && this.commandBar == null) {
            this.init();
        }
        return super.mouseDown(event, n, n2);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.kill();
        }
        if (event.id == 1001) {
            this.commandBar.action(event, event.target);
        }
        return super.handleEvent(event);
    }

    public void setUp(Container container) {
        Thread.currentThread().setName(APPLET_THREAD_NAME);
        this.size_page_info_cache = DEFAULT_SIZE_OF_PAGE_INFO_CACHE;
        this.size_image_cache = DEFAULT_SIZE_OF_IMAGE_CACHE;
        this.size_thumbnail_cache = DEFAULT_SIZE_OF_THUMBNAIL_CACHE;
        dbg.dprint("Properties of this version of the Digipaper client:\n   -- built Wed Jun 17 22:09:56 EDT 1998\n   -- size of image cache is " + this.size_image_cache + "\n" + "   -- size of page info cache is " + this.size_page_info_cache + "\n" + "   -- size of thumbnail cache is " + this.size_thumbnail_cache + "\n" + "   -- size of token decoder cache is " + DEFAULT_SIZE_OF_TOKEN_DECODER_CACHE + "\n" + "   -- is a debug version? YES\n", DebugInfoPrinter.DBUG_CLIENT_CONTROL);
        dbg.dprint("Client Initialized.. opening file.", DebugInfoPrinter.DBUG_CLIENT_CONTROL);
        this.DoLayout(container);
    }

    public void DoLayout(Container container) {
        this.window = container;
        try {
            if (this.url == null) {
                this.url = new URL("http://");
            }
        }
        catch (Exception exception) {}
        container.setLayout(new BorderLayout());
        dbg.dprint("Creating ClientCanvas", DebugInfoPrinter.DBUG_GRAPHICS);
        this.imageCanvasPanel = new ScrollClientCanvas(this);
        this.imageCanvas = this.imageCanvasPanel.canvas;
        this.message = new Label("Welcome to DigiPaper");
        this.drag = new DragSurface();
        if (this.isApplet) {
            this.icon = new Icon(this.getImage(this.getCodeBase(), "dpx.gif"));
        }
        if (this.icon == null) {
            this.icon = new Icon(null);
        }
        this.createCommandbar();
        dbg.dprint("Adding components", DebugInfoPrinter.DBUG_GRAPHICS);
        container.add("North", this.commandBar);
        container.add("Center", this.imageCanvasPanel);
        container.invalidate();
        container.validate();
        dbg.dprint("Calling show() on container", DebugInfoPrinter.DBUG_GRAPHICS);
        container.show();
        dbg.dprint("Set up complete", DebugInfoPrinter.DBUG_GRAPHICS);
    }

    public void createCommandbar() {
        dbg.dprint("Creating Commandbar", DebugInfoPrinter.DBUG_GRAPHICS);
        this.commandBar = new LimitedAccessCommandBar(this, this.getParameter("docType"));
    }

    public void printMessage(String string) {
        this.message.setText(string);
        this.message.invalidate();
        this.commandBar.validate();
    }
}

