/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.Anchor;
import COM.xerox.digipaper.applet.client.LinkRegion;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTable;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableEntry;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableHeader;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class AnnotMgr {
    public static final int HL_TYPE = 20;
    public static final int ANCHOR_TYPE = 21;
    protected Vector links;
    protected Vector otherAnnot;
    protected Vector anchors;

    public AnnotMgr(AnnotationTableHeader annotationTableHeader, int n) {
        if (annotationTableHeader != null) {
            this.init(annotationTableHeader.table, n);
        }
    }

    protected void init(AnnotationTable annotationTable, int n) {
        this.links = new Vector(annotationTable.entries.size());
        this.anchors = new Vector(annotationTable.entries.size());
        this.otherAnnot = new Vector(annotationTable.entries.size());
        Enumeration enumeration = annotationTable.entries();
        while (enumeration.hasMoreElements()) {
            AnnotationTableEntry annotationTableEntry = (AnnotationTableEntry)enumeration.nextElement();
            switch (annotationTableEntry.type) {
                case 20: {
                    this.parseHL(annotationTableEntry);
                    break;
                }
                case 21: {
                    this.parseAnchor(annotationTableEntry, n);
                    break;
                }
                default: {
                    this.parseOther(annotationTableEntry);
                }
            }
        }
    }

    public void parseOther(AnnotationTableEntry annotationTableEntry) {
        this.otherAnnot.addElement(annotationTableEntry);
    }

    public void parseAnchor(AnnotationTableEntry annotationTableEntry, int n) {
        this.anchors.addElement(new Anchor(annotationTableEntry, n));
    }

    public void parseHL(AnnotationTableEntry annotationTableEntry) {
        this.links.addElement(new LinkRegion(annotationTableEntry));
    }

    public Enumeration getAnchors() {
        return this.anchors.elements();
    }

    public void draw(Graphics graphics, float f) {
        this.drawHL(graphics, f);
    }

    public void drawHL(Graphics graphics, float f) {
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            LinkRegion linkRegion = (LinkRegion)enumeration.nextElement();
            linkRegion.draw(graphics, f);
        }
    }

    public LinkRegion insideHL(int n, int n2) {
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            LinkRegion linkRegion = (LinkRegion)enumeration.nextElement();
            if (!linkRegion.area.inside(n, n2)) continue;
            return linkRegion;
        }
        return null;
    }

    public int linkCount() {
        return this.links.size();
    }
}

