/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.client.LimitedAccessCommandBar;
import COM.xerox.digipaper.applet.client.OpenFileDialog;
import COM.xerox.digipaper.applet.client.OpenURLDialog;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.caching.RequestForDocument;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Panel;
import java.io.IOException;
import java.net.URL;

public class AccessCommandBar
extends LimitedAccessCommandBar {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected Button bOpenFile;
    protected Button bOpenURL;
    protected Button bHelp;
    protected Button bExit;
    public Panel pFile;

    public AccessCommandBar(Client client) {
        super(client, null);
    }

    public void init() {
        super.init();
        this.pFile = new Panel();
        this.bOpenFile = new Button("Open File...");
        this.bOpenURL = new Button("Open URL...");
        this.bHelp = new Button("Help");
        this.bExit = new Button("Close");
        this.pFile.add(this.bOpenFile);
        this.pFile.add(this.bOpenURL);
        this.pFile.add(this.bHelp);
        this.pFile.add(this.bExit);
        this.add(this.pFile);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.bOpenFile) {
            this.DoOpenFileWindow();
        } else if (event.target == this.bOpenURL) {
            this.DoOpenURLWindow();
        } else if (event.target == this.bHelp) {
            this.DoHelp();
        } else if (event.target == this.bExit) {
            this.viewer.kill();
        } else {
            return super.action(event, object);
        }
        return true;
    }

    public void DoOpenFile(String string, String string2) throws Exception {
        try {
            this.DoOpen(new XIFFFile(string), string, string2);
            return;
        }
        catch (Exception exception) {
            dbg.dprint("File Open failed, trying URL ---------------\n", DebugInfoPrinter.DBUG_ERROR);
            dbg.dprint(exception.toString(), DebugInfoPrinter.DBUG_ERROR);
            exception.printStackTrace();
            this.DoOpenURL(string, string2);
            return;
        }
    }

    public void DoOpenURL(URL uRL, String string) throws Exception {
        try {
            RequestForDocument requestForDocument = new RequestForDocument(uRL, this.docType);
            XIFFFile xIFFFile = (XIFFFile)LimitedAccessCommandBar.xifffile_getter.getObject(requestForDocument);
            if (xIFFFile == null) {
                throw new IOException("Couldn't open file at url " + uRL);
            }
            this.DoOpen(xIFFFile, null, string);
            return;
        }
        catch (Exception exception) {
            this.location.setText("Could not find file");
            dbg.dprint("URL Open failed -----------------", DebugInfoPrinter.DBUG_ERROR);
            dbg.dprint(exception.toString(), DebugInfoPrinter.DBUG_ERROR);
            exception.printStackTrace();
            throw exception;
        }
    }

    protected void DoOpenFileWindow() {
        new OpenFileDialog(this, (Frame)this.viewer.window);
    }

    protected void DoOpenURLWindow() {
        new OpenURLDialog(this);
    }

    protected void DoHelp() {
        this.viewer.printMessage("No Help currently available. mho@parc.xerox.com");
    }

    protected void DoAbout() {
        this.viewer.printMessage("DigiPaper XIFF Viewer, mho@parc.xerox.com");
    }
}

