/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.WJRim;

import COM.xerox.digipaper.applet.WJRim.MaskingImageFilter;
import COM.xerox.digipaper.applet.WJRim.PackedImage;
import COM.xerox.digipaper.util.DebugInfoPrinter;

public class MaskingImageFilterWithBoundsChecking
extends MaskingImageFilter {
    static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected int xoffset;
    protected int yoffset;
    protected boolean ob_opaque;
    protected int min_mask_x_RGB;
    protected int min_mask_y_RGB;
    protected int max_mask_x_RGB;
    protected int max_mask_y_RGB;

    public MaskingImageFilterWithBoundsChecking(PackedImage packedImage, int n, int n2, boolean bl) {
        super(packedImage);
        this.ob_opaque = bl;
        this.xoffset = n;
        this.yoffset = n2;
        this.min_mask_x_RGB = n;
        this.min_mask_y_RGB = n2;
        this.max_mask_x_RGB = packedImage.width + n - 1;
        this.max_mask_y_RGB = packedImage.height + n2 - 1;
    }

    public int filterRGB(int n, int n2, int n3) {
        boolean bl = n > this.max_mask_x_RGB || n < this.min_mask_x_RGB || n2 > this.max_mask_y_RGB || n2 < this.min_mask_y_RGB ? this.ob_opaque : this.opaque(n, n2);
        if (bl) {
            return n3 | 0xFF000000;
        }
        return n3 & 0xFFFFFF;
    }

    boolean opaque(int n, int n2) {
        int n3 = n - this.xoffset;
        long l = this.mask.data[n2 - this.yoffset][n3 / 64];
        return (l & Long.MIN_VALUE >>> n3 % 64) != 0L;
    }
}

