/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.WJRim;

import COM.xerox.digipaper.applet.WJRim.G4State;
import COM.xerox.digipaper.applet.WJRim.G4Tables;
import COM.xerox.digipaper.applet.WJRim.MalformedTKPException;
import COM.xerox.digipaper.applet.WJRim.PackedImage;

public class G4 {
    public static void uncompressG4(byte[] byArray, int n, PackedImage packedImage) throws MalformedTKPException {
        if (!G4Tables.inited) {
            G4Tables.init();
        }
        G4State g4State = new G4State();
        g4State.data = 0;
        g4State.bit = 0;
        g4State.dataleft = byArray.length;
        g4State.rowlongs = (packedImage.width + 63) / 64;
        g4State.rowpixels = packedImage.width;
        g4State.nrows = packedImage.height;
        g4State.rownum = 0;
        g4State.cdata = byArray;
        g4State.cdataoffset = n;
        g4State.refline = new long[g4State.rowlongs + 1];
        while (g4State.rownum != g4State.nrows) {
            g4State.row = packedImage.data[g4State.rownum];
            G4.g4Decode2DRow(g4State, g4State.row, g4State.rowpixels);
            g4State.refline = g4State.row;
            ++g4State.rownum;
        }
    }

    private static void g4Decode2DRow(G4State g4State, long[] lArray, int n) throws MalformedTKPException {
        int n2 = -1;
        int n3 = 0;
        short s = g4State.bit;
        short s2 = g4State.data;
        while (true) {
            if (s == 0 || s > 7) {
                s2 = g4State.fetchByte();
            }
            int n4 = G4Tables.g4Fax2DFSM[s][s2];
            s = (short)(n4 & 0xFF);
            if ((n4 >>= 8) == 0) continue;
            switch (n4) {
                case 1: {
                    int n5 = G4.finddiff(g4State.refline, n2, n, 1 - n3);
                    int n6 = G4.finddiff(g4State.refline, n5, n, n3);
                    n5 = G4.finddiff(g4State.refline, n6, n, 1 - n3);
                    if (n3 != 0) {
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        G4.fillspan(lArray, n2, n5 - n2);
                    }
                    n2 = n5;
                    break;
                }
                case 2: {
                    int n7;
                    int n8;
                    g4State.bit = s;
                    g4State.data = s2;
                    if (n3 == 0) {
                        n8 = G4.decode_white_run(g4State);
                        n7 = G4.decode_black_run(g4State);
                    } else {
                        n8 = G4.decode_black_run(g4State);
                        n7 = G4.decode_white_run(g4State);
                    }
                    s = g4State.bit;
                    s2 = g4State.data;
                    if (n8 < 0 || n7 < 0) break;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 + n8 > n) {
                        n8 = n - n2;
                    }
                    if (n3 != 0) {
                        G4.fillspan(lArray, n2, n8);
                    }
                    if ((n2 += n8) + n7 > n) {
                        n7 = n - n2;
                    }
                    if (n3 == 0) {
                        G4.fillspan(lArray, n2, n7);
                    }
                    n2 += n7;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    int n5 = G4.finddiff(g4State.refline, n2, n, 1 - n3);
                    int n6 = G4.finddiff(g4State.refline, n5, n, n3);
                    n6 += n4 - 6;
                    if (n3 != 0) {
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        G4.fillspan(lArray, n2, n6 - n2);
                    }
                    n3 = 1 - n3;
                    n2 = n6;
                    break;
                }
                case 10: {
                    throw new MalformedTKPException("uncompressed mode");
                }
                case 11: 
                case 12: {
                    throw new MalformedTKPException("Bad 2D code word at scanline " + g4State.rownum);
                }
                default: {
                    throw new MalformedTKPException("Panic, bad decoding state at scanline " + g4State.rownum);
                }
            }
            if (n2 >= n) break;
        }
        g4State.bit = s;
        g4State.data = s2;
    }

    static final int finddiff(long[] lArray, int n, int n2, int n3) {
        if (n3 == 1) {
            return n + G4.find1span(lArray, n, n2);
        }
        return n + G4.find0span(lArray, n, n2);
    }

    static final int find0span(long[] lArray, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        int n5 = n >> 6;
        int n6 = n & 0x3F;
        if (n < 0) {
            int n7 = -n + G4.find0span(lArray, 0, n2);
            return n7;
        }
        if (n4 > 0 && n6 > 0) {
            n3 = lArray[n5] << n6 != 0L ? G4.zeroruns(lArray[n5] << n6) : 64 - n6;
            if (n3 > n4) {
                n3 = n4;
            }
            if (n6 + n3 < 64) {
                return n3;
            }
            ++n5;
            n4 -= n3;
        } else {
            n3 = 0;
        }
        while (n4 >= 64) {
            if (lArray[n5] != 0L) {
                return n3 += G4.zeroruns(lArray[n5]);
            }
            n3 += 64;
            n4 -= 64;
            ++n5;
        }
        if (n4 > 0) {
            n6 = G4.zeroruns(lArray[n5]);
            n3 += n6 > n4 ? n4 : n6;
        }
        return n3;
    }

    static final int zeroruns(long l) {
        int n = 0;
        if (l >>> 32 != 0L) {
            l >>>= 32;
        } else {
            n += 32;
        }
        if (l >> 16 != 0L) {
            l >>= 16;
        } else {
            n += 16;
        }
        if (l >> 8 != 0L) {
            l >>= 8;
        } else {
            n += 8;
        }
        if (l >> 4 != 0L) {
            l >>= 4;
        } else {
            n += 4;
        }
        if (l >> 2 != 0L) {
            l >>= 2;
        } else {
            n += 2;
        }
        if (l >> 1 != 0L) {
            l >>= 1;
        } else {
            ++n;
        }
        if (l == 0L) {
            ++n;
        }
        return n;
    }

    static final int find1span(long[] lArray, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        int n5 = n >> 6;
        int n6 = n & 0x3F;
        if (n < 0) {
            return 0;
        }
        if (n4 > 0 && n6 > 0) {
            if (lArray[n5] << n6 != -1L << n6) {
                int n7 = G4.zeroruns(lArray[n5] << n6 ^ 0xFFFFFFFFFFFFFFFFL);
                if (n7 > n4) {
                    n7 = n4;
                }
                return n7;
            }
            ++n5;
            n3 = 64 - n6;
            n4 -= n3;
        } else {
            n3 = 0;
        }
        while (n4 >= 64) {
            if (lArray[n5] != -1L) {
                return n3 += G4.zeroruns(lArray[n5] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            n3 += 64;
            n4 -= 64;
            ++n5;
        }
        if (n4 > 0) {
            n6 = G4.zeroruns(lArray[n5] ^ 0xFFFFFFFFFFFFFFFFL);
            n3 += n6 > n4 ? n4 : n6;
        }
        return n3;
    }

    static final void fillspan(long[] lArray, int n, int n2) {
        if (n2 > 0) {
            int n3 = n & 0x3F;
            int n4 = n / 64;
            if (n3 + n2 <= 64) {
                if (n3 > 0) {
                    int n5 = n4;
                    lArray[n5] = lArray[n5] | (-1L << 64 - n3 ^ 0xFFFFFFFFFFFFFFFFL) & -1L << 64 - n3 - n2;
                    return;
                }
                int n6 = n4;
                lArray[n6] = lArray[n6] | -1L << 64 - n2;
                return;
            }
            if (n3 > 0) {
                int n7 = n4++;
                lArray[n7] = lArray[n7] | -1L << 64 - n3 ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                lArray[n4++] = -1L;
            }
            n2 -= 64 - n3;
            while (n2 >= 64) {
                lArray[n4++] = -1L;
                n2 -= 64;
            }
            if (n2 > 0) {
                int n8 = n4;
                lArray[n8] = lArray[n8] | -1L << 64 - n2;
            }
        }
    }

    static final int decode_white_run(G4State g4State) throws MalformedTKPException {
        return G4.decode_run(g4State, 0);
    }

    static final int decode_black_run(G4State g4State) throws MalformedTKPException {
        return G4.decode_run(g4State, 8);
    }

    static final int decode_run(G4State g4State, int n) throws MalformedTKPException {
        int n2 = g4State.bit;
        int n3 = 0;
        while (true) {
            if (n2 == 0) {
                if (g4State.dataleft <= 0) {
                    return -3;
                }
                g4State.data = g4State.fetchByte();
            }
            n2 = G4Tables.g4Fax1DFSM[n2 + n][g4State.data & 0xFF] & 0xFFFF;
            int n4 = n2 >> 8;
            n2 &= 0xFF;
            if (n4 == 0) {
                if (n2 == 0) continue;
                if (g4State.dataleft <= 0) {
                    return -3;
                }
                g4State.data = g4State.fetchByte();
                continue;
            }
            g4State.bit = (short)n2;
            if ((n4 -= 3) < 0) {
                return n4;
            }
            if (n4 < 64) {
                return n3 + n4;
            }
            n3 += 64 * (n4 - 64);
        }
    }
}

