/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.util.caching;

import COM.xerox.digipaper.util.CanBeNotified;
import COM.xerox.digipaper.util.CanGetObjects;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import COM.xerox.digipaper.util.caching.CanCacheObjects;
import COM.xerox.digipaper.util.caching.CanDisposeOfObjects;
import COM.xerox.digipaper.util.caching.CanPrefetchObjects;
import COM.xerox.digipaper.util.caching.CanProduceGetters;
import COM.xerox.digipaper.util.caching.GenericCache;
import java.util.Enumeration;
import java.util.Hashtable;

public class CachingPrefetcher
implements CanPrefetchObjects,
CanBeNotified,
CanDisposeOfObjects {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected CanProduceGetters gtp;
    protected CanCacheObjects cache;
    protected boolean stop_old_job;
    protected int max_num_getters;
    protected int num_getters;
    protected String name;
    protected Hashtable all_getters;
    protected Hashtable keys_get;
    protected CanCacheObjects getters_prefetch;
    protected Hashtable recipients;

    public CachingPrefetcher(CanProduceGetters canProduceGetters, CanCacheObjects canCacheObjects, boolean bl, int n) {
        this(canProduceGetters, canCacheObjects, bl, n, "");
    }

    public CachingPrefetcher(CanProduceGetters canProduceGetters, CanCacheObjects canCacheObjects, boolean bl, int n, String string) {
        int n2 = canCacheObjects.maxNumObjectsInCache();
        this.name = string;
        this.gtp = canProduceGetters;
        this.cache = canCacheObjects;
        this.stop_old_job = bl;
        this.max_num_getters = n;
        this.num_getters = 0;
        if (n2 <= 0) {
            this.keys_get = new Hashtable();
            this.all_getters = new Hashtable();
        } else {
            this.keys_get = new Hashtable(canCacheObjects.maxNumObjectsInCache());
            this.all_getters = new Hashtable(canCacheObjects.maxNumObjectsInCache());
        }
        this.getters_prefetch = new GenericCache(n - 1, this);
        this.recipients = new Hashtable();
    }

    protected void gctop_dprint(String string) {
    }

    protected void stop_a_getter(Object object, Object object2, boolean bl) {
        CanGetObjects canGetObjects;
        Hashtable hashtable = (Hashtable)this.recipients.get(object2);
        if (hashtable != null) {
            if (object == null) {
                return;
            }
            hashtable.remove(object);
            if (!hashtable.isEmpty()) {
                return;
            }
        }
        if ((canGetObjects = (CanGetObjects)this.all_getters.remove(object2)) == null) {
            this.gctop_dprint("::stop_a_getter() no getter to stop for key " + object2.toString() + ".");
            return;
        }
        this.gctop_dprint("::stop_a_getter() stopping the getter for key " + object2.toString() + ".");
        canGetObjects.stopGettingObject(this, object2);
        if (object == null) {
            if (bl) {
                this.getters_prefetch.flushObject(object2);
            }
        } else {
            this.recipients.remove(object2);
            this.keys_get.remove(object);
        }
        this.gctop_dprint("::stop_a_getter() DECREMENTing num_getters");
        --this.num_getters;
    }

    public void dispose(Object object, Object object2) {
        if (this.all_getters.get(object) != null) {
            this.stop_a_getter(null, object, false);
        }
    }

    protected CanGetObjects start_a_getter(CanBeNotified canBeNotified, Object object, Boolean bl) {
        CanGetObjects canGetObjects = this.gtp.newGetter(bl);
        if (canGetObjects == null) {
            return null;
        }
        if (canBeNotified != null) {
            this.keys_get.put(canBeNotified, object);
            this.add_to_hashtable_in_recipients(object, canBeNotified);
        } else {
            this.getters_prefetch.setObject(object, canGetObjects);
        }
        this.all_getters.put(object, canGetObjects);
        ++this.num_getters;
        canGetObjects.startGettingObject(this, object);
        return canGetObjects;
    }

    protected boolean add_to_hashtable_in_recipients(Object object, CanBeNotified canBeNotified) {
        Hashtable<CanBeNotified, CanBeNotified> hashtable = (Hashtable<CanBeNotified, CanBeNotified>)this.recipients.get(object);
        boolean bl = false;
        if (hashtable == null) {
            hashtable = new Hashtable<CanBeNotified, CanBeNotified>();
            this.recipients.put(object, hashtable);
            bl = true;
        }
        hashtable.put(canBeNotified, canBeNotified);
        return bl;
    }

    public synchronized boolean startGettingObject(CanBeNotified canBeNotified, Object object) {
        CanGetObjects canGetObjects;
        this.gctop_dprint("::startGettingObject() starts.");
        Object v = this.keys_get.get(canBeNotified);
        if (object.equals(v)) {
            this.gctop_dprint("::startGettingObject() returns.");
            return true;
        }
        if (v != null) {
            canGetObjects = (CanGetObjects)this.all_getters.get(v);
            if (this.stop_old_job) {
                this.stop_a_getter(canBeNotified, v, true);
            } else {
                this.gctop_dprint("::startGettingObject() ends (false returned).");
                return false;
            }
        }
        if ((canGetObjects = (CanGetObjects)this.all_getters.get(object)) != null) {
            this.gctop_dprint("::startGettingObject() already getting object corresponding to key " + object.toString() + " with getter " + canGetObjects.toString() + ".");
            if (this.add_to_hashtable_in_recipients(object, canBeNotified)) {
                this.keys_get.put(canBeNotified, object);
                this.all_getters.remove(object);
                this.getters_prefetch.flushObject(object);
                this.all_getters.put(object, canGetObjects);
            }
            this.gctop_dprint("::startGettingObject() returns (already prefetching object).");
            return true;
        }
        Object object2 = this.cache.getObject(object);
        if (object2 != null) {
            canBeNotified.Update(true, object, object2);
            this.gctop_dprint("::startGettingObject() ends.");
            return true;
        }
        if (this.num_getters == this.max_num_getters && this.getters_prefetch.numObjectsInCache() == 0) {
            this.gctop_dprint("::startGettingObject() about to wait...");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.start_a_getter(canBeNotified, object, Boolean.TRUE) == null) {
            this.gctop_dprint("::startGettingObject() ends (problem starting getter).");
            return false;
        }
        this.gctop_dprint("::startGettingObject() ends.");
        return true;
    }

    public void stopGettingObject(CanBeNotified canBeNotified, Object object) {
        if (this.keys_get.get(canBeNotified) == null) {
            canBeNotified = null;
        }
        this.stop_a_getter(canBeNotified, object, true);
    }

    public void dprint_state() {
        if (this.max_num_getters <= 0) {
            return;
        }
        this.gctop_dprint(" is in the following state:");
        String string = "";
        Enumeration<Object> enumeration = this.keys_get.elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + " " + enumeration.nextElement().toString();
        }
        dbg.dprint("    getting:" + string + ".", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
        dbg.dprint("    prefetching:" + this.getters_prefetch.toString() + ".", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
        string = "";
        enumeration = this.all_getters.keys();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + " " + enumeration.nextElement().toString();
        }
        dbg.dprint("    all_getters:" + string + ".", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
        string = "";
        enumeration = this.recipients.keys();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + " " + enumeration.nextElement().toString();
        }
        dbg.dprint("    recipients:" + string + ".", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
        dbg.dprint("    num_getters == " + this.num_getters + ".", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
    }

    public synchronized void Update(boolean bl, Object object, Object object2) {
        if (!bl) {
            return;
        }
        this.gctop_dprint("::Update() starts.");
        this.cache.setObject(object, object2);
        Hashtable hashtable = (Hashtable)this.recipients.remove(object);
        this.all_getters.remove(object);
        this.gctop_dprint("::Update() DECREMENTing num_getters");
        --this.num_getters;
        if (hashtable == null) {
            this.gctop_dprint("::Update() we were prefetching.");
            this.getters_prefetch.flushObject(object);
        } else {
            this.gctop_dprint("::Update() decrementing num_getters");
            this.notify();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                CanBeNotified canBeNotified = (CanBeNotified)enumeration.nextElement();
                this.keys_get.remove(canBeNotified);
                canBeNotified.Update(true, object, object2);
            }
        }
        this.gctop_dprint("::Update() ends (cache size is " + this.cache.numObjectsInCache() + ").");
    }

    public synchronized void prefetchObject(Object object) {
        this.gctop_dprint("::prefetchObject() starts.");
        if (this.cache.getObject(object) != null) {
            this.gctop_dprint("::prefetchObject() ends (object in cache).");
            return;
        }
        if (this.all_getters.get(object) != null) {
            this.gctop_dprint("::prefetchObject() ends (already prefetching or getting object).");
            return;
        }
        this.gctop_dprint("::prefetchObject() num_getters == " + this.num_getters + " before starting new one");
        if (this.num_getters == this.max_num_getters && this.stop_old_job && this.getters_prefetch.numObjectsInCache() == 0) {
            return;
        }
        CanGetObjects canGetObjects = this.start_a_getter(null, object, Boolean.FALSE);
        if (canGetObjects == null) {
            this.gctop_dprint("::prefetchObject() ends (error starting getter).");
            return;
        }
        this.gctop_dprint("::prefetchObject() ends.");
    }
}

