/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info.tc;

import COM.xerox.digipaper.applet.WJRim.MalformedTKPException;
import COM.xerox.digipaper.applet.WJRim.PackedImage;
import COM.xerox.digipaper.applet.xiff.IFD;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.IFDInfoBinaryImage;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.Bitfile;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.Decoder;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.TokenDecoder;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.TokenPos;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class IFDInfoPosBlock
extends IFDInfoBinaryImage {
    protected URL url;
    public TokenDecoder tokDec;
    TokenPos[] pos;
    protected int xPos;
    protected int yPos;
    protected Vector residuals;
    int width;
    int height;
    int fgColor;
    int bgColor;
    public static int DEFAULT_FGCOLOR = -16777216;
    public static int DEFAULT_BGCOLOR = 0xFFFFFF;
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    static final byte[] deltaXDecoder0bits;
    static final byte[] deltaXDecoder0state;
    static final short[] deltaXDecoder0offset;
    static final byte[] deltaXDecoder1bits;
    static final byte[] deltaXDecoder1state;
    static final short[] deltaXDecoder1offset;
    static final byte[] deltaXDecoder2bits;
    static final byte[] deltaXDecoder2state;
    static final short[] deltaXDecoder2offset;
    static final byte[] firstXDecoder0bits;
    static final byte[] firstXDecoder0state;
    static final short[] firstXDecoder0offset;
    static final byte[] firstXDecoder1bits;
    static final byte[] firstXDecoder1state;
    static final short[] firstXDecoder1offset;
    static final byte[] deltaYDecoder0bits;
    static final byte[] deltaYDecoder0state;
    static final short[] deltaYDecoder0offset;
    static final byte[] deltaYDecoder1bits;
    static final byte[] deltaYDecoder1state;
    static final short[] deltaYDecoder1offset;
    static final byte[] deltaYDecoder2bits;
    static final byte[] deltaYDecoder2state;
    static final short[] deltaYDecoder2offset;
    static Decoder deltaXDecoder0;
    static Decoder deltaXDecoder1;
    static Decoder deltaXDecoder2;
    static Decoder[] deltaXDecoders;
    static Decoder firstXDecoder0;
    static Decoder firstXDecoder1;
    static Decoder[] firstXDecoders;
    static Decoder deltaYDecoder0;
    static Decoder deltaYDecoder1;
    static Decoder deltaYDecoder2;
    static Decoder[] deltaYDecoders;

    IFDInfoPosBlock(IFD iFD, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, TokenDecoder tokenDecoder, XIFFFile xIFFFile, URL uRL) throws MalformedTKPException, IOException {
        super(iFD, (PackedImage)null);
        this.url = uRL;
        this.tokDec = tokenDecoder;
        this.width = n6;
        this.height = n7;
        this.xPos = n4;
        this.yPos = n5;
        this.residuals = null;
        this.fgColor = DEFAULT_FGCOLOR;
        this.bgColor = DEFAULT_BGCOLOR;
        this.ParsePosBlock(byArray, n);
    }

    void ParsePosBlock(byte[] byArray, int n) throws MalformedTKPException {
        int n2;
        int n3;
        Bitfile bitfile = new Bitfile(byArray, n);
        int n4 = bitfile.readValue();
        this.pos = new TokenPos[n4];
        int n5 = bitfile.readCode(4);
        int n6 = bitfile.readCode(2) + 1;
        if (n6 == 1) {
            n3 = 0;
        } else if (n6 == 2) {
            n3 = 1;
        } else if (n6 == 4) {
            n3 = 2;
        } else {
            throw new MalformedTKPException("Bad strip size.");
        }
        int n7 = bitfile.readCode(2);
        int n8 = bitfile.readCode(2);
        int n9 = bitfile.readCode(2);
        Decoder decoder = firstXDecoders[n7];
        Decoder decoder2 = deltaXDecoders[n8];
        Decoder decoder3 = deltaYDecoders[n9];
        boolean bl = bitfile.readCode(1) == 1;
        int n10 = -1 >> n3 << n3;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        while ((n10 += (n2 = decoder3.readEncoded(bitfile)) << n3) < (bl ? this.width : this.height)) {
            int n14;
            n11 = n12 = decoder.readEncoded(bitfile) + n11;
            int n15 = n3 != 0 ? bitfile.readCode(n3) : 0;
            int n16 = this.tokDec.readTokenCode(bitfile);
            this.pos[n13] = bl ? new TokenPos(this.xPos + n10, this.yPos + n12 + n15, n16) : new TokenPos(this.xPos + n12, this.yPos + n10 + n15 - (this.tokDec.mAllToks[n16].height - 1), n16);
            n12 += bl ? this.tokDec.mAllToks[n16].height : this.tokDec.mAllToks[n16].width;
            ++n13;
            while ((n14 = decoder2.readEncoded(bitfile)) != 100000) {
                n15 = n3 != 0 ? bitfile.readCode(n3) : 0;
                n16 = this.tokDec.readTokenCode(bitfile);
                this.pos[n13] = bl ? new TokenPos(this.xPos + n10, this.yPos + n12 + n15, n16) : new TokenPos(this.xPos + (n12 += (n14 += n5)), this.yPos + n10 + n15 - (this.tokDec.mAllToks[n16].height - 1), n16);
                n12 += bl ? this.tokDec.mAllToks[n16].height : this.tokDec.mAllToks[n16].width;
                ++n13;
            }
        }
    }

    void adjustTokenPos(TokenPos tokenPos) {
        PackedImage packedImage = this.tokDec.mAllToks[tokenPos.tok];
        if (tokenPos.x + packedImage.width > this.width) {
            tokenPos.x = this.width - packedImage.width;
        }
        if (tokenPos.y + packedImage.height > this.height) {
            tokenPos.y = this.height - packedImage.height;
        }
    }

    public PackedImage getPackedImage() {
        if (this.p_im == null) {
            this.p_im = new PackedImage(this.width, this.height);
            int n = 0;
            while (n < this.pos.length) {
                try {
                    PackedImage.blat(this.p_im, this.pos[n].x, this.pos[n].y, this.tokDec.mAllToks[this.pos[n].tok]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                ++n;
            }
            this.blatResiduals(this.p_im, 0, 0);
        }
        return this.p_im;
    }

    public void setForegroundColor(int n) {
        this.fgColor = n;
    }

    public void setBackgroundColor(int n) {
        this.bgColor = n;
    }

    public Image createImage(Component component) {
        dbg.dprint("IFDInfoPosBlock::createImage() starts.", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
        PackedImage packedImage = this.getPackedImage();
        ImageProducer imageProducer = packedImage.toImage(this.fgColor, this.bgColor);
        Image image = component.createImage(imageProducer);
        return image;
    }

    public void setResiduals(Vector vector) {
        if (vector.size() == 0) {
            this.residuals = null;
            return;
        }
        this.residuals = vector;
    }

    protected boolean blatResiduals(PackedImage packedImage, int n, int n2) {
        if (this.residuals != null) {
            Enumeration enumeration = this.residuals.elements();
            while (enumeration.hasMoreElements()) {
                IFDInfoBinaryImage iFDInfoBinaryImage = (IFDInfoBinaryImage)enumeration.nextElement();
                PackedImage.blat(packedImage, n + iFDInfoBinaryImage.getXpos(), n2 + iFDInfoBinaryImage.getYpos(), iFDInfoBinaryImage.getPackedImage());
            }
        }
        return true;
    }

    public boolean mustCreateImage() {
        return true;
    }

    static {
        byte[] byArray = new byte[41];
        byArray[0] = 2;
        byArray[1] = -1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 4;
        byArray[6] = 1;
        byArray[8] = 4;
        byArray[9] = 5;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[12] = 2;
        byArray[14] = 6;
        byArray[15] = 7;
        byArray[16] = 1;
        byArray[18] = 1;
        byArray[19] = 7;
        byArray[20] = 10;
        byArray[21] = 1;
        byArray[22] = 1;
        byArray[23] = 3;
        byArray[32] = 1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = 8;
        byArray[36] = 1;
        byArray[37] = 1;
        byArray[38] = 1;
        byArray[39] = 1;
        deltaXDecoder0bits = byArray;
        byte[] byArray2 = new byte[41];
        byArray2[0] = 1;
        byArray2[3] = 5;
        byArray2[4] = 9;
        byArray2[6] = 7;
        byArray2[10] = 13;
        byArray2[11] = 15;
        byArray2[12] = 19;
        byArray2[16] = 17;
        byArray2[21] = 23;
        byArray2[22] = 35;
        byArray2[23] = 25;
        byArray2[32] = 33;
        byArray2[36] = 37;
        byArray2[38] = 39;
        deltaXDecoder0state = byArray2;
        short[] sArray = new short[41];
        sArray[5] = 4;
        sArray[7] = -1;
        sArray[8] = 22;
        sArray[9] = 38;
        sArray[13] = 2;
        sArray[14] = 70;
        sArray[15] = 134;
        sArray[17] = 3;
        sArray[18] = 20;
        sArray[19] = 262;
        sArray[20] = 646;
        sArray[24] = -2;
        sArray[25] = -14;
        sArray[26] = -13;
        sArray[27] = -12;
        sArray[28] = -11;
        sArray[29] = -10;
        sArray[30] = -9;
        sArray[31] = -8;
        sArray[33] = -15;
        sArray[34] = 1670;
        sArray[35] = 390;
        sArray[37] = -5;
        sArray[39] = -7;
        sArray[40] = -3;
        deltaXDecoder0offset = sArray;
        byte[] byArray3 = new byte[49];
        byArray3[0] = 2;
        byArray3[1] = -1;
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[4] = 2;
        byArray3[5] = 1;
        byArray3[6] = 1;
        byArray3[7] = 5;
        byArray3[8] = 1;
        byArray3[9] = 1;
        byArray3[10] = 5;
        byArray3[11] = 6;
        byArray3[12] = 1;
        byArray3[13] = 1;
        byArray3[14] = 2;
        byArray3[15] = 1;
        byArray3[16] = 7;
        byArray3[17] = 8;
        byArray3[18] = 1;
        byArray3[19] = 1;
        byArray3[20] = 2;
        byArray3[21] = 8;
        byArray3[22] = 11;
        byArray3[23] = 1;
        byArray3[24] = 1;
        byArray3[25] = 4;
        byArray3[26] = 1;
        byArray3[41] = -1;
        byArray3[42] = -1;
        byArray3[43] = 9;
        byArray3[44] = 1;
        byArray3[45] = 2;
        byArray3[46] = 1;
        byArray3[47] = 2;
        byArray3[48] = 1;
        deltaXDecoder1bits = byArray3;
        byte[] byArray4 = new byte[49];
        byArray4[0] = 1;
        byArray4[2] = 5;
        byArray4[3] = 7;
        byArray4[4] = 11;
        byArray4[8] = 9;
        byArray4[12] = 15;
        byArray4[13] = 17;
        byArray4[14] = 21;
        byArray4[18] = 19;
        byArray4[23] = 25;
        byArray4[24] = 43;
        byArray4[25] = 27;
        byArray4[44] = 45;
        byArray4[46] = 47;
        deltaXDecoder1state = byArray4;
        short[] sArray2 = new short[49];
        sArray2[5] = -1;
        sArray2[6] = 1;
        sArray2[7] = 7;
        sArray2[9] = -3;
        sArray2[10] = 43;
        sArray2[11] = 75;
        sArray2[15] = 3;
        sArray2[16] = 139;
        sArray2[17] = 267;
        sArray2[19] = 5;
        sArray2[20] = 39;
        sArray2[21] = 523;
        sArray2[22] = 1291;
        sArray2[26] = -5;
        sArray2[27] = -29;
        sArray2[28] = -28;
        sArray2[29] = -27;
        sArray2[30] = -26;
        sArray2[31] = -25;
        sArray2[32] = -24;
        sArray2[33] = -23;
        sArray2[34] = -22;
        sArray2[35] = -21;
        sArray2[36] = -20;
        sArray2[37] = -19;
        sArray2[38] = -18;
        sArray2[39] = -17;
        sArray2[40] = -16;
        sArray2[41] = -30;
        sArray2[42] = 3339;
        sArray2[43] = 779;
        sArray2[45] = -11;
        sArray2[47] = -15;
        sArray2[48] = -7;
        deltaXDecoder1offset = sArray2;
        byte[] byArray5 = new byte[43];
        byArray5[0] = 2;
        byArray5[1] = -1;
        byArray5[2] = 2;
        byArray5[3] = 6;
        byArray5[4] = 3;
        byArray5[7] = 5;
        byArray5[8] = 1;
        byArray5[9] = 1;
        byArray5[10] = 1;
        byArray5[11] = 1;
        byArray5[12] = 2;
        byArray5[13] = 4;
        byArray5[29] = -1;
        byArray5[30] = -1;
        byArray5[31] = 5;
        byArray5[32] = 6;
        byArray5[33] = 7;
        byArray5[34] = 8;
        byArray5[35] = 9;
        byArray5[36] = 10;
        byArray5[39] = 11;
        byArray5[40] = 1;
        deltaXDecoder2bits = byArray5;
        byte[] byArray6 = new byte[43];
        byArray6[0] = 1;
        byArray6[4] = 5;
        byArray6[8] = 13;
        byArray6[9] = 31;
        byArray6[10] = 33;
        byArray6[11] = 35;
        byArray6[12] = 37;
        byArray6[13] = 15;
        byArray6[40] = 41;
        deltaXDecoder2state = byArray6;
        short[] sArray3 = new short[43];
        sArray3[2] = -2;
        sArray3[3] = 6;
        sArray3[5] = -3;
        sArray3[6] = 2;
        sArray3[7] = 70;
        sArray3[14] = 3;
        sArray3[15] = -19;
        sArray3[16] = -18;
        sArray3[17] = -17;
        sArray3[18] = -16;
        sArray3[19] = -15;
        sArray3[20] = -14;
        sArray3[21] = -13;
        sArray3[22] = -12;
        sArray3[23] = -11;
        sArray3[24] = -10;
        sArray3[25] = -9;
        sArray3[26] = -8;
        sArray3[27] = -7;
        sArray3[28] = -6;
        sArray3[29] = -20;
        sArray3[30] = 4166;
        sArray3[31] = 102;
        sArray3[32] = 134;
        sArray3[33] = 198;
        sArray3[34] = 326;
        sArray3[35] = 582;
        sArray3[36] = 1094;
        sArray3[37] = -4;
        sArray3[38] = 4;
        sArray3[39] = 2118;
        sArray3[41] = -5;
        sArray3[42] = 5;
        deltaXDecoder2offset = sArray3;
        byte[] byArray7 = new byte[51];
        byArray7[0] = 2;
        byArray7[1] = 7;
        byArray7[2] = 1;
        byArray7[3] = 2;
        byArray7[4] = 2;
        byArray7[5] = 7;
        byArray7[6] = 8;
        byArray7[7] = 9;
        byArray7[8] = 10;
        byArray7[9] = 10;
        byArray7[10] = 9;
        byArray7[11] = 8;
        byArray7[12] = 7;
        byArray7[13] = 5;
        byArray7[14] = 1;
        byArray7[46] = 1;
        byArray7[47] = -1;
        byArray7[48] = -1;
        byArray7[49] = 6;
        byArray7[50] = 5;
        firstXDecoder0bits = byArray7;
        byte[] byArray8 = new byte[51];
        byArray8[0] = 1;
        byArray8[2] = 5;
        byArray8[3] = 7;
        byArray8[4] = 11;
        byArray8[13] = 15;
        byArray8[14] = 49;
        byArray8[46] = 47;
        firstXDecoder0state = byArray8;
        short[] sArray4 = new short[51];
        sArray4[5] = 128;
        sArray4[6] = 256;
        sArray4[7] = 512;
        sArray4[8] = 1024;
        sArray4[9] = -2047;
        sArray4[10] = -1023;
        sArray4[11] = -511;
        sArray4[12] = -255;
        sArray4[15] = -31;
        sArray4[16] = -30;
        sArray4[17] = -29;
        sArray4[18] = -28;
        sArray4[19] = -27;
        sArray4[20] = -26;
        sArray4[21] = -25;
        sArray4[22] = -24;
        sArray4[23] = -23;
        sArray4[24] = -22;
        sArray4[25] = -21;
        sArray4[26] = -20;
        sArray4[27] = -19;
        sArray4[28] = -18;
        sArray4[29] = -17;
        sArray4[30] = -16;
        sArray4[31] = -15;
        sArray4[32] = -14;
        sArray4[33] = -13;
        sArray4[34] = -12;
        sArray4[35] = -11;
        sArray4[36] = -10;
        sArray4[37] = -9;
        sArray4[38] = -8;
        sArray4[39] = -7;
        sArray4[40] = -6;
        sArray4[41] = -5;
        sArray4[42] = -4;
        sArray4[43] = -3;
        sArray4[44] = -2;
        sArray4[45] = -1;
        sArray4[47] = -2048;
        sArray4[48] = 2048;
        sArray4[49] = -127;
        sArray4[50] = -63;
        firstXDecoder0offset = sArray4;
        byte[] byArray9 = new byte[51];
        byArray9[0] = 3;
        byArray9[1] = 9;
        byArray9[2] = 8;
        byArray9[3] = 8;
        byArray9[4] = 9;
        byArray9[5] = 10;
        byArray9[6] = 1;
        byArray9[7] = 1;
        byArray9[8] = 2;
        byArray9[9] = 7;
        byArray9[10] = 5;
        byArray9[42] = 1;
        byArray9[43] = -1;
        byArray9[44] = -1;
        byArray9[45] = 5;
        byArray9[46] = 7;
        byArray9[47] = 6;
        byArray9[48] = 5;
        byArray9[49] = 5;
        byArray9[50] = 6;
        firstXDecoder1bits = byArray9;
        byte[] byArray10 = new byte[51];
        byArray10[0] = 1;
        byArray10[6] = 9;
        byArray10[7] = 45;
        byArray10[8] = 47;
        byArray10[10] = 11;
        byArray10[42] = 43;
        firstXDecoder1state = byArray10;
        short[] sArray5 = new short[51];
        sArray5[1] = -1023;
        sArray5[2] = -511;
        sArray5[3] = 256;
        sArray5[4] = 512;
        sArray5[5] = 1024;
        sArray5[9] = -255;
        sArray5[11] = -31;
        sArray5[12] = -30;
        sArray5[13] = -29;
        sArray5[14] = -28;
        sArray5[15] = -27;
        sArray5[16] = -26;
        sArray5[17] = -25;
        sArray5[18] = -24;
        sArray5[19] = -23;
        sArray5[20] = -22;
        sArray5[21] = -21;
        sArray5[22] = -20;
        sArray5[23] = -19;
        sArray5[24] = -18;
        sArray5[25] = -17;
        sArray5[26] = -16;
        sArray5[27] = -15;
        sArray5[28] = -14;
        sArray5[29] = -13;
        sArray5[30] = -12;
        sArray5[31] = -11;
        sArray5[32] = -10;
        sArray5[33] = -9;
        sArray5[34] = -8;
        sArray5[35] = -7;
        sArray5[36] = -6;
        sArray5[37] = -5;
        sArray5[38] = -4;
        sArray5[39] = -3;
        sArray5[40] = -2;
        sArray5[41] = -1;
        sArray5[43] = -1024;
        sArray5[44] = 2048;
        sArray5[46] = 128;
        sArray5[47] = -127;
        sArray5[48] = -63;
        sArray5[49] = 32;
        sArray5[50] = 64;
        firstXDecoder1offset = sArray5;
        byte[] byArray11 = new byte[21];
        byArray11[0] = 1;
        byArray11[2] = 1;
        byArray11[3] = 1;
        byArray11[4] = 2;
        byArray11[6] = 1;
        byArray11[7] = 1;
        byArray11[8] = 2;
        byArray11[9] = 1;
        byArray11[10] = 2;
        byArray11[11] = 2;
        byArray11[12] = 1;
        byArray11[13] = 1;
        byArray11[14] = 1;
        byArray11[15] = 2;
        byArray11[16] = 3;
        byArray11[17] = 4;
        byArray11[18] = 5;
        byArray11[19] = 6;
        byArray11[20] = -1;
        deltaYDecoder0bits = byArray11;
        byte[] byArray12 = new byte[21];
        byArray12[0] = 1;
        byArray12[2] = 3;
        byArray12[4] = 5;
        byArray12[7] = 9;
        byArray12[8] = 11;
        byArray12[12] = 15;
        byArray12[13] = 17;
        byArray12[14] = 19;
        deltaYDecoder0state = byArray12;
        short[] sArray6 = new short[21];
        sArray6[1] = 1;
        sArray6[3] = 2;
        sArray6[5] = 4;
        sArray6[6] = 5;
        sArray6[9] = 7;
        sArray6[10] = 9;
        sArray6[11] = 13;
        sArray6[15] = 17;
        sArray6[16] = 21;
        sArray6[17] = 29;
        sArray6[18] = 45;
        sArray6[19] = 77;
        sArray6[20] = 141;
        deltaYDecoder0offset = sArray6;
        byte[] byArray13 = new byte[21];
        byArray13[0] = 1;
        byArray13[2] = 1;
        byArray13[4] = 1;
        byArray13[5] = 1;
        byArray13[6] = 2;
        byArray13[8] = 1;
        byArray13[9] = 1;
        byArray13[10] = 2;
        byArray13[11] = 1;
        byArray13[12] = 1;
        byArray13[14] = 1;
        byArray13[15] = 2;
        byArray13[16] = 3;
        byArray13[17] = 4;
        byArray13[18] = 1;
        byArray13[19] = 5;
        byArray13[20] = -1;
        deltaYDecoder1bits = byArray13;
        byte[] byArray14 = new byte[21];
        byArray14[0] = 1;
        byArray14[2] = 3;
        byArray14[4] = 5;
        byArray14[6] = 7;
        byArray14[9] = 11;
        byArray14[10] = 15;
        byArray14[12] = 13;
        byArray14[18] = 19;
        deltaYDecoder1state = byArray14;
        short[] sArray7 = new short[21];
        sArray7[1] = 1;
        sArray7[3] = 2;
        sArray7[5] = 3;
        sArray7[7] = 5;
        sArray7[8] = 6;
        sArray7[11] = 8;
        sArray7[13] = 10;
        sArray7[14] = 11;
        sArray7[15] = 13;
        sArray7[16] = 17;
        sArray7[17] = 25;
        sArray7[19] = 41;
        sArray7[20] = 73;
        deltaYDecoder1offset = sArray7;
        byte[] byArray15 = new byte[27];
        byArray15[0] = 1;
        byArray15[2] = 2;
        byArray15[4] = 3;
        byArray15[5] = 1;
        byArray15[6] = 2;
        byArray15[14] = -1;
        byArray15[16] = 1;
        byArray15[18] = 1;
        byArray15[19] = 1;
        byArray15[20] = 1;
        byArray15[21] = 1;
        byArray15[22] = 2;
        byArray15[23] = 3;
        byArray15[24] = 4;
        byArray15[25] = 5;
        byArray15[26] = 6;
        deltaYDecoder2bits = byArray15;
        byte[] byArray16 = new byte[27];
        byArray16[0] = 1;
        byArray16[2] = 3;
        byArray16[4] = 7;
        byArray16[5] = 15;
        byArray16[6] = 17;
        byArray16[18] = 21;
        byArray16[19] = 23;
        byArray16[20] = 25;
        deltaYDecoder2state = byArray16;
        short[] sArray8 = new short[27];
        sArray8[1] = 1;
        sArray8[3] = 2;
        sArray8[7] = 7;
        sArray8[8] = 8;
        sArray8[9] = 9;
        sArray8[10] = 10;
        sArray8[11] = 11;
        sArray8[12] = 12;
        sArray8[13] = 13;
        sArray8[14] = 140;
        sArray8[15] = 3;
        sArray8[16] = 5;
        sArray8[17] = 4;
        sArray8[21] = 14;
        sArray8[22] = 16;
        sArray8[23] = 20;
        sArray8[24] = 28;
        sArray8[25] = 44;
        sArray8[26] = 76;
        deltaYDecoder2offset = sArray8;
        deltaXDecoder0 = new Decoder(deltaXDecoder0bits, deltaXDecoder0state, deltaXDecoder0offset);
        deltaXDecoder1 = new Decoder(deltaXDecoder1bits, deltaXDecoder1state, deltaXDecoder1offset);
        deltaXDecoder2 = new Decoder(deltaXDecoder2bits, deltaXDecoder2state, deltaXDecoder2offset);
        deltaXDecoders = new Decoder[]{deltaXDecoder0, deltaXDecoder1, deltaXDecoder2};
        firstXDecoder0 = new Decoder(firstXDecoder0bits, firstXDecoder0state, firstXDecoder0offset);
        firstXDecoder1 = new Decoder(firstXDecoder1bits, firstXDecoder1state, firstXDecoder1offset);
        firstXDecoders = new Decoder[]{firstXDecoder0, firstXDecoder1};
        deltaYDecoder0 = new Decoder(deltaYDecoder0bits, deltaYDecoder0state, deltaYDecoder0offset);
        deltaYDecoder1 = new Decoder(deltaYDecoder1bits, deltaYDecoder1state, deltaYDecoder1offset);
        deltaYDecoder2 = new Decoder(deltaYDecoder2bits, deltaYDecoder2state, deltaYDecoder2offset);
        deltaYDecoders = new Decoder[]{deltaYDecoder0, deltaYDecoder1, deltaYDecoder2};
    }
}

