/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info;

import COM.xerox.digipaper.applet.WJRim.PackedImage;
import COM.xerox.digipaper.applet.xiff.IFDInfo;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.IFDInfoBinaryImage;
import COM.xerox.digipaper.applet.xiff.ifd_info.IFDInfo_getter;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.io.IOException;

public class IFDInfoBinaryImage_getter
extends IFDInfo_getter {
    public IFDInfoBinaryImage_getter(XIFFFile xIFFFile, String string) {
        super(xIFFFile, string);
    }

    protected PackedImage assembleImageFromUncompressedStrips() {
        byte[] byArray = null;
        int n = this.ifd.numStrips();
        PackedImage packedImage = null;
        if (n == 1) {
            byArray = this.ifd.getStrip(0);
        } else {
            byte[] byArray2 = null;
            int n2 = 0;
            byArray = new byte[this.ifd.totalNumBytesOfImageDataInStrips()];
            int n3 = 0;
            while (n3 < n) {
                byArray2 = this.ifd.getStrip(n3);
                if (byArray2 == null) {
                    return null;
                }
                int n4 = 0;
                int n5 = byArray2.length;
                while (n4 < n5) {
                    byArray[n2++] = byArray2[n4++];
                }
                ++n3;
            }
        }
        try {
            packedImage = new PackedImage(byArray, 0, this.ifd.ImageWidth, this.ifd.ImageLength, 0);
        }
        catch (IOException iOException) {
            IFDInfo_getter.dbg.dprint("Problem G4-decompressing an image.", DebugInfoPrinter.DBUG_ERROR);
            iOException.printStackTrace();
            return null;
        }
        return packedImage;
    }

    protected PackedImage assembleImageFromG4CompressedStrips() {
        byte[] byArray = null;
        PackedImage packedImage = null;
        PackedImage packedImage2 = null;
        int n = 0;
        if (this.ifd.numStrips() == 1) {
            try {
                packedImage2 = new PackedImage(this.ifd.getStrip(0), 0, this.ifd.ImageWidth, this.ifd.ImageLength, this.ifd.ImageLength);
            }
            catch (IOException iOException) {
                IFDInfo_getter.dbg.dprint("Problem G4-decompressing an image.", DebugInfoPrinter.DBUG_ERROR);
                iOException.printStackTrace();
                return null;
            }
            return packedImage2;
        }
        packedImage2 = new PackedImage(this.ifd.ImageWidth, this.ifd.ImageLength);
        int n2 = 0;
        int n3 = this.ifd.numStrips();
        while (n2 < n3) {
            byArray = this.ifd.getStrip(n2);
            if (byArray == null) {
                return null;
            }
            int n4 = this.ifd.getRowsInStrip(n2);
            try {
                packedImage = new PackedImage(byArray, 0, this.ifd.ImageWidth, n4, n4);
            }
            catch (IOException iOException) {
                IFDInfo_getter.dbg.dprint("Problem G4-decompressing a strip of an image.", DebugInfoPrinter.DBUG_ERROR);
                iOException.printStackTrace();
                return null;
            }
            n = packedImage2.blat(packedImage, n);
            this.ifd.dropReferencesToStrip(n2);
            ++n2;
        }
        return packedImage2;
    }

    public void run() {
        PackedImage packedImage = this.ifd.holdsG4CompressedBinaryImage() ? this.assembleImageFromG4CompressedStrips() : this.assembleImageFromUncompressedStrips();
        if (packedImage == null) {
            this.recipient.Update(true, this.ifd, new IFDInfo(this.ifd, "error reading binary image from file"));
            return;
        }
        IFDInfoBinaryImage iFDInfoBinaryImage = null;
        try {
            iFDInfoBinaryImage = new IFDInfoBinaryImage(this.ifd, packedImage);
        }
        catch (IOException iOException) {
            IFDInfo_getter.dbg.dprint("Error creating binary image:", DebugInfoPrinter.DBUG_ERROR);
            iOException.printStackTrace();
            this.recipient.Update(true, this.ifd, new IFDInfo(this.ifd, "error reading binary image from file"));
            return;
        }
        this.recipient.Update(true, this.ifd, iFDInfoBinaryImage);
    }
}

