/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info;

import COM.xerox.digipaper.applet.xiff.DelayedBuffer;
import COM.xerox.digipaper.applet.xiff.Entry;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTable;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.io.IOException;

public class AnnotationTableHeader {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    public static final int LENGTH = 10;
    public static final int TAG_NO = 34730;
    public static final int PREF_TABLE_SIZE = 20;
    static final int COUNT_OFFSET = 0;
    static final int SIZE_OFFSET = 2;
    static final int LAST_OFFSET = 4;
    static final int FIRST_OFFSET = 6;
    public int count;
    public int tableSize;
    public int last;
    public int first;
    public AnnotationTable table;
    public Entry annotTag;
    public boolean isValid;

    public AnnotationTableHeader(Entry entry, XIFFFile xIFFFile) throws IllegalArgumentException {
        if (entry == null) {
            dbg.dprint("Can't add annotations. file has no AnnotOffsets tag.", DebugInfoPrinter.DBUG_ANNOTATIONS);
            this.isValid = false;
            entry = new Entry();
            entry.Value = new Integer(0);
            entry.Count = 1;
            entry.Tag = 34730;
            entry.Type = 4;
            entry.Offset = 0;
        } else {
            this.isValid = true;
        }
        this.annotTag = entry;
        if (entry.Tag != 34730) {
            throw new IllegalArgumentException("IFD Entry does not match (ATH)");
        }
        if (entry.Count != 1) {
            throw new IllegalArgumentException("Illegal IFD Entry (ATH): count=1");
        }
        if ((Integer)entry.Value == 0) {
            this.count = 0;
            this.tableSize = 20;
            this.last = 0;
            this.first = 0;
            dbg.dprint("Making new annotation table!", DebugInfoPrinter.DBUG_ANNOTATIONS);
            this.table = new AnnotationTable(xIFFFile, 20);
            dbg.dprint("New annotation table made!", DebugInfoPrinter.DBUG_ANNOTATIONS);
        } else {
            try {
                DelayedBuffer delayedBuffer = xIFFFile.RAFile.ReadRange((Integer)entry.Value, 10);
                byte[] byArray = delayedBuffer.GetData();
                this.count = xIFFFile.GetShort(byArray, 0);
                this.tableSize = xIFFFile.GetShort(byArray, 2);
                this.last = xIFFFile.GetShort(byArray, 4);
                this.first = xIFFFile.GetLong(byArray, 6);
                dbg.dprint("Reading of header completed", DebugInfoPrinter.DBUG_ANNOTATIONS);
                dbg.dprint("count=" + this.count + "tableSize=" + this.tableSize + "last=" + this.last + "first=" + this.first, DebugInfoPrinter.DBUG_ANNOTATIONS);
                dbg.dprint("Making annotation table. first=" + this.first, DebugInfoPrinter.DBUG_ANNOTATIONS);
                this.ReadAnnotationTable(xIFFFile);
            }
            catch (IOException iOException) {
                dbg.dprint(iOException.toString(), DebugInfoPrinter.ERROR);
                iOException.printStackTrace();
                throw new IllegalArgumentException("error reading from offset in TAG");
            }
        }
        dbg.dprint("Contruction of AnnotTable Header completed.", DebugInfoPrinter.DBUG_ANNOTATIONS);
    }

    public byte[] toByte(XIFFFile xIFFFile) {
        byte[] byArray = new byte[10];
        xIFFFile.PutShort(byArray, 0, this.count);
        xIFFFile.PutShort(byArray, 2, this.tableSize);
        xIFFFile.PutShort(byArray, 4, this.last);
        xIFFFile.PutLong(byArray, 6, this.first);
        return byArray;
    }

    public AnnotationTable ReadAnnotationTable(XIFFFile xIFFFile) {
        dbg.dprint("Reading Annotation Table", DebugInfoPrinter.DBUG_ANNOTATIONS);
        try {
            int n = this.tableSize * 28 + 6;
            dbg.dprint("filesize=" + xIFFFile.RAFile.size(), DebugInfoPrinter.DBUG_ANNOTATIONS);
            dbg.dprint("Reading range " + this.first + "to" + (this.first + n), DebugInfoPrinter.DBUG_ANNOTATIONS);
            DelayedBuffer delayedBuffer = xIFFFile.RAFile.ReadRange(this.first, n);
            this.table = new AnnotationTable(this.count, this.last, delayedBuffer, this.tableSize, xIFFFile, this.first);
            return this.table;
        }
        catch (IOException iOException) {
            dbg.dprint("Could not read annotation table", DebugInfoPrinter.DBUG_ANNOTATIONS);
            dbg.dprint(iOException.toString(), DebugInfoPrinter.DBUG_ANNOTATIONS);
            iOException.printStackTrace();
            this.table = new AnnotationTable(xIFFFile, 20);
            return this.table;
        }
    }
}

