/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info;

import COM.xerox.digipaper.applet.xiff.DelayedBuffer;
import COM.xerox.digipaper.applet.xiff.FileRange;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableEntry;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AnnotationTable {
    public static final int INIT_CAP = 40;
    public static final int TABLE_OFFSET = 2;
    public Vector entries;
    protected XIFFFile file;
    public int nextTableOffset;
    public int tableLen;
    public int numEntries;
    public int[] tableOffset;
    public Vector empty;
    public int spaceNeeded;
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);

    public AnnotationTable(XIFFFile xIFFFile, int n) {
        this.init(xIFFFile, n);
        this.entries = new Vector(40);
        this.tableOffset = new int[1];
        this.tableOffset[0] = 0;
    }

    public void init(XIFFFile xIFFFile, int n) {
        this.empty = new Vector();
        this.spaceNeeded = 0;
        this.file = xIFFFile;
        this.nextTableOffset = n * 28 + 2;
        this.tableLen = this.nextTableOffset + 4;
        this.numEntries = n;
    }

    public AnnotationTable(int n, int n2, DelayedBuffer delayedBuffer, int n3, XIFFFile xIFFFile, int n4) {
        this.init(xIFFFile, n3);
        this.entries = new Vector(n + 20);
        this.tableOffset = new int[n2 + 1];
        this.tableOffset[0] = n4;
        try {
            this.parseAnnotationTable(n, n2, delayedBuffer);
        }
        catch (Exception exception) {
            dbg.dprint("Error parsing annotation table.", DebugInfoPrinter.ERROR);
            dbg.dprint(exception.toString(), DebugInfoPrinter.ERROR);
            exception.printStackTrace();
        }
        if (n != this.entries.size()) {
            dbg.dprint("Out of " + n + ", " + this.entries.size() + " entries parsed", DebugInfoPrinter.DBUG_ANNOTATIONS);
        }
    }

    public void parseAnnotationTable(int n, int n2, DelayedBuffer delayedBuffer) throws IOException {
        int n3;
        byte[] byArray;
        DelayedBuffer delayedBuffer2 = delayedBuffer;
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        DelayedBuffer[] delayedBufferArray = new DelayedBuffer[n];
        while (delayedBuffer2 != null) {
            int n7;
            byArray = delayedBuffer2.GetData();
            this.tableOffset[n4] = n7 = this.file.GetLong(byArray, this.nextTableOffset);
            dbg.dprint("reading table " + n4 + " next=" + n7, DebugInfoPrinter.DBUG_ANNOTATIONS);
            if (n7 == 0) {
                if (n4 != n2) {
                    dbg.dprint("num of tables in header is incorrect", DebugInfoPrinter.DBUG_ANNOTATIONS);
                }
                delayedBuffer2 = null;
            } else if (n4 == n2) {
                dbg.dprint("last offset of tables != 0", DebugInfoPrinter.DBUG_ANNOTATIONS);
                delayedBuffer2 = null;
            } else {
                delayedBuffer2 = this.file.RAFile.ReadRange(n7, this.tableLen);
            }
            if (n4 != this.file.GetShort(byArray, 0)) {
                dbg.dprint("table ordinal does not agree with file.", DebugInfoPrinter.DBUG_ANNOTATIONS);
            }
            dbg.dprint("Parsing annot table #" + n4, DebugInfoPrinter.DBUG_ANNOTATIONS);
            ++n4;
            int n8 = 2;
            n3 = 0;
            while (n3 < this.numEntries && n5 <= n) {
                AnnotationTableEntry annotationTableEntry = new AnnotationTableEntry(byArray, this.file, n8);
                n8 += 28;
                if (n5 != annotationTableEntry.ID) {
                    dbg.dprint("table ID does not agree with file.", DebugInfoPrinter.DBUG_ANNOTATIONS);
                }
                this.entries.addElement(annotationTableEntry);
                if (n5 == 1) {
                    nArray2[n6] = annotationTableEntry.offset;
                    nArray3[n6] = annotationTableEntry.length;
                } else if (nArray2[n6] + nArray3[n6] == annotationTableEntry.offset) {
                    int n9 = n6;
                    nArray3[n9] = nArray3[n9] + annotationTableEntry.length;
                } else {
                    dbg.dprint("Reading -> from:" + nArray2[n6] + " length:" + nArray3[n6] + " into buffer:" + n6, DebugInfoPrinter.DBUG_ANNOTATIONS);
                    delayedBufferArray[n6] = this.file.RAFile.ReadRange(nArray2[n6], nArray3[n6]);
                    nArray[++n6] = n5 - 1;
                    nArray2[n6] = annotationTableEntry.offset;
                    nArray3[n6] = annotationTableEntry.length;
                }
                ++n5;
                ++n3;
            }
        }
        delayedBufferArray[n6] = this.file.RAFile.ReadRange(nArray2[n6], nArray3[n6]);
        nArray[++n6] = n;
        n3 = 0;
        while (n3 < n6) {
            dbg.dprint("Reading data from:" + nArray2[n3] + " length " + nArray3[n3] + " for index:" + nArray[n3] + " to:" + nArray[n3 + 1], DebugInfoPrinter.DBUG_ANNOTATIONS);
            byArray = delayedBufferArray[n3].GetData();
            dbg.dprint(new String(byArray, 0), DebugInfoPrinter.DBUG_ANNOTATIONS);
            int n10 = 0;
            int n11 = nArray[n3];
            while (n11 < nArray[n3 + 1]) {
                AnnotationTableEntry annotationTableEntry = (AnnotationTableEntry)this.entries.elementAt(n11);
                dbg.dprint(String.valueOf(annotationTableEntry.length) + " " + n10 + " " + n11, DebugInfoPrinter.DBUG_ANNOTATIONS);
                annotationTableEntry.setData(byArray, n10);
                n10 += annotationTableEntry.length;
                ++n11;
            }
            ++n3;
        }
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void remove(AnnotationTableEntry annotationTableEntry) {
        this.empty.addElement(new FileRange(annotationTableEntry.offset, annotationTableEntry.length));
        this.entries.removeElement(annotationTableEntry);
    }

    public void add(AnnotationTableEntry annotationTableEntry) {
        annotationTableEntry.offset = 0;
        this.spaceNeeded += annotationTableEntry.length;
        this.entries.addElement(annotationTableEntry);
    }

    public void modify(AnnotationTableEntry annotationTableEntry, AnnotationTableEntry annotationTableEntry2) {
        if (annotationTableEntry.length < annotationTableEntry2.length) {
            this.empty.addElement(new FileRange(annotationTableEntry.offset, annotationTableEntry.length));
            annotationTableEntry.offset = 0;
            this.spaceNeeded += annotationTableEntry2.length;
        } else if (annotationTableEntry.length > annotationTableEntry2.length) {
            annotationTableEntry.isModified = true;
            int n = annotationTableEntry.offset + annotationTableEntry2.length;
            int n2 = annotationTableEntry.length - annotationTableEntry2.length;
            this.empty.addElement(new FileRange(n, n2));
        } else {
            annotationTableEntry.isModified = true;
        }
        annotationTableEntry.data = annotationTableEntry2.data;
        annotationTableEntry.length = annotationTableEntry2.length;
        annotationTableEntry.x = annotationTableEntry2.x;
        annotationTableEntry.y = annotationTableEntry2.y;
        annotationTableEntry.width = annotationTableEntry2.width;
        annotationTableEntry.height = annotationTableEntry2.height;
        if (annotationTableEntry2.data.length != annotationTableEntry2.length) {
            dbg.dprint("bad length or data in annotation " + annotationTableEntry.ID, DebugInfoPrinter.DBUG_ANNOTATIONS);
        }
    }
}

