/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff;

import COM.xerox.digipaper.applet.xiff.DelayedBuffer;
import COM.xerox.digipaper.applet.xiff.Entry;
import COM.xerox.digipaper.applet.xiff.RangeAccessFile;
import COM.xerox.digipaper.applet.xiff.Rational;
import COM.xerox.digipaper.applet.xiff.TIFFException;
import COM.xerox.digipaper.applet.xiff.TIFFFile;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.io.IOException;
import java.util.Vector;

public class IFD {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    static final int ANNOTATIONOFFSETS = 34730;
    static final int X_POSITION = 286;
    static final int Y_POSITION = 287;
    static final int SOFTWARE = 305;
    static final int ARTIST = 315;
    static final int SUB_IFD = 330;
    static final int IMAGE_WIDTH = 256;
    static final int IMAGE_LENGTH = 257;
    static final int COMPRESSION = 259;
    static final int PHOTOMETRIC_INTERPRETATION = 262;
    static final int STRIP_OFFSETS = 273;
    static final int ROWS_PER_STRIP = 278;
    static final int STRIP_BYTE_COUNTS = 279;
    static final int X_RESOLUTION = 282;
    static final int Y_RESOLUTION = 283;
    static final int RESOLUTION_UNIT = 296;
    static final int JPEG_INTERCHANGE_FORMAT = 513;
    static final int JPEG_INTERCHANGE_FORMAT_LENGTH = 514;
    static final int IMAGE_LAYER = 34732;
    static final int TILE_WIDTH = 322;
    static final int TILE_LENGTH = 323;
    static final int TILE_OFFSETS = 324;
    static final int TILE_BYTE_COUNTS = 325;
    static final int NO_COMPRESSION_TAG = 1;
    static final int JPEG_COMPRESSION_TAG = 6;
    static final int G4_COMPRESSION_TAG = 4;
    static final int LOSSLESS_TOKENIZING_COMPRESSION_TAG = 34667;
    static final int LOSSY_TOKENIZING_COMPRESSION_TAG = 34673;
    public static final int TIFF_INVALIDVAL = -1;
    static int[] vt_r = new int[]{5};
    static int[] vt_s = new int[]{3};
    static int[] vt_l = new int[]{4};
    static int[] vt_ls = new int[]{3, 4};
    static int[] EMPTY_INT_ARRAY = new int[0];
    public int NextIFD;
    int[] sub_ifd_offsets;
    Entry annotEntry;
    int _x_position;
    int _y_position;
    public int ImageWidth = -1;
    public int ImageLength = -1;
    public int Compression = -1;
    public int PhotometricInterpretation = -1;
    public int RowsPerStrip = -1;
    public int ResolutionUnit = -1;
    public int JpegInterchangeFormat = -1;
    public int JpegInterchangeFormatLength = -1;
    public int ImageLayer = -1;
    public int IndexInImageLayer = -1;
    Rational _XResolution;
    Rational _YResolution;
    protected int[] StripOffsets;
    protected int[] StripByteCounts;
    protected int numStripOffsets;
    protected DelayedBuffer _StripOffsetsBuffer;
    protected DelayedBuffer _StripByteCountsBuffer;
    protected Vector strips;
    DelayedBuffer _XPosbuffer;
    DelayedBuffer _YPosbuffer;
    DelayedBuffer _ImageLayerBuffer;
    protected DelayedBuffer _XResbuffer;
    protected DelayedBuffer _YResbuffer;
    TIFFFile tiff_file;
    protected boolean is_primary = false;
    protected boolean[] val_ret_is_delayed_buffer;

    public IFD(TIFFFile tIFFFile) {
        this.tiff_file = tIFFFile;
        this.val_ret_is_delayed_buffer = new boolean[1];
    }

    public static boolean isValidEntryCount(int n) {
        return n >= 1;
    }

    public boolean isPrimary() {
        return this.is_primary;
    }

    public void makePrimary() {
        this.is_primary = true;
    }

    public int[] getSubIFDOffsets() {
        if (this.sub_ifd_offsets == null) {
            return EMPTY_INT_ARRAY;
        }
        return this.sub_ifd_offsets;
    }

    public int XPosition() {
        if (this._XPosbuffer != null) {
            try {
                byte[] byArray = this._XPosbuffer.GetData();
                this._x_position = this.tiff_file.GetLong(byArray, 0);
            }
            catch (Exception exception) {}
            this._XPosbuffer = null;
        }
        return this._x_position;
    }

    public int YPosition() {
        if (this._YPosbuffer != null) {
            try {
                byte[] byArray = this._YPosbuffer.GetData();
                this._y_position = this.tiff_file.GetLong(byArray, 0);
            }
            catch (Exception exception) {}
            this._YPosbuffer = null;
        }
        return this._y_position;
    }

    public Rational XResolution() {
        if (this._XResbuffer != null) {
            try {
                byte[] byArray = this._XResbuffer.GetData();
                this._XResolution = new Rational(this.tiff_file.GetLong(byArray, 0), this.tiff_file.GetLong(byArray, 4));
            }
            catch (Exception exception) {}
            this._XResbuffer = null;
        }
        return this._XResolution;
    }

    public Rational YResolution() {
        if (this._YResbuffer != null) {
            try {
                byte[] byArray = this._YResbuffer.GetData();
                this._YResolution = new Rational(this.tiff_file.GetLong(byArray, 0), this.tiff_file.GetLong(byArray, 4));
            }
            catch (Exception exception) {}
            this._YResbuffer = null;
        }
        return this._YResolution;
    }

    protected int[] read_int_array(DelayedBuffer delayedBuffer) {
        if (delayedBuffer == null) {
            return null;
        }
        int[] nArray = null;
        try {
            byte[] byArray = delayedBuffer.GetData();
            int n = byArray.length / 4;
            nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.tiff_file.GetLong(byArray, 4 * n2);
                ++n2;
            }
        }
        catch (Exception exception) {
            dbg.dprint("IFD::ImageLayer() exception caught reading value for a field.");
            exception.printStackTrace();
            return null;
        }
        return nArray;
    }

    protected int[] StripOffsets() {
        if (this._StripOffsetsBuffer != null) {
            this.StripOffsets = this.read_int_array(this._StripOffsetsBuffer);
            this._StripOffsetsBuffer = null;
        }
        return this.StripOffsets;
    }

    protected int[] StripByteCounts() {
        if (this._StripByteCountsBuffer != null) {
            this.StripByteCounts = this.read_int_array(this._StripByteCountsBuffer);
            this._StripByteCountsBuffer = null;
        }
        return this.StripByteCounts;
    }

    public int numStrips() {
        return this.numStripOffsets;
    }

    public int totalNumBytesOfImageDataInStrips() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numStripOffsets) {
            n += this.StripByteCounts()[n2];
            ++n2;
        }
        return n;
    }

    public void dropReferencesToStrips() {
        this.strips = null;
    }

    public void dropReferencesToStrip(int n) {
        if (this.strips != null) {
            this.strips.setElementAt(null, n);
        }
    }

    public int getRowsInStrip(int n) {
        if (n < 0 || n >= this.numStripOffsets) {
            return -1;
        }
        if (n == this.numStripOffsets - 1) {
            int n2 = this.ImageLength % this.RowsPerStrip;
            if (n2 == 0) {
                return this.RowsPerStrip;
            }
            return n2;
        }
        return this.RowsPerStrip;
    }

    public int getStripByteCounts(int n) {
        if (n < 0 || n >= this.numStripOffsets) {
            return -1;
        }
        int[] nArray = this.StripByteCounts();
        if (nArray == null) {
            return -1;
        }
        return nArray[n];
    }

    public byte[] getStrip(int n) {
        byte[] byArray;
        if (n < 0 || n >= this.numStripOffsets) {
            return null;
        }
        if (this.strips == null) {
            this.strips = new Vector();
            this.strips.setSize(this.numStripOffsets);
        } else if (this.strips.elementAt(n) != null) {
            return (byte[])this.strips.elementAt(n);
        }
        try {
            DelayedBuffer delayedBuffer = this.tiff_file.RAFile.ReadRange(this.StripOffsets()[n], this.StripByteCounts()[n]);
            byArray = delayedBuffer.GetData();
            this.strips.setElementAt(byArray, n);
        }
        catch (IOException iOException) {
            dbg.dprint("IFD::getStrip() exception caught reading strip of image.");
            iOException.printStackTrace();
            return null;
        }
        return byArray;
    }

    public byte[] getImageData() {
        if (this.numStripOffsets != 1) {
            return null;
        }
        return this.getStrip(0);
    }

    public int ImageLayer() {
        if (this._ImageLayerBuffer != null) {
            try {
                byte[] byArray = this._ImageLayerBuffer.GetData();
                this.ImageLayer = this.tiff_file.GetLong(byArray, 0);
                this.IndexInImageLayer = this.tiff_file.GetLong(byArray, 4);
                this._ImageLayerBuffer = null;
            }
            catch (Exception exception) {
                dbg.dprint("IFD::ImageLayer() exception caught reading value for ImageLayer.");
                exception.printStackTrace();
                return -2;
            }
        }
        return this.ImageLayer;
    }

    public int IndexInImageLayer() {
        if (this._ImageLayerBuffer != null && this.ImageLayer() == -2) {
            return -2;
        }
        return this.IndexInImageLayer;
    }

    public boolean holdsG4CompressedBinaryImage() {
        return this.Compression == 4;
    }

    public boolean holdsUncompressedData() {
        return this.Compression == 1;
    }

    public boolean holdsJPEG() {
        return this.Compression == 6;
    }

    public boolean holdsPosBlock() {
        return this.holdsPosBlock_lossless() || this.holdsPosBlock_lossy();
    }

    public boolean holdsPosBlock_lossless() {
        return this.Compression == 34667;
    }

    public boolean holdsPosBlock_lossy() {
        return this.Compression == 34673;
    }

    public static final Object GetValue(Entry entry, int[] nArray, TIFFFile tIFFFile, boolean[] blArray) throws IOException, TIFFException {
        boolean bl;
        Object object;
        RangeAccessFile rangeAccessFile = tIFFFile.RAFile;
        int n = 0;
        while (n <= nArray.length) {
            if (n == nArray.length) {
                throw new TIFFException("Invalid Type in IFD Entry");
            }
            if (entry.Type == nArray[n]) break;
            ++n;
        }
        if (entry.Count < 1) {
            throw new TIFFException("0 Count in IFD Entry");
        }
        switch (entry.Type) {
            case 1: {
                if (entry.Count <= 4) {
                    object = (byte[])entry.Value;
                    bl = false;
                    break;
                }
                object = rangeAccessFile.ReadRange((Integer)entry.Value, entry.Count);
                bl = true;
                break;
            }
            case 2: {
                if (entry.Count <= 4) {
                    object = new String((byte[])entry.Value, 0);
                    bl = false;
                    break;
                }
                object = rangeAccessFile.ReadRange((Integer)entry.Value, entry.Count);
                bl = true;
                break;
            }
            case 3: {
                if (entry.Count <= 2) {
                    object = (int[])entry.Value;
                    bl = false;
                    break;
                }
                object = rangeAccessFile.ReadRange((Integer)entry.Value, entry.Count * 2);
                bl = true;
                break;
            }
            case 4: {
                if (entry.Count == 1) {
                    int[] nArray2 = new int[entry.Count];
                    nArray2[0] = (Integer)entry.Value;
                    object = nArray2;
                    bl = false;
                    break;
                }
                object = rangeAccessFile.ReadRange((Integer)entry.Value, entry.Count * 4);
                bl = true;
                break;
            }
            case 5: {
                bl = true;
                object = rangeAccessFile.ReadRange((Integer)entry.Value, entry.Count * 8);
                break;
            }
            default: {
                throw TIFFException._unknown_type();
            }
        }
        blArray[0] = bl;
        return object;
    }

    public String toString() {
        int n;
        String string = new String();
        if (this.ImageWidth != -1) {
            string = String.valueOf(string) + "Image Width " + this.ImageWidth + "\n";
        }
        if (this.ImageLength != -1) {
            string = String.valueOf(string) + "Image Length " + this.ImageLength + "\n";
        }
        if (this.Compression != -1) {
            string = String.valueOf(string) + "Compression " + this.Compression + "\n";
        }
        if (this.PhotometricInterpretation != -1) {
            string = String.valueOf(string) + "Photomentric Interpretation " + this.PhotometricInterpretation + "\n";
        }
        if (this.StripOffsets != null) {
            string = String.valueOf(string) + "Strip Offsets: ";
            n = 0;
            while (n < this.numStripOffsets) {
                string = String.valueOf(string) + this.StripOffsets[n] + " ";
                ++n;
            }
            string = String.valueOf(string) + "\n";
        }
        if (this.RowsPerStrip != -1) {
            string = String.valueOf(string) + "Rows Per Strip " + this.RowsPerStrip + "\n";
        }
        if (this.StripByteCounts != null) {
            string = String.valueOf(string) + "Strip Byte Counts: ";
            n = 0;
            while (n < this.numStripOffsets) {
                string = String.valueOf(string) + this.StripByteCounts[n] + " ";
                ++n;
            }
            string = String.valueOf(string) + "\n";
        }
        if (this.XResolution() != null) {
            string = String.valueOf(string) + "X resolution " + this.XResolution() + "\n";
        }
        if (this.YResolution() != null) {
            string = String.valueOf(string) + "Y resolution " + this.YResolution() + "\n";
        }
        if (this.ResolutionUnit != -1) {
            string = String.valueOf(string) + "Resolution Unit " + this.ResolutionUnit + "\n";
        }
        if (this._x_position != -1) {
            string = String.valueOf(string) + "X Position " + this._x_position + "\n";
        }
        if (this._y_position != -1) {
            string = String.valueOf(string) + "Y Position " + this._y_position + "\n";
        }
        if (this.sub_ifd_offsets != null) {
            int n2 = 0;
            int n3 = this.sub_ifd_offsets.length;
            while (n2 < n3) {
                string = String.valueOf(string) + "sub_ifd offset " + this.sub_ifd_offsets[n2] + "\n";
                ++n2;
            }
        }
        return string;
    }

    protected boolean _read_entry(Entry entry, TIFFFile tIFFFile) throws IOException, TIFFException {
        try {
            switch (entry.Tag) {
                case 34730: {
                    this.annotEntry = new Entry();
                    this.annotEntry.Offset = entry.Offset;
                    this.annotEntry.Tag = entry.Tag;
                    this.annotEntry.Type = entry.Type;
                    this.annotEntry.Count = entry.Count;
                    this.annotEntry.Value = entry.Value;
                    break;
                }
                case 286: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this._XPosbuffer = (DelayedBuffer)IFD.GetValue(entry, vt_r, tIFFFile, this.val_ret_is_delayed_buffer);
                    break;
                }
                case 287: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this._YPosbuffer = (DelayedBuffer)IFD.GetValue(entry, vt_r, tIFFFile, this.val_ret_is_delayed_buffer);
                    break;
                }
                case 330: {
                    if (entry.Count != 0) {
                        if (!IFD.isValidEntryCount(entry.Count)) {
                            throw new IOException("subIFD with Count " + entry.Count);
                        }
                        this.sub_ifd_offsets = (int[])IFD.GetValue(entry, vt_l, tIFFFile, this.val_ret_is_delayed_buffer);
                    }
                    break;
                }
                case 256: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this.ImageWidth = ((int[])IFD.GetValue(entry, vt_ls, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    break;
                }
                case 257: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this.ImageLength = ((int[])IFD.GetValue(entry, vt_ls, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    break;
                }
                case 259: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this.Compression = ((int[])IFD.GetValue(entry, vt_s, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    break;
                }
                case 262: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this.PhotometricInterpretation = ((int[])IFD.GetValue(entry, vt_s, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    break;
                }
                case 278: 
                case 323: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this.RowsPerStrip = ((int[])IFD.GetValue(entry, vt_ls, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    break;
                }
                case 273: 
                case 324: {
                    Object object = IFD.GetValue(entry, vt_ls, tIFFFile, this.val_ret_is_delayed_buffer);
                    if (this.val_ret_is_delayed_buffer[0]) {
                        this._StripOffsetsBuffer = (DelayedBuffer)object;
                    } else {
                        this.StripOffsets = (int[])object;
                    }
                    this.numStripOffsets = entry.Count;
                    break;
                }
                case 279: 
                case 325: {
                    Object object = IFD.GetValue(entry, vt_ls, tIFFFile, this.val_ret_is_delayed_buffer);
                    if (this.val_ret_is_delayed_buffer[0]) {
                        this._StripByteCountsBuffer = (DelayedBuffer)object;
                    } else {
                        this.StripByteCounts = (int[])object;
                    }
                    break;
                }
                case 322: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    int n = ((int[])IFD.GetValue(entry, vt_ls, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    if (this.ImageWidth != n) {
                        throw new IOException();
                    }
                    break;
                }
                case 282: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this._XResbuffer = (DelayedBuffer)IFD.GetValue(entry, vt_r, tIFFFile, this.val_ret_is_delayed_buffer);
                    break;
                }
                case 283: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this._YResbuffer = (DelayedBuffer)IFD.GetValue(entry, vt_r, tIFFFile, this.val_ret_is_delayed_buffer);
                    break;
                }
                case 296: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this.ResolutionUnit = ((int[])IFD.GetValue(entry, vt_s, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    break;
                }
                case 513: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this.JpegInterchangeFormat = ((int[])IFD.GetValue(entry, vt_l, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    break;
                }
                case 514: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    this.JpegInterchangeFormatLength = ((int[])IFD.GetValue(entry, vt_l, tIFFFile, this.val_ret_is_delayed_buffer))[0];
                    break;
                }
                case 34732: {
                    if (!IFD.isValidEntryCount(entry.Count)) {
                        throw new IOException();
                    }
                    Object object = IFD.GetValue(entry, vt_ls, tIFFFile, this.val_ret_is_delayed_buffer);
                    if (this.val_ret_is_delayed_buffer[0]) {
                        this._ImageLayerBuffer = (DelayedBuffer)object;
                        this.ImageLayer = -1;
                        this.IndexInImageLayer = -1;
                    } else {
                        int[] nArray = (int[])object;
                        this.ImageLayer = nArray[0];
                        this.IndexInImageLayer = nArray[1];
                    }
                }
                default: {
                    return false;
                }
            }
        }
        catch (TIFFException tIFFException) {
            if (tIFFException.TypeUnknown) {
                return false;
            }
            throw tIFFException;
        }
        return true;
    }
}

