/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.client.DocInfoWindow;
import COM.xerox.digipaper.applet.client.PreviewWindow;
import COM.xerox.digipaper.applet.client.ThumbnailPanel;
import COM.xerox.digipaper.applet.xiff.PageInfoReader;
import COM.xerox.digipaper.applet.xiff.RenderThread;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.caching.CacheSystemCreator;
import COM.xerox.digipaper.applet.xiff.caching.RequestForDocument;
import COM.xerox.digipaper.applet.xiff.thumbnails.Thumbnail;
import COM.xerox.digipaper.util.CanGetObjects;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import COM.xerox.digipaper.util.adt.SynchronousCaucus;
import COM.xerox.digipaper.util.caching.CanPrefetchObjects;
import COM.xerox.digipaper.util.caching.GenericCache;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class LimitedAccessCommandBar
extends Panel {
    static final int FILE_LOC_LEN = 20;
    static final int PAGE_JUMP = 5;
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected static SynchronousCaucus xifffile_getter = CacheSystemCreator.create_xifffile_getter();
    static final String TN_DEFAULT = "Thumbnails...";
    static final String TN_WINDOW = "in Window";
    static final String TN_VIEWER = "in Viewer";
    protected PageInfoReader pi_reader;
    protected CanPrefetchObjects prefetcher;
    protected CanGetObjects thumbnail_getter;
    protected GenericCache page_info_cache;
    protected GenericCache image_cache;
    protected GenericCache thumbnail_cache;
    protected String docType;
    protected Client viewer;
    protected XIFFFile curFile;
    protected String curFilename;
    protected int numOfPages = 1;
    protected int curPage;
    protected RenderThread render;
    protected Hashtable authors;
    protected PreviewWindow pwThumb;
    protected ThumbnailPanel pThumb;
    protected Button docInfo;
    protected Choice preview;
    protected Button first;
    protected Button prevJump;
    protected Button prev;
    protected TextField pageNo;
    protected Button next;
    protected Button nextJump;
    protected Button last;
    protected Label location;
    protected Button bPrint;
    protected Button bClose;
    protected Panel pStandard;

    public LimitedAccessCommandBar(Client client, String string) {
        this.viewer = client;
        this.docType = string;
        this.init();
    }

    public void init() {
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.pageNo = new TextField(Integer.toString(1), 3);
        this.pageNo.setEditable(true);
        this.first = new Button("|<");
        this.prevJump = new Button("<<");
        this.prev = new Button("<");
        this.next = new Button(">");
        this.nextJump = new Button(">>");
        this.last = new Button(">|");
        this.docInfo = new Button("Info...");
        this.location = new Label("No File Loaded.                         .");
        this.preview = new Choice();
        this.preview.addItem(TN_DEFAULT);
        this.preview.addItem(TN_VIEWER);
        this.preview.addItem(TN_WINDOW);
        this.preview.select(TN_DEFAULT);
        Font font = new Font("Roman", 1, 10);
        if (font != null) {
            font = new Font(font.getName(), 1, font.getSize());
            this.next.setFont(font);
            this.prev.setFont(font);
            this.first.setFont(font);
            this.last.setFont(font);
            this.prevJump.setFont(font);
            this.nextJump.setFont(font);
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.viewer.drag);
        panel.add(this.first);
        panel.add(this.prevJump);
        panel.add(this.prev);
        panel.add(this.pageNo);
        panel.add(this.next);
        panel.add(this.nextJump);
        panel.add(this.last);
        panel.add(this.docInfo);
        panel.add(this.preview);
        if (this.viewer.printLoc() != null) {
            this.bPrint = new Button("Print");
            panel.add(this.bPrint);
        }
        if (this.viewer.isApplet) {
            this.bClose = new Button("Close");
            panel.add(this.bClose);
        }
        panel.add(this.location);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("West", this.viewer.imageCanvas.pView);
        panel2.add("Center", this.viewer.message);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("North", panel);
        panel3.add("South", panel2);
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(2));
        panel4.add(this.viewer.icon);
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        panel5.add("North", new Label("Pan:"));
        panel5.add("Center", this.viewer.drag);
        Panel panel6 = new Panel();
        panel6.setLayout(new FlowLayout(0));
        panel6.add(panel5);
        panel6.add(panel3);
        Panel panel7 = new Panel();
        panel7.setLayout(new BorderLayout());
        panel7.add("East", panel4);
        panel7.add("West", panel6);
        this.pStandard = panel7;
        this.add(this.pStandard);
        this.numOfPages = 1;
        this.UpdatePageNo(0);
        this.pageNo.disable();
        this.docInfo.disable();
        this.preview.disable();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.pageNo) {
            this.DoNewPage();
        } else if (event.target == this.first) {
            this.DoFirstPage();
        } else if (event.target == this.prevJump) {
            this.DoPrevJump();
        } else if (event.target == this.prev) {
            this.DoPrevPage();
        } else if (event.target == this.next) {
            this.DoNextPage();
        } else if (event.target == this.nextJump) {
            this.DoNextJump();
        } else if (event.target == this.last) {
            this.DoLastPage();
        } else if (event.target == this.docInfo) {
            this.DoDocInfo();
        } else if (event.target == this.preview) {
            this.DoPreviewChoice((String)object);
        } else if (event.target == this.bClose || event.id == 201) {
            this.viewer.kill();
        } else if (event.target == this.bPrint) {
            this.DoPrint();
        } else if (event.target == this.viewer.drag) {
            this.viewer.imageCanvasPanel.setCoords(event.x, event.y);
        } else if (event.target instanceof Thumbnail) {
            this.DoThumbnail((Thumbnail)event.target);
        } else {
            return this.viewer.imageCanvas.handleViewEvent(event);
        }
        return true;
    }

    public void disablePage() {
        this.first.disable();
        this.prevJump.disable();
        this.prev.disable();
        this.pageNo.disable();
        this.next.disable();
        this.nextJump.disable();
        this.last.disable();
    }

    public void enablePage() {
        this.first.enable();
        this.prevJump.enable();
        this.prev.enable();
        this.pageNo.enable();
        this.next.enable();
        this.nextJump.enable();
        this.last.enable();
    }

    public void DoPreviewChoice(String string) {
        this.preview.select(TN_DEFAULT);
        if (string.equals(TN_VIEWER)) {
            this.DoPreview();
            return;
        }
        if (string.equals(TN_WINDOW)) {
            this.DoPreviewWindow();
        }
    }

    public void DoPreviewWindow() {
        if (this.pThumb == null) {
            this.pThumb = new ThumbnailPanel(this.curFile, this.thumbnail_getter, this.location);
        }
        if (this.pwThumb != null) {
            this.pwThumb.CloseWindow();
        }
        this.pwThumb = new PreviewWindow(this.viewer, this.pThumb);
        this.pwThumb.show();
    }

    public void DoPreview() {
        this.UpdateLocation("                  ");
        if (this.pThumb == null) {
            this.pThumb = new ThumbnailPanel(this.curFile, this.thumbnail_getter, this.location);
        } else {
            this.pThumb.setMessage(this.location);
        }
        if (this.pwThumb != null) {
            this.pwThumb.CloseWindow();
            this.pwThumb = null;
        }
        this.viewer.window.remove(this.viewer.imageCanvasPanel);
        this.viewer.window.add("Center", this.pThumb);
        ((Component)this.viewer.window).invalidate();
        this.viewer.window.validate();
        this.pThumb.repaint();
        this.disablePage();
        this.viewer.imageCanvas.disableView();
        this.preview.disable();
    }

    public void DoCanvas() {
        if (this.pThumb == null) {
            return;
        }
        this.viewer.window.remove(this.pThumb);
        this.viewer.window.add("Center", this.viewer.imageCanvasPanel);
        ((Component)this.viewer.window).invalidate();
        this.viewer.window.validate();
        this.enablePage();
        this.preview.enable();
        this.UpdateLocation("Page " + (this.curPage + 1) + " of " + this.numOfPages);
        this.viewer.imageCanvas.enableView();
    }

    public void DoThumbnail(Thumbnail thumbnail) {
        this.DoCanvas();
        this.CheckNGetPage(thumbnail.getPageNum());
    }

    public void DoOpenURL(String string, String string2) throws Exception {
        try {
            URL uRL;
            dbg.dprint("Opening file " + string + ", anchor " + string2, DebugInfoPrinter.DBUG_CONTROL);
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (this.viewer.url != null) {
                    string = this.viewer.url.toString() + "/../" + string;
                    uRL = new URL(string);
                }
                throw malformedURLException;
            }
            RequestForDocument requestForDocument = new RequestForDocument(uRL, this.docType);
            XIFFFile xIFFFile = (XIFFFile)xifffile_getter.getObject(requestForDocument);
            if (xIFFFile == null) {
                throw new IOException("Couldn't open file at url " + uRL);
            }
            this.DoOpen(xIFFFile, null, string2);
            return;
        }
        catch (Exception exception) {
            this.viewer.printMessage("Could not open file " + string);
            dbg.dprint("Could not open file " + string + "base=" + this.viewer.url, DebugInfoPrinter.DBUG_ERROR);
            throw exception;
        }
    }

    protected void DoOpen(XIFFFile xIFFFile, String string, String string2) throws Exception {
        this.curFile = xIFFFile;
        try {
            int n;
            if (string2 == null) {
                n = 0;
            } else {
                try {
                    n = Integer.parseInt(string2) - 1;
                    if (n < 0) {
                        throw new NumberFormatException("Negative number");
                    }
                    string2 = null;
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
            }
            this.UpdateLocation("File loading (" + xIFFFile.RAFile.size() + " bytes)");
            this.viewer.setCursor(3);
            this.viewer.icon.animate();
            Object[] objectArray = CacheSystemCreator.create_caches(this.viewer.size_page_info_cache, this.viewer.size_image_cache, this.viewer.size_thumbnail_cache, this, this.curFile, this.viewer.url);
            this.prefetcher = (CanPrefetchObjects)objectArray[0];
            this.pi_reader = (PageInfoReader)objectArray[1];
            this.page_info_cache = (GenericCache)objectArray[2];
            this.image_cache = (GenericCache)objectArray[3];
            this.thumbnail_getter = (CanGetObjects)objectArray[4];
            this.thumbnail_cache = (GenericCache)objectArray[5];
            this.viewer.imageCanvas.setPageInfoReader(this.pi_reader);
            this.docInfo.enable();
            this.preview.enable();
            if (n == 0) {
                dbg.dprint("Creating Render Thread", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
                this.render = new RenderThread(this.curFile, 0, this.viewer.imageCanvasPanel, this.prefetcher, this.pi_reader);
                new Thread((Runnable)this.render, this.render.getNameForNewRenderThread()).start();
            }
            dbg.dprint("Reading page table", DebugInfoPrinter.DBUG_XIFF_VERBOSE);
            this.curFile.ReadPageTable();
            this.UpdateLocation("File loading (" + this.curFile.getNumPages() + " pages)");
            dbg.dprint("Document has " + this.curFile.getNumPages() + " pages", DebugInfoPrinter.DBUG_XIFF);
            this.numOfPages = this.curFile.getNumPages();
            if (n != 0) {
                n = this.CheckPage(n);
                dbg.dprint("Creating Render Thread", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
                this.render = new RenderThread(this.curFile, n, this.viewer.imageCanvas, this.prefetcher, this.pi_reader);
                new Thread((Runnable)this.render, this.render.getNameForNewRenderThread()).start();
            }
            this.getPage(n);
            this.viewer.imageCanvas.newFile(this.render, this.numOfPages);
            this.viewer.curFile = this.curFile;
            if (string2 != null) {
                this.viewer.imageCanvas.DoShowDocument("#" + string2);
            }
            this.authors = null;
            if (this.pThumb != null) {
                this.pThumb.kill();
                this.pThumb = null;
            }
            this.pageNo.enable();
            this.curFilename = string;
            return;
        }
        catch (Exception exception) {
            dbg.dprint(exception.toString(), DebugInfoPrinter.DBUG_ERROR);
            exception.printStackTrace();
            this.viewer.setCursor(0);
            this.viewer.icon.normal();
            this.curFile = this.viewer.curFile;
            if (this.curFile != null) {
                this.numOfPages = this.curFile.getNumPages();
                this.pageNo.enable();
                this.UpdateLocation("Page " + (this.curPage + 1) + " of " + this.numOfPages);
            }
            throw exception;
        }
    }

    public void flush_caches() {
        dbg.dprint("Stopping threads and flushing caches.", DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
        if (this.render != null) {
            this.render.stop_everything();
        }
        if (this.pThumb != null) {
            this.pThumb.kill();
        }
        dbg.dprint("Flushing page info cache:", DebugInfoPrinter.DBUG_CACHING);
        this.page_info_cache.flushAllObjects();
        dbg.dprint("Flushing image cache:", DebugInfoPrinter.DBUG_CACHING);
        this.image_cache.flushAllObjects();
        dbg.dprint("Flushing thumbnails", DebugInfoPrinter.DBUG_CACHING);
        this.thumbnail_cache.flushAllObjects();
        dbg.dprint("Flushing token decoders", DebugInfoPrinter.DBUG_CACHING);
        this.viewer.curFile.flushTokenDecoders();
    }

    public void getPage(int n) {
        if (this.curFile == null) {
            dbg.dprint("Attempting to get page when no file loaded", DebugInfoPrinter.DBUG_ERROR);
            return;
        }
        dbg.dprint("Retrieving page " + n, DebugInfoPrinter.DBUG_CONTROL_VERBOSE);
        this.render.SetCurrentPage(n);
        this.curPage = n;
        this.viewer.printMessage("Loading Page " + (this.curPage + 1));
        this.viewer.setCursor(3);
        this.viewer.icon.animate();
        this.UpdatePageNo(this.curPage);
    }

    public void UpdateLocation(String string) {
        this.location.setText(string);
        this.location.invalidate();
        this.pStandard.validate();
    }

    protected void UpdatePageNo(int n) {
        ((TextComponent)this.pageNo).setText(Integer.toString(n + 1));
        this.pageNo.selectAll();
        if (n <= 0) {
            this.prev.disable();
            this.prevJump.disable();
            this.first.disable();
        } else {
            this.prev.enable();
            this.prevJump.enable();
            this.first.enable();
        }
        if (n >= this.numOfPages - 1) {
            this.next.disable();
            this.nextJump.disable();
            this.last.disable();
            return;
        }
        this.next.enable();
        this.nextJump.enable();
        this.last.enable();
    }

    protected void DoNewPage() {
        int n;
        try {
            n = Integer.parseInt(this.pageNo.getText()) - 1;
            if (n < 0) {
                throw new NumberFormatException("Negative number");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.viewer.imageCanvas.DoShowDocument("#" + this.pageNo.getText());
            this.SetPageNo(this.curPage);
            return;
        }
        this.CheckNGetPage(n);
    }

    public void CheckNGetPage(int n) {
        int n2 = this.CheckPage(n);
        if (n2 != this.curPage) {
            this.getPage(n2);
        }
    }

    protected int CheckPage(int n) {
        if (n <= 0) {
            return 0;
        }
        if (n >= this.numOfPages) {
            return this.numOfPages - 1;
        }
        return n;
    }

    public void DoFirstPage() {
        if (this.viewer.imageCanvas.curPageNo != 0) {
            this.getPage(0);
        }
    }

    public void DoLastPage() {
        if (this.viewer.imageCanvas.curPageNo != this.numOfPages - 1) {
            this.getPage(this.numOfPages - 1);
        }
    }

    protected void SetPageNo(int n) {
        ((TextComponent)this.pageNo).setText(Integer.toString(n + 1));
        this.pageNo.selectAll();
    }

    public void DoPrevJump() {
        this.CheckNGetPage(this.curPage - 5);
    }

    public void DoNextJump() {
        this.CheckNGetPage(this.curPage + 5);
    }

    public void DoNextPage() {
        this.CheckNGetPage(this.curPage + 1);
    }

    public void DoPrevPage() {
        this.CheckNGetPage(this.curPage - 1);
    }

    public void DoPrint() {
        this.viewer.showDocument(this.viewer.printLoc());
    }

    public void DoDocInfo() {
        try {
            if (this.authors == null) {
                this.authors = this.curFile.Authors();
            }
            DocInfoWindow docInfoWindow = new DocInfoWindow(this.authors);
            docInfoWindow.init();
            docInfoWindow.show();
            return;
        }
        catch (Exception exception) {
            dbg.dprint("Error displaying the document information", DebugInfoPrinter.DBUG_ERROR);
            dbg.dprint(exception.toString(), DebugInfoPrinter.DBUG_ERROR);
            exception.printStackTrace();
            return;
        }
    }

    public int curPage() {
        return this.curPage;
    }

    public void kill() {
        if (this.pThumb != null) {
            this.pThumb.kill();
            this.pThumb = null;
        }
        if (this.render != null) {
            this.render.kill();
        }
        this.viewer = null;
        this.render = null;
        this.authors = null;
        this.curFile = null;
        this.curFilename = null;
        this.docInfo = null;
        this.preview = null;
        this.bClose = null;
        this.first = null;
        this.prevJump = null;
        this.prev = null;
        this.pageNo = null;
        this.next = null;
        this.nextJump = null;
        this.last = null;
        this.location = null;
        this.bPrint = null;
        this.pStandard = null;
    }
}

