/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.util.Observable;
import java.util.Observer;

public class Icon
extends Panel
implements Runnable,
Observer {
    Image logo;
    final int delay = 50;
    Thread thread;
    float lum = 0.7f;
    Color bgcolor;
    Color current;
    int calls;
    float done = 1.0f;
    Object lock;

    public Icon(Image image) {
        this.logo = image;
        this.current = this.bgcolor = Color.white;
    }

    void pause() {
        try {
            Thread.sleep(50L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (!this.prepareImage(this.logo, this.size().width, this.size().height, this)) {
        }
        float f = 0.01f;
        while (true) {
            this.current = Color.getHSBColor(0.6666667f, 1.0f, this.lum);
            this.repaint();
            this.pause();
            if ((double)this.lum >= 0.99 || (double)this.lum < 0.3) {
                f = -f;
            }
            this.lum += f;
        }
    }

    public synchronized void animate() {
        ++this.calls;
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Icon Thread");
            this.thread.start();
        }
    }

    public synchronized void normal() {
        if (this.calls == 0) {
            return;
        }
        --this.calls;
        if (this.calls == 0) {
            this.thread.stop();
            this.thread = null;
            this.current = this.bgcolor;
            this.repaint();
            this.done = 1.0f;
            this.lock = null;
        }
    }

    public synchronized void update(Observable observable, Object object) {
        float f = ((Float)object).floatValue();
        if (this.lock == null) {
            this.animate();
            this.lock = observable;
        } else if (this.lock != observable) {
            return;
        }
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f == 1.0f) {
            this.normal();
            this.lock = null;
        }
        this.done = f;
        this.repaint();
    }

    public Dimension minimumSize() {
        return new Dimension(50, 50);
    }

    public Dimension preferredSize() {
        if (this.logo != null) {
            return new Dimension(this.logo.getWidth(this), this.logo.getHeight(this));
        }
        return this.minimumSize();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        Image image = this.createImage(n, n2);
        Graphics graphics2 = image.getGraphics();
        if (this.done < 1.0f) {
            int n3 = (int)((float)n2 * (1.0f - this.done));
            graphics2.setColor(Color.lightGray);
            graphics2.fillRect(0, 0, n - 1, n3);
            graphics2.setColor(Color.blue);
            graphics2.fillRect(0, n3, n - 1, n2 - n3 - 1);
            graphics2.setColor(this.current);
            graphics2.fillRect(n / 8, 0, n * 3 / 4 - 1, n2 - 1);
        } else {
            graphics2.setColor(this.current);
            graphics2.fillRect(0, 0, n - 1, n2 - 1);
        }
        if (this.logo == null) {
            graphics2.setColor(Color.blue);
            graphics2.drawString("D", 15, 25);
            graphics2.setColor(Color.green);
            graphics2.drawString("P", 25, 25);
            graphics2.setColor(Color.red);
            graphics2.drawString("X", 35, 25);
        } else {
            graphics2.drawImage(this.logo, 0, 0, n, n2, this);
        }
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, n - 1, n2 - 1);
        graphics2.setColor(this.current);
        graphics.drawImage(image, 0, 0, this);
    }
}

