/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.WJRim;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class WJRMemoryImageSource
implements ImageProducer {
    int width;
    int height;
    ColorModel model;
    Object pixels;
    int pixeloffset;
    int pixelscan;
    Hashtable properties;
    private ImageConsumer theConsumer;

    public WJRMemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4) {
        this.initialize(n, n2, colorModel, byArray, n3, n4, null);
    }

    public WJRMemoryImageSource(int n, int n2, ColorModel colorModel, byte[] byArray, int n3, int n4, Hashtable hashtable) {
        this.initialize(n, n2, colorModel, byArray, n3, n4, hashtable);
    }

    public WJRMemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4) {
        this.initialize(n, n2, colorModel, nArray, n3, n4, null);
    }

    public WJRMemoryImageSource(int n, int n2, ColorModel colorModel, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this.initialize(n, n2, colorModel, nArray, n3, n4, hashtable);
    }

    private void initialize(int n, int n2, ColorModel colorModel, Object object, int n3, int n4, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        this.model = colorModel;
        this.pixels = object;
        this.pixeloffset = n3;
        this.pixelscan = n4;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.properties = hashtable;
    }

    public WJRMemoryImageSource(int n, int n2, int[] nArray, int n3, int n4) {
        this.initialize(n, n2, ColorModel.getRGBdefault(), nArray, n3, n4, null);
    }

    public WJRMemoryImageSource(int n, int n2, int[] nArray, int n3, int n4, Hashtable hashtable) {
        this.initialize(n, n2, ColorModel.getRGBdefault(), nArray, n3, n4, hashtable);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        block2: {
            this.theConsumer = imageConsumer;
            try {
                this.produce();
            }
            catch (Exception exception) {
                if (this.theConsumer == null) break block2;
                this.theConsumer.imageComplete(1);
            }
        }
        this.theConsumer = null;
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.theConsumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.theConsumer == imageConsumer) {
            this.theConsumer = null;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void produce() {
        if (this.theConsumer != null) {
            this.theConsumer.setDimensions(this.width, this.height);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setProperties(this.properties);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setColorModel(this.model);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setHints(30);
        }
        if (this.theConsumer != null) {
            if (this.pixels instanceof byte[]) {
                int n = 0;
                while (n + 9 < this.height) {
                    this.theConsumer.setPixels(0, n, this.width, 10, this.model, (byte[])this.pixels, this.pixeloffset + this.pixelscan * n, this.pixelscan);
                    Thread.currentThread();
                    Thread.yield();
                    n += 10;
                }
                if (n != this.height) {
                    this.theConsumer.setPixels(0, n, this.width, this.height - n, this.model, (byte[])this.pixels, this.pixeloffset + this.pixelscan * n, this.pixelscan);
                }
            } else {
                this.theConsumer.setPixels(0, 0, this.width, this.height, this.model, (int[])this.pixels, this.pixeloffset, this.pixelscan);
            }
        }
        if (this.theConsumer != null) {
            this.theConsumer.imageComplete(3);
        }
    }
}

