/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.util.caching;

import COM.xerox.digipaper.util.CanBeNotified;
import COM.xerox.digipaper.util.CanGetObjects;
import COM.xerox.digipaper.util.caching.CanProduceGetters;
import COM.xerox.digipaper.util.caching.CanProduceGettersCaucus;
import java.util.Enumeration;
import java.util.Hashtable;

public class GenericGetter
implements CanGetObjects {
    protected CanProduceGettersCaucus cauc;
    protected Hashtable getters;
    protected CanBeNotified recipient;

    public GenericGetter(CanProduceGettersCaucus canProduceGettersCaucus) {
        this.cauc = canProduceGettersCaucus;
        this.recipient = null;
        this.getters = new Hashtable();
    }

    public void setRecipient(CanBeNotified canBeNotified) {
        this.recipient = canBeNotified;
    }

    public synchronized boolean startGettingObject(CanBeNotified canBeNotified, Object object) {
        CanProduceGetters canProduceGetters = this.cauc.whichCaucusMemberToGiveTo(object);
        if (canBeNotified != this.recipient) {
            return false;
        }
        if (canBeNotified == null) {
            return false;
        }
        if (canProduceGetters == null) {
            return false;
        }
        CanGetObjects canGetObjects = canProduceGetters.newGetter(null);
        this.getters.put(object, canGetObjects);
        return canGetObjects.startGettingObject(canBeNotified, object);
    }

    public synchronized void stopGettingObject(CanBeNotified canBeNotified, Object object) {
        if (object == null) {
            Enumeration enumeration = this.getters.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                CanGetObjects canGetObjects = (CanGetObjects)this.getters.get(object);
                canGetObjects.stopGettingObject(this.recipient, object);
            }
            return;
        }
        CanGetObjects canGetObjects = (CanGetObjects)this.getters.get(object);
        canGetObjects.stopGettingObject(this.recipient, object);
    }
}

