/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.util.caching;

import COM.xerox.digipaper.util.DebugInfoPrinter;
import COM.xerox.digipaper.util.adt.CircularQueue;
import COM.xerox.digipaper.util.adt.FifoElement;
import COM.xerox.digipaper.util.caching.CanCacheObjects;
import COM.xerox.digipaper.util.caching.CanDisposeOfObjects;
import java.util.Enumeration;
import java.util.Hashtable;

public class GenericCache
implements CanCacheObjects,
CanDisposeOfObjects {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    protected CanDisposeOfObjects disposer;
    protected String _default_disposer_string;
    protected CircularQueue objs;
    protected Hashtable ht;
    protected int max_num_objects_in_cache;
    protected int num_elts_cached;

    public GenericCache(int n, CanDisposeOfObjects canDisposeOfObjects) {
        this.max_num_objects_in_cache = n;
        this.objs = new CircularQueue();
        this.ht = n <= 0 ? new Hashtable() : new Hashtable(n);
        this.num_elts_cached = 0;
        this.disposer = canDisposeOfObjects;
        this._default_disposer_string = null;
    }

    public GenericCache(int n) {
        this(n, null);
        this.disposer = this;
    }

    public void setMaxNumObjectsInCache(int n) {
        int n2 = this.num_elts_cached - n;
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                this.flushSomeObject();
                ++n3;
            }
        }
    }

    public void setStringDefaultDisposer(String string) {
        this._default_disposer_string = string;
    }

    public void dispose(Object object, Object object2) {
        if (this._default_disposer_string != null) {
            dbg.dprint(this._default_disposer_string, DebugInfoPrinter.DBUG_CACHING);
        }
    }

    protected Object find_and_remove_from_queue(Object object, boolean bl) {
        Object v = this.ht.get(object);
        if (v == null) {
            return null;
        }
        Object[] objectArray = (Object[])v;
        FifoElement fifoElement = (FifoElement)objectArray[1];
        this.objs.removeFifoElement(fifoElement);
        if (bl) {
            objectArray[1] = this.objs.addObjectBeforeCurrent(object);
        }
        return objectArray[0];
    }

    public synchronized Object getObject(Object object) {
        Object object2 = this.find_and_remove_from_queue(object, true);
        if (object2 != null) {
            dbg.dprint("GenericCache::getObject() cache has object (it's a " + object2.getClass().getName() + ").", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
        }
        return object2;
    }

    public synchronized Object flushObject(Object object) {
        Object object2 = this.find_and_remove_from_queue(object, false);
        if (object2 != null) {
            --this.num_elts_cached;
            this.ht.remove(object);
            this.disposer.dispose(object, object2);
        }
        return object2;
    }

    protected Object[] flushLastObject() {
        this.objs.backupCurrent();
        FifoElement fifoElement = this.objs.getCurrent();
        Object object = fifoElement.getData();
        this.objs.removeFifoElement(fifoElement);
        Object[] objectArray = (Object[])this.ht.remove(object);
        this.disposer.dispose(object, objectArray[0]);
        --this.num_elts_cached;
        objectArray[1] = object;
        return objectArray;
    }

    public synchronized Object[] flushSomeObject() {
        if (!this.ht.isEmpty()) {
            Object[] objectArray = this.flushLastObject();
            Object object = objectArray[0];
            objectArray[0] = objectArray[1];
            objectArray[1] = object;
            return objectArray;
        }
        return null;
    }

    public void flushAllObjects() {
        while (this.flushSomeObject() != null) {
        }
    }

    public String toString() {
        String string = "(";
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            string = String.valueOf(string) + objectArray[0].toString();
            if (!enumeration.hasMoreElements()) continue;
            string = String.valueOf(string) + ", ";
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public synchronized void setObject(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        dbg.dprint("GenericCache::setObject() adding object to cache (it's a " + object2.getClass().getName() + ").", DebugInfoPrinter.DBUG_CACHING_VERBOSE);
        Object[] objectArray = this.num_elts_cached == this.max_num_objects_in_cache ? this.flushLastObject() : new Object[]{object2, this.objs.addObjectBeforeCurrent(object)};
        this.ht.put(object, objectArray);
        ++this.num_elts_cached;
        dbg.dprint("GenericCache::setObject() cache contains: " + this.toString(), DebugInfoPrinter.DBUG_CACHING_VERBOSE);
    }

    public synchronized int numObjectsInCache() {
        return this.num_elts_cached;
    }

    public int maxNumObjectsInCache() {
        return this.max_num_objects_in_cache;
    }
}

