/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.thumbnails;

import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class Thumbnail
extends Canvas {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    public static Color purple = new Color(128, 0, 128);
    protected static int MAX_SIZE = 100;
    public static Dimension STD_SIZE = new Dimension(MAX_SIZE + 5, MAX_SIZE + 5);
    Image image;
    Component c;
    int width;
    int height;
    protected int page_num;
    boolean should_clear_old_stuff;
    boolean hasFocus;
    boolean visited;

    public Thumbnail(Image image, Component component, int n) {
        this.setImage(image);
        this.c = component;
        this.page_num = n;
        this.hasFocus = false;
        this.visited = false;
    }

    public int hashCode() {
        return this.page_num;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Thumbnail)) {
            return false;
        }
        Thumbnail thumbnail = (Thumbnail)object;
        return this.getPageNum() == thumbnail.getPageNum();
    }

    public int getPageNum() {
        return this.page_num;
    }

    public String toString() {
        return "Thumbnail for page " + this.page_num;
    }

    protected void finalize() {
        dbg.dprint("GARBAGE-COLLECTING a " + this.getClass().getName(), DebugInfoPrinter.DBUG_THUMBNAILS);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        int n = this.image.getHeight(this);
        int n2 = this.image.getWidth(this);
        this.should_clear_old_stuff = n < this.height || n2 < this.width;
        this.width = n2;
        this.height = n;
        if (this.width > MAX_SIZE || this.height > MAX_SIZE) {
            this.image = this.scaleImageForThumbnail(this.image);
        }
        this.repaint();
        this.invalidate();
    }

    protected Image scaleImageForThumbnail(Image image) {
        Image image2;
        boolean bl = false;
        if (this.width < 0 || this.height < 0) {
            return null;
        }
        if (this.height > MAX_SIZE) {
            bl = true;
            this.width = (int)((float)this.width * ((float)MAX_SIZE / (float)this.height));
            this.height = MAX_SIZE;
        }
        if (this.width > MAX_SIZE) {
            bl = true;
            this.height = (int)((float)this.height * ((float)MAX_SIZE / (float)this.width));
            this.width = MAX_SIZE;
        }
        if (bl) {
            image2 = this.c.createImage(this.width, this.height);
            Graphics graphics = image2.getGraphics();
            dbg.dprint("Scaling an image to get one that's the right size for a thumbnail.", DebugInfoPrinter.DBUG_THUMBNAILS);
            graphics.drawImage(image, 0, 0, this.width, this.height, this);
        } else {
            image2 = image;
        }
        return image2;
    }

    public Dimension minimumSize() {
        return STD_SIZE;
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Rectangle imageWindow() {
        int n = this.size().width;
        int n2 = this.size().height;
        int n3 = 2;
        int n4 = 2;
        int n5 = n - 5;
        int n6 = n2 - 5;
        if (this.width < n5) {
            n3 += (n5 - this.width) / 2;
            n5 = this.width;
        }
        if (this.height < n6) {
            n4 += (n6 - this.height) / 2;
            n6 = this.height;
        }
        return new Rectangle(n3, n4, n5, n6);
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.requestFocus();
        return false;
    }

    public boolean gotFocus(Event event, Object object) {
        this.hasFocus = true;
        this.repaintOutline();
        return true;
    }

    public boolean lostFocus(Event event, Object object) {
        this.hasFocus = false;
        this.repaintOutline();
        return true;
    }

    public void repaintOutline() {
        Rectangle rectangle = this.imageWindow();
        this.repaint(rectangle.x - 1, rectangle.y - 1, this.width + 2, 1);
        this.repaint(rectangle.x - 1, rectangle.y + this.height, this.width + 2, 1);
        this.repaint(rectangle.x - 1, rectangle.y - 1, 1, this.height + 2);
        this.repaint(rectangle.x + this.width + 1, rectangle.y, 1, this.height + 2);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.imageWindow().inside(n, n2)) {
            this.visited = true;
            this.repaintOutline();
            return this.postEvent(new Event(this, 1001, null));
        }
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.imageWindow().inside(n, n2)) {
            event.target = this;
            return false;
        }
        return true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.imageWindow();
        if (this.should_clear_old_stuff) {
            graphics.clearRect(0, 0, this.size().width, this.size().height);
            this.should_clear_old_stuff = false;
        }
        if (this.hasFocus) {
            graphics.setColor(Color.blue);
        } else if (this.visited) {
            graphics.setColor(purple);
        } else {
            graphics.setColor(Color.darkGray);
        }
        graphics.drawRect(rectangle.x - 1, rectangle.y - 1, this.width + 2, this.height + 2);
        this.prepareImage(this.image, this.width, this.height, this);
        graphics.drawImage(this.image, rectangle.x, rectangle.y, this.width, this.height, this);
    }
}

