/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff.ifd_info.tc;

import COM.xerox.digipaper.applet.WJRim.PackedImage;
import COM.xerox.digipaper.applet.xiff.DictionaryEntry;
import COM.xerox.digipaper.applet.xiff.XIFFException;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.Bitfile;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.GetDictionaryThread;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.Huffman;
import COM.xerox.digipaper.applet.xiff.ifd_info.tc.TokenDictionary;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.util.Vector;

public class TokenDecoder {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    int[] mAllUse;
    PackedImage[] mAllToks;
    PackedImage[] mAllToks_bp2;
    int[] mFirstCodes;
    int[][] mTokenIndex;
    int mMinCode;
    byte[][] jpeg_buffers;
    public boolean iAmGray;

    TokenDecoder(TokenDictionary[] tokenDictionaryArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (tokenDictionaryArray[0].toks_bp2 != null) {
            this.iAmGray = true;
        }
        int n4 = 0;
        while (n4 < tokenDictionaryArray.length) {
            if (tokenDictionaryArray[n4].jpeg_buffers != null) {
                n += tokenDictionaryArray[n4].jpeg_buffers.length;
            }
            n2 += tokenDictionaryArray[n4].uses.length;
            n3 += tokenDictionaryArray[n4].toks.length;
            ++n4;
        }
        this.mAllUse = new int[n2];
        this.mAllToks = new PackedImage[n3];
        if (this.iAmGray) {
            this.mAllToks_bp2 = new PackedImage[n3];
        }
        this.jpeg_buffers = new byte[n][];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < tokenDictionaryArray.length) {
            if (tokenDictionaryArray[n8].jpeg_buffers != null) {
                System.arraycopy(tokenDictionaryArray[n8].jpeg_buffers, 0, this.jpeg_buffers, n7, tokenDictionaryArray[n8].jpeg_buffers.length);
                n7 += tokenDictionaryArray[n8].jpeg_buffers.length;
            }
            System.arraycopy(tokenDictionaryArray[n8].uses, 0, this.mAllUse, n5, tokenDictionaryArray[n8].uses.length);
            n5 += tokenDictionaryArray[n8].uses.length;
            System.arraycopy(tokenDictionaryArray[n8].toks, 0, this.mAllToks, n6, tokenDictionaryArray[n8].toks.length);
            if (this.iAmGray) {
                System.arraycopy(tokenDictionaryArray[n8].toks_bp2, 0, this.mAllToks_bp2, n6, tokenDictionaryArray[n8].toks_bp2.length);
            }
            n6 += tokenDictionaryArray[n8].toks.length;
            ++n8;
        }
        this.mFirstCodes = new int[32];
        this.mTokenIndex = new int[32][];
        this.mMinCode = Huffman.createCodes(this.mAllUse, this.mFirstCodes, this.mTokenIndex);
    }

    int readTokenCode(Bitfile bitfile) {
        int n = bitfile.readCode(this.mMinCode);
        int n2 = this.mMinCode;
        while (n < this.mFirstCodes[n2]) {
            int n3 = bitfile.readCode(1);
            n = n << 1 | n3;
            ++n2;
        }
        return this.mTokenIndex[n2][n - this.mFirstCodes[n2]];
    }

    static TokenDecoder Retrieve(int[] nArray, XIFFFile xIFFFile, Vector vector) throws XIFFException {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = String.valueOf(string) + " " + nArray[n];
            ++n;
        }
        TokenDecoder tokenDecoder = (TokenDecoder)xIFFFile.getTokenDecoder(string);
        if (tokenDecoder == null) {
            Object object;
            dbg.dprint("Retrieving non-cached token decoder", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
            TokenDictionary[] tokenDictionaryArray = new TokenDictionary[nArray.length];
            GetDictionaryThread[] getDictionaryThreadArray = new GetDictionaryThread[nArray.length];
            n = 0;
            while (n < nArray.length) {
                object = (DictionaryEntry)xIFFFile.SymLib().get(new Integer(nArray[n]));
                if (((DictionaryEntry)object).dictionary == null) {
                    Vector vector2 = vector;
                    synchronized (vector2) {
                        dbg.dprint("Spawning thread to get dictionary: " + nArray[n], DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
                        getDictionaryThreadArray[n] = ((DictionaryEntry)object).thread = new GetDictionaryThread((DictionaryEntry)object, xIFFFile);
                        vector.addElement(((DictionaryEntry)object).thread);
                    }
                    ((DictionaryEntry)object).thread.start();
                } else {
                    dbg.dprint("Getting cached dictionary : " + nArray[n], DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
                    tokenDictionaryArray[n] = ((DictionaryEntry)object).dictionary;
                }
                ++n;
            }
            dbg.dprint("Waiting for GetDictionaryThreads to finish", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
            n = 0;
            while (n < getDictionaryThreadArray.length) {
                if (getDictionaryThreadArray[n] != null) {
                    object = getDictionaryThreadArray[n];
                    synchronized (object) {
                        if (getDictionaryThreadArray[n].isAlive()) {
                            getDictionaryThreadArray[n].sem.P();
                        }
                    }
                    if (getDictionaryThreadArray[n].token_dictionary == null) {
                        dbg.dprint("TokenDecoder: can't access dictionary: " + nArray[n], DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
                        throw new XIFFException("TokenDecoder can't access dictionary: " + nArray[n]);
                    }
                    tokenDictionaryArray[n] = getDictionaryThreadArray[n].token_dictionary;
                }
                ++n;
            }
            dbg.dprint("GetDictionaryThreads are finished now.", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
            dbg.dprint("About to create new TokenDecoder", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
            tokenDecoder = new TokenDecoder(tokenDictionaryArray);
            xIFFFile.putTokenDecoder(string, tokenDecoder);
        } else {
            dbg.dprint("Retrieving cached token decoder", DebugInfoPrinter.DBUG_DICTIONARY_DECODING);
        }
        return tokenDecoder;
    }
}

