/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff;

import COM.xerox.digipaper.applet.xiff.DelayedBuffer;
import COM.xerox.digipaper.applet.xiff.Entry;
import COM.xerox.digipaper.applet.xiff.IFD;
import COM.xerox.digipaper.applet.xiff.RangeAccessFile;
import COM.xerox.digipaper.applet.xiff.TIFFException;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.io.IOException;

public class TIFFFile {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    public RangeAccessFile RAFile;
    protected int _offset_to_next_ifd;
    boolean _big_endian;
    final int TIFF_MAGICNUM = 42;
    final int TIFF_BIGENDIAN = 19789;
    final int TIFF_LITTLEENDIAN = 18761;
    final int TIFF_HEADERSIZE = 8;
    final int TIFF_MINVALIDIFDENTRIES = 1;

    public int GetShort(byte[] byArray, int n) {
        if (this._big_endian) {
            return byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
        }
        return byArray[n] & 0xFF | byArray[n + 1] << 8 & 0xFF00;
    }

    public int GetLong(byte[] byArray, int n) {
        if (this._big_endian) {
            return byArray[n] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
        }
        return byArray[n] & 0xFF | byArray[n + 1] << 8 & 0xFF00 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 3] << 24 & 0xFF000000;
    }

    public void PutShort(byte[] byArray, int n, int n2) {
        if (this._big_endian) {
            byArray[n] = (byte)((n2 & 0xFF00) >> 8);
            byArray[n + 1] = (byte)(n2 & 0xFF);
            return;
        }
        byArray[n + 1] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n] = (byte)(n2 & 0xFF);
    }

    public void PutLong(byte[] byArray, int n, int n2) {
        if (this._big_endian) {
            byArray[n] = (byte)((n2 & 0xFF000000) >> 24);
            byArray[n + 1] = (byte)((n2 & 0xFF0000) >> 16);
            byArray[n + 2] = (byte)((n2 & 0xFF00) >> 8);
            byArray[n + 3] = (byte)(n2 & 0xFF);
            return;
        }
        byArray[n + 3] = (byte)((n2 & 0xFF000000) >> 24);
        byArray[n + 2] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n + 1] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n] = (byte)(n2 & 0xFF);
    }

    public TIFFFile(RangeAccessFile rangeAccessFile) throws IOException, TIFFException {
        this.RAFile = rangeAccessFile;
        DelayedBuffer delayedBuffer = this.RAFile.ReadRange(0, 8);
        byte[] byArray = delayedBuffer.GetData();
        int n = this.GetShort(byArray, 0);
        if (n == 19789) {
            this._big_endian = true;
        } else if (n == 18761) {
            this._big_endian = false;
        } else {
            throw new TIFFException("TIFF file: Bad Endian mode " + n);
        }
        int n2 = this.GetShort(byArray, 2);
        if (n2 != 42) {
            throw new TIFFException("TIFF file:Bad magic number " + n2);
        }
        this._offset_to_next_ifd = this.GetLong(byArray, 4);
        if (this._offset_to_next_ifd < 8) {
            throw new TIFFException("TIFF file: Bad Offset " + this._offset_to_next_ifd);
        }
    }

    public void ReadNextIFD(IFD iFD) throws IOException, TIFFException {
        this.ReadIFD(this._offset_to_next_ifd, iFD);
    }

    public void ReadIFD(int n, IFD iFD) throws IOException, TIFFException {
        Entry entry = new Entry();
        DelayedBuffer delayedBuffer = this.RAFile.ReadRange(n, 18);
        byte[] byArray = delayedBuffer.GetData();
        int n2 = this.GetShort(byArray, 0);
        if (n2 < 1) {
            throw new TIFFException("TIFF file: 0 Entries in IFD");
        }
        int n3 = 2;
        int n4 = 0;
        while (n4 < n2) {
            entry.Offset = n + n4 * 12 + 2;
            entry.Tag = this.GetShort(byArray, n3);
            entry.Type = this.GetShort(byArray, n3 += 2);
            n3 += 2;
            if (n4 == 1) {
                n3 = 0;
                delayedBuffer = this.RAFile.ReadRange(n + 18, 12 * (n2 - 1));
                byArray = delayedBuffer.GetData();
            }
            entry.Count = this.GetLong(byArray, n3);
            n3 += 4;
            switch (entry.Type) {
                case 1: 
                case 2: {
                    int n5;
                    Object[] objectArray;
                    if (entry.Count <= 4) {
                        objectArray = new byte[entry.Count];
                        n5 = 0;
                        while (n5 < entry.Count) {
                            objectArray[n5] = byArray[n3 + n5];
                            ++n5;
                        }
                        entry.Value = objectArray;
                    } else {
                        entry.Value = new Integer(this.GetLong(byArray, n3));
                    }
                    n3 += 4;
                    break;
                }
                case 3: {
                    int n5;
                    Object[] objectArray;
                    if (entry.Count <= 2) {
                        objectArray = new int[entry.Count];
                        n5 = 0;
                        while (n5 < entry.Count) {
                            objectArray[n5] = this.GetShort(byArray, n3 + n5 * 2);
                            ++n5;
                        }
                        entry.Value = objectArray;
                    } else {
                        entry.Value = new Integer(this.GetLong(byArray, n3));
                    }
                    n3 += 4;
                    break;
                }
                default: {
                    entry.Value = new Integer(this.GetLong(byArray, n3));
                    n3 += 4;
                }
            }
            iFD._read_entry(entry, this);
            ++n4;
        }
        iFD.NextIFD = this._offset_to_next_ifd = this.GetLong(byArray, n3);
    }
}

