/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.xiff;

import COM.xerox.digipaper.applet.xiff.IFD;
import COM.xerox.digipaper.applet.xiff.IFDInfo;
import COM.xerox.digipaper.applet.xiff.PageDescriptor;
import COM.xerox.digipaper.applet.xiff.PageInfo;
import COM.xerox.digipaper.applet.xiff.XIFFException;
import COM.xerox.digipaper.applet.xiff.XIFFFile;
import COM.xerox.digipaper.applet.xiff.ifd_info.AnnotationTableHeader;
import COM.xerox.digipaper.util.BinarySemaphore;
import COM.xerox.digipaper.util.CanBeNotified;
import COM.xerox.digipaper.util.CanGetObjects;
import COM.xerox.digipaper.util.CanGetObjectsDirectly;
import COM.xerox.digipaper.util.Counter;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;

public class PageInfoReader
implements CanBeNotified {
    protected static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    Hashtable ifdinfo_vectors;
    Hashtable ifds_trans;
    protected XIFFFile xiff_file;
    protected CanGetObjects ii_getter;
    protected CanGetObjectsDirectly pi_getter;

    public PageInfoReader(XIFFFile xIFFFile, CanGetObjects canGetObjects, CanGetObjectsDirectly canGetObjectsDirectly) {
        this.xiff_file = xIFFFile;
        this.pi_getter = canGetObjectsDirectly;
        this.ii_getter = canGetObjects;
        this.ifdinfo_vectors = new Hashtable();
        this.ifds_trans = new Hashtable();
    }

    protected IFD ReadIFD(int n) throws XIFFException {
        IFD iFD = null;
        try {
            iFD = new IFD(this.xiff_file);
            this.xiff_file.ReadIFD(n, iFD);
        }
        catch (Exception exception) {
            dbg.dprint("PageInfoReader::ReadIFD() problem reading the ifd at offset " + n + ".", DebugInfoPrinter.DBUG_ERROR);
            exception.printStackTrace();
            throw new XIFFException();
        }
        return iFD;
    }

    protected IFD start_getting_an_IFDInfo(int n, Vector vector, Counter counter, boolean bl) throws XIFFException {
        IFD iFD = this.ReadIFD(n);
        Object object = counter;
        synchronized (object) {
            counter.increment();
        }
        object = this.ifdinfo_vectors;
        synchronized (object) {
            this.ifdinfo_vectors.remove(iFD);
            this.ifdinfo_vectors.put(iFD, vector);
        }
        dbg.dprint("PageInfoReader -- IFD at offset " + n + " has compression type " + iFD.Compression, DebugInfoPrinter.DBUG_XIFF_VERBOSE);
        if (!this.ii_getter.startGettingObject(this, iFD)) {
            throw new XIFFException("unknown type of IFD");
        }
        if (bl && iFD.NextIFD != 0) {
            this.start_getting_an_IFDInfo(iFD.NextIFD, vector, counter, bl);
        }
        return iFD;
    }

    protected void start_getting_IFDInfos(int n, Vector vector, Counter counter) throws XIFFException {
        IFD iFD = this.start_getting_an_IFDInfo(n, vector, counter, false);
        iFD.makePrimary();
        int[] nArray = iFD.getSubIFDOffsets();
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            if (nArray[n2] != 0) {
                this.start_getting_an_IFDInfo(nArray[n2], vector, counter, true);
            }
            ++n2;
        }
    }

    public PageInfo readPageInfo(PageDescriptor pageDescriptor, Vector vector) {
        PageInfo pageInfo;
        Vector<Object> vector2 = new Vector<Object>();
        int n = pageDescriptor.getPageNumber();
        BinarySemaphore binarySemaphore = new BinarySemaphore();
        Counter counter = new Counter();
        vector.addElement(this.ii_getter);
        vector2.addElement(new Boolean(true));
        vector2.addElement(binarySemaphore);
        vector2.addElement(counter);
        try {
            this.start_getting_IFDInfos(pageDescriptor.getOffset(), vector2, counter);
            binarySemaphore.P();
            if (!((Boolean)vector2.elementAt(0)).booleanValue()) {
                dbg.dprint("PageInfoReader::readPageInfo() problem reading at least one IFD for page " + n, DebugInfoPrinter.DBUG_ERROR);
                return null;
            }
            vector2.removeElementAt(0);
            vector2.removeElementAt(0);
            vector2.removeElementAt(0);
            pageInfo = (PageInfo)this.pi_getter.getObject(vector2);
        }
        catch (Exception exception) {
            String string = exception.getMessage() == null ? "" : exception.getMessage();
            dbg.dprint("PageInfoReader::readPageInfo() exception accessing page " + n + ": " + string, DebugInfoPrinter.DBUG_ERROR);
            exception.printStackTrace();
            return null;
        }
        return pageInfo;
    }

    public void Update(boolean bl, Object object, Object object2) {
        Counter counter;
        BinarySemaphore binarySemaphore;
        Vector vector;
        IFD iFD = (IFD)object;
        IFD iFD2 = null;
        IFDInfo iFDInfo = (IFDInfo)object2;
        Object object3 = this.ifdinfo_vectors;
        synchronized (object3) {
            vector = (Vector)this.ifdinfo_vectors.remove(object);
        }
        object3 = vector;
        synchronized (object3) {
            binarySemaphore = (BinarySemaphore)vector.elementAt(1);
            counter = (Counter)vector.elementAt(2);
            if (object2 == null) {
                vector.setElementAt(new Boolean(false), 0);
            }
            vector.addElement(iFDInfo);
        }
        if (!iFD.isPrimary()) {
            int[] nArray = iFD.getSubIFDOffsets();
            if (nArray.length > 1) {
                object3 = vector;
                synchronized (object3) {
                    vector.setElementAt(new Boolean(false), 0);
                }
            }
            if (nArray.length > 0 && nArray[0] != 0) {
                try {
                    iFD2 = this.start_getting_an_IFDInfo(nArray[0], vector, counter, false);
                }
                catch (XIFFException xIFFException) {
                    dbg.dprint("PageInfoReader -- caught exception reading IFD for a transparency mask:", DebugInfoPrinter.DBUG_ERROR);
                    xIFFException.printStackTrace();
                    Vector vector2 = vector;
                    synchronized (vector2) {
                        vector.setElementAt(new Boolean(false), 0);
                        return;
                    }
                }
                object3 = this.ifds_trans;
                synchronized (object3) {
                    this.ifds_trans.put(iFD2, iFDInfo);
                }
            }
        }
        object3 = this.ifds_trans;
        synchronized (object3) {
            IFDInfo iFDInfo2 = (IFDInfo)this.ifds_trans.remove(iFD);
            if (iFDInfo2 != null) {
                iFDInfo2.setTransparencyMask(iFDInfo);
            }
        }
        object3 = counter;
        synchronized (object3) {
            if (counter.decrement() == 0) {
                binarySemaphore.V();
            }
            return;
        }
    }

    void ReadAnnotationHeader(PageDescriptor pageDescriptor, XIFFFile xIFFFile, Component component) {
        this.ReadAnnotationHeader(pageDescriptor, xIFFFile);
        component.repaint();
    }

    public void ReadAnnotationHeader(PageDescriptor pageDescriptor, XIFFFile xIFFFile) {
        IFD iFD = null;
        Object object = pageDescriptor.annot_lock;
        synchronized (object) {
            if (pageDescriptor.annot_hdr == null) {
                dbg.dprint("Reading Annotation Header", DebugInfoPrinter.DBUG_ANNOTATIONS);
                try {
                    iFD = this.ReadIFD(pageDescriptor.getOffset());
                    pageDescriptor.annot_hdr = new AnnotationTableHeader(iFD.annotEntry, xIFFFile);
                }
                catch (XIFFException xIFFException) {
                    dbg.dprint("Error reading IFD at offset " + pageDescriptor.getOffset());
                    xIFFException.printStackTrace();
                }
            }
            return;
        }
    }
}

