/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import COM.xerox.digipaper.applet.client.Client;
import COM.xerox.digipaper.applet.client.ClientCanvas;
import COM.xerox.digipaper.applet.client.LinkRegion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Scrollbar;

public class ScrollClientCanvas
extends Panel {
    static final int DEFAULT_X = 640;
    static final int DEFAULT_Y = 480;
    public ClientCanvas canvas;
    private Scrollbar vert;
    private Scrollbar horiz;
    private LinkRegion current;

    public ScrollClientCanvas(Client client) {
        this.canvas = new ClientCanvas(client);
        this.init();
    }

    public ScrollClientCanvas(ClientCanvas clientCanvas) {
        this.canvas = clientCanvas;
        this.init();
    }

    public void init() {
        this.vert = new Scrollbar(1);
        this.horiz = new Scrollbar(0);
        this.setLayout(new BorderLayout());
        this.add("Center", this.canvas);
        this.add("East", this.vert);
        this.add("South", this.horiz);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (event.target == this.vert) {
                    this.DoVert((Integer)event.arg);
                } else if (event.target == this.horiz) {
                    this.DoHoriz((Integer)event.arg);
                }
                this.canvas.repaint();
            }
        }
        return super.handleEvent(event);
    }

    public void setCoords(int n, int n2) {
        this.DoVert(n2);
        this.DoHoriz(n);
        this.canvas.repaint();
    }

    public void DoVert(int n) {
        if (n > this.canvas.imageHeight() - this.canvas.size().height) {
            n = this.canvas.imageHeight() - this.canvas.size().height;
        }
        if (n < 0) {
            n = 0;
        }
        this.canvas.dy = n;
        this.vert.setValue(n);
    }

    public void DoHoriz(int n) {
        if (n > this.canvas.imageWidth() - this.canvas.size().width) {
            n = this.canvas.imageWidth() - this.canvas.size().width;
        }
        if (n < 0) {
            n = 0;
        }
        this.canvas.dx = n;
        this.horiz.setValue(n);
    }

    public void UpdateVert() {
        int n = this.canvas.size().height;
        if (n <= 0) {
            return;
        }
        if (n >= this.canvas.imageHeight()) {
            this.canvas.dy = 0;
            this.vert.hide();
            ((Component)this).invalidate();
            return;
        }
        if (!this.vert.isVisible()) {
            this.vert.show();
        }
        if (this.canvas.image != null) {
            if (this.canvas.dy + n > this.canvas.imageHeight()) {
                this.canvas.dy = this.canvas.imageHeight() - n;
            }
            if (this.canvas.dy < 0) {
                this.canvas.dy = 0;
            }
            this.vert.setValues(this.canvas.dy, (int)((double)n * 0.9), 0, this.canvas.imageHeight() - n);
            this.vert.setPageIncrement((int)((double)n * 0.9));
            return;
        }
        this.vert.setValues(0, n, 0, 0);
    }

    public void UpdateHoriz() {
        int n = this.canvas.size().width;
        if (n <= 0) {
            return;
        }
        if (n >= this.canvas.imageWidth()) {
            this.horiz.hide();
            ((Component)this).invalidate();
            this.canvas.dx = 0;
            return;
        }
        if (!this.horiz.isVisible()) {
            this.horiz.show();
        }
        if (this.canvas.image != null) {
            if (this.canvas.dx + n > this.canvas.imageWidth()) {
                this.canvas.dx = this.canvas.imageWidth() - n;
            }
            if (this.canvas.dx < 0) {
                this.canvas.dx = 0;
            }
            this.horiz.setValues(this.canvas.dx, (int)((double)n * 0.9), 0, this.canvas.imageWidth() - n);
            this.horiz.setPageIncrement((int)((double)n * 0.9));
            return;
        }
        this.horiz.setValues(0, n, 0, 0);
    }

    public void paint(Graphics graphics) {
        this.UpdateHoriz();
        this.UpdateVert();
        this.validate();
        this.canvas.repaint();
    }
}

