/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class DragSurface
extends Canvas {
    Image i_world;
    Dimension world = new Dimension(0, 0);
    Dimension window = new Dimension(0, 0);
    int dx = 0;
    int dy = 0;
    int tx;
    int ty;
    int prevx;
    int prevy;
    float factor;

    public Dimension scale(Dimension dimension) {
        if (this.world.width <= 0 || this.world.height <= 0) {
            return new Dimension(0, 0);
        }
        this.factor = (float)this.size().width / (float)this.world.width;
        if ((float)this.size().height / (float)this.world.height < this.factor) {
            this.factor = (float)this.size().height / (float)this.world.height;
        }
        int n = (int)((float)dimension.width * this.factor);
        int n2 = (int)((float)dimension.height * this.factor);
        this.prepareImage(this.i_world, n, n2, this);
        return new Dimension(n, n2);
    }

    public Dimension minimumSize() {
        return new Dimension(50, 50);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void setWorld(Image image, Dimension dimension, Dimension dimension2) {
        this.world = dimension;
        this.i_world = image;
        this.setWindow(this.dx, this.dy, dimension2);
    }

    public void setWindow(int n, int n2, Dimension dimension) {
        this.window = dimension;
        if (dimension.width > this.world.width) {
            this.window.width = this.world.width;
        }
        if (dimension.height > this.world.height) {
            this.window.height = this.world.height;
        }
        this.setCoords(n, n2);
    }

    public void setCoords(int n, int n2) {
        this.dx = n;
        this.dy = n2;
        if (this.dx + this.window.width > this.world.width) {
            this.dx = this.world.width - this.window.width;
        }
        if (this.dy + this.window.height > this.world.height) {
            this.dy = this.world.height - this.window.height;
        }
        if (this.dx < 0) {
            this.dx = 0;
        }
        if (this.dy < 0) {
            this.dy = 0;
        }
        this.repaint();
    }

    boolean isUseful() {
        return this.world.width > this.window.width || this.world.height > this.window.height;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.isUseful()) {
            return super.mouseDown(event, n, n2);
        }
        return this.mouseDrag(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (!this.isUseful()) {
            return super.mouseDrag(event, n, n2);
        }
        int n3 = n - this.tx;
        int n4 = n2 - this.ty;
        int n5 = n3 - (int)((double)((float)this.window.width * this.factor) / 2.0);
        int n6 = n4 - (int)((double)((float)this.window.height * this.factor) / 2.0);
        this.setCoords((int)((float)n5 / this.factor), (int)((float)n6 / this.factor));
        this.deliverEvent(new Event(this, System.currentTimeMillis(), 1001, this.dx, this.dy, 0, 0, this));
        return true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.i_world == null) {
            graphics.clearRect(0, 0, n, n2);
            return;
        }
        Dimension dimension = this.scale(this.world);
        Dimension dimension2 = this.scale(this.window);
        this.tx = (n - dimension.width) / 2;
        this.ty = (n2 - dimension.height) / 2;
        Image image = this.createImage(n, n2);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, n, n2);
        graphics2.drawImage(this.i_world, this.tx, this.ty, dimension.width - 1, dimension.height - 1, this);
        graphics2.setColor(Color.black);
        graphics2.drawRect(this.tx, this.ty, dimension.width - 1, dimension.height - 1);
        if (this.isUseful()) {
            Dimension dimension3 = this.scale(new Dimension(this.dx, this.dy));
            int n3 = this.tx + dimension3.width;
            int n4 = this.ty + dimension3.height;
            graphics2.setColor(Color.white);
            graphics2.setXORMode(Color.lightGray);
            graphics2.fillRect(this.tx, this.ty, dimension.width - 1, dimension.height - 1);
            graphics2.setPaintMode();
            graphics2.clipRect(n3, n4, dimension2.width, dimension2.height);
            graphics2.drawImage(this.i_world, this.tx, this.ty, dimension.width - 1, dimension.height - 1, this);
            graphics2.setColor(Color.black);
            graphics2.drawRect(n3, n4, dimension2.width - 1, dimension2.height - 1);
        }
        graphics.drawImage(image, 0, 0, this);
    }
}

