/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.WJRim;

import COM.xerox.digipaper.applet.MMR.MMR;
import COM.xerox.digipaper.util.DebugInfoPrinter;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.IOException;

public class PackedImage {
    static DebugInfoPrinter dbg = new DebugInfoPrinter(DebugInfoPrinter.DBUG_LEVEL);
    public int width;
    public int height;
    public int xbase;
    public int ybase;
    public long[][] data;
    protected int row_width;

    public PackedImage(int n, int n2) {
        this.data = new long[n2][(n + 63) / 64];
        this.width = n;
        this.height = n2;
        this.row_width = (n + 63) / 64;
        this.ybase = 0;
        this.xbase = 0;
    }

    public PackedImage(byte[] byArray, int n, int n2, int n3, int n4) throws IOException {
        if (n4 == 0) {
            this.readFrom(byArray, n, n2, n3);
            return;
        }
        this.readG4From(byArray, n, n2, n3, n4);
    }

    public PackedImage(DataInputStream dataInputStream, int n, int n2, int n3) throws IOException {
        if (n3 == 0) {
            this.readFrom(dataInputStream, n, n2);
            return;
        }
        this.readG4From(dataInputStream, n, n2, n3);
    }

    public static void setToAllOnes(PackedImage packedImage, int n, int n2, int n3, int n4) {
        int n5 = n3 - n + 1;
        int n6 = (n5 + 63) / 64;
        int n7 = n / 64;
        int n8 = n % 64;
        int n9 = n4 - n2 + 1;
        int n10 = n5 % 64;
        long l = -1L << 64 * n6 - n5;
        int n11 = 64 - n8;
        if (n8 == 0) {
            int n12 = 0;
            while (n12 < n9) {
                long[] lArray = packedImage.data[n12 + n2];
                int n13 = 0;
                while (n13 < n6 - 1) {
                    lArray[n7 + n13] = -1L;
                    ++n13;
                }
                int n14 = n7 + n13;
                lArray[n14] = lArray[n14] | l;
                ++n12;
            }
            return;
        }
        int n15 = 0;
        while (n15 < n9) {
            long[] lArray = packedImage.data[n15 + n2];
            int n16 = 0;
            while (n16 < n6 - 1) {
                lArray[n7 + n16] = -1L >>> n8;
                lArray[n7 + n16 + 1] = -1L << n11;
                ++n16;
            }
            if (n8 + n10 > 64) {
                int n17 = n7 + n6 - 1;
                lArray[n17] = lArray[n17] | l >>> n8;
                int n18 = n7 + n6;
                lArray[n18] = lArray[n18] | l << n11;
            } else {
                int n19 = n7 + n6 - 1;
                lArray[n19] = lArray[n19] | l >>> n8;
            }
            ++n15;
        }
    }

    public int blat(PackedImage packedImage, int n) {
        long[][] lArray = packedImage.data;
        int n2 = 0;
        int n3 = packedImage.height;
        while (n2 < n3) {
            long[] lArray2 = lArray[n2];
            long[] lArray3 = this.data[n++];
            int n4 = 0;
            while (n4 < this.row_width) {
                lArray3[n4] = lArray2[n4];
                ++n4;
            }
            ++n2;
        }
        return n;
    }

    private void readFrom(DataInputStream dataInputStream, int n, int n2) throws IOException {
        byte[] byArray = new byte[n2 * ((n + 7) / 8)];
        dataInputStream.readFully(byArray);
        this.readFrom(byArray, 0, n, n2);
    }

    private void readG4From(DataInputStream dataInputStream, int n, int n2, int n3) throws IOException {
        byte[] byArray = new byte[n3];
        dataInputStream.readFully(byArray);
        this.readG4From(byArray, 0, n, n2, n3);
    }

    private void readFrom(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = (n2 + 7) / 8;
        int n5 = n4 % 8;
        this.row_width = (n2 + 63) / 64;
        this.data = new long[n3][this.row_width];
        this.ybase = 0;
        this.xbase = 0;
        this.width = n2;
        this.height = n3;
        int n6 = 0;
        while (n6 < n3) {
            long[] lArray = this.data[n6];
            int n7 = 0;
            int n8 = 0;
            while (n8 + 7 < n4) {
                lArray[n7] = ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
                ++n7;
                n8 += 8;
                n += 8;
            }
            int n9 = 0;
            while (n9 < n5) {
                int n10 = this.row_width - 1;
                lArray[n10] = lArray[n10] | ((long)byArray[n] & 0xFFL) << 56 - n9 * 8;
                ++n9;
                ++n;
            }
            ++n6;
        }
    }

    private void readG4From(byte[] byArray, int n, int n2, int n3, int n4) throws IOException {
        this.row_width = (n2 + 63) / 64;
        this.data = new long[n3][this.row_width];
        this.ybase = 0;
        this.xbase = 0;
        this.width = n2;
        this.height = n3;
        MMR mMR = new MMR();
        mMR.DecompressMMR(byArray, n, this);
    }

    public ImageProducer toImage() {
        return this.toImage(-16777216, 0xFFFFFF);
    }

    public void blat(byte[] byArray, int n, int n2, int n3, byte by) {
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = 0;
            int n6 = (n4 + n3) * n + n2;
            while (n5 < this.width) {
                long l = this.data[n4][n5 / 64];
                int n7 = this.width - n5;
                if (n7 > 64) {
                    n7 = 64;
                }
                if (l != 0L) {
                    int n8 = 0;
                    while (n8 < n7) {
                        if ((l & Long.MIN_VALUE) != 0L) {
                            byArray[n6 + n8] = by;
                        }
                        l <<= 1;
                        ++n8;
                    }
                }
                n5 += 64;
                n6 += 64;
            }
            ++n4;
        }
    }

    public ImageProducer toImage(int n, int n2) {
        byte[] byArray = new byte[this.width * this.height];
        this.blat(byArray, this.width, 0, 0, (byte)1);
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = new byte[2];
        byte[] byArray5 = new byte[2];
        byArray5[0] = (byte)(n2 >>> 24);
        byArray2[0] = (byte)(n2 >>> 16 & 0xFF);
        byArray3[0] = (byte)(n2 >>> 8 & 0xFF);
        byArray4[0] = (byte)(n2 & 0xFF);
        byArray5[1] = (byte)(n >>> 24);
        byArray2[1] = (byte)(n >>> 16 & 0xFF);
        byArray3[1] = (byte)(n >>> 8 & 0xFF);
        byArray4[1] = (byte)(n & 0xFF);
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray2, byArray3, byArray4, byArray5);
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, (ColorModel)indexColorModel, byArray, 0, this.width);
        return memoryImageSource;
    }

    public static void gray_blat(byte[] byArray, int n, int n2, int n3, PackedImage packedImage, PackedImage packedImage2) {
        int n4 = 0;
        while (n4 < packedImage.height) {
            int n5 = 0;
            int n6 = (n4 + n3) * n + n2;
            while (n5 < packedImage.width) {
                long l = packedImage.data[n4][n5 / 64];
                long l2 = packedImage2.data[n4][n5 / 64];
                l2 ^= l;
                int n7 = packedImage.width - n5;
                if (n7 > 64) {
                    n7 = 64;
                }
                if (l != 0L || l2 != 0L) {
                    int n8 = 0;
                    while (n8 < n7) {
                        long l3 = l >>> 62 & 2L | l2 >>> 63;
                        int n9 = n6 + n8;
                        byArray[n9] = (byte)((long)byArray[n9] | l3);
                        l <<= 1;
                        l2 <<= 1;
                        ++n8;
                    }
                }
                n5 += 64;
                n6 += 64;
            }
            ++n4;
        }
    }

    public static void blat(PackedImage packedImage, int n, int n2, PackedImage packedImage2) {
        int n3 = packedImage2.row_width;
        int n4 = n / 64;
        int n5 = n % 64;
        int n6 = packedImage2.height;
        int n7 = 64 - n5;
        if (n < 0 || n2 < 0) {
            dbg.dprint("Problem: blatting " + packedImage2.width + "x" + packedImage2.height + " at (" + n + "," + n2 + ") into " + packedImage.width + "x" + packedImage.height, DebugInfoPrinter.DBUG_ERROR);
            return;
        }
        if (n5 == 0) {
            int n8 = 0;
            while (n8 < n6) {
                long[] lArray = packedImage.data[n8 + n2];
                long[] lArray2 = packedImage2.data[n8];
                int n9 = 0;
                while (n9 < n3) {
                    int n10 = n4 + n9;
                    lArray[n10] = lArray[n10] | lArray2[n9];
                    ++n9;
                }
                ++n8;
            }
            return;
        }
        int n11 = 0;
        while (n11 < n6) {
            long l;
            long[] lArray = packedImage.data[n11 + n2];
            long[] lArray3 = packedImage2.data[n11];
            int n12 = 0;
            while (n12 < n3 - 1) {
                l = lArray3[n12];
                int n13 = n4 + n12;
                lArray[n13] = lArray[n13] | l >>> n5;
                int n14 = n4 + n12 + 1;
                lArray[n14] = lArray[n14] | l << n7;
                ++n12;
            }
            l = lArray3[n3 - 1];
            if (n5 + packedImage2.width % 64 > 64) {
                int n15 = n4 + n3 - 1;
                lArray[n15] = lArray[n15] | l >>> n5;
                int n16 = n4 + n3;
                lArray[n16] = lArray[n16] | l << n7;
            } else {
                int n17 = n4 + n3 - 1;
                lArray[n17] = lArray[n17] | l >>> n5;
            }
            ++n11;
        }
    }

    public void clipInto(PackedImage packedImage, int n) {
        boolean bl;
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        int n4 = packedImage.row_width;
        int n5 = packedImage.width % 64 == 0 ? 64 : packedImage.width & 0x3F;
        long l = -1L << 64 - n5;
        boolean bl2 = bl = n3 + n5 > 64;
        if (n3 > 0) {
            int n6 = 0;
            while (n6 < this.height) {
                long l2 = this.data[n6][n2] << n3;
                int n7 = 0;
                while (n7 < n4 - 1) {
                    packedImage.data[n6][n7] = l2 | this.data[n6][n7 + n2 + 1] >>> 64 - n3;
                    l2 = this.data[n6][n7 + n2 + 1] << n3;
                    ++n7;
                }
                packedImage.data[n6][n4 - 1] = bl ? (l2 | this.data[n6][n4 + n2] >>> 64 - n3) & l : l2 & l;
                ++n6;
            }
            return;
        }
        int n8 = 0;
        while (n8 < this.height) {
            int n9 = 0;
            while (n9 < n4) {
                packedImage.data[n8][n9] = this.data[n8][n9 + n2];
                ++n9;
            }
            long[] lArray = packedImage.data[n8];
            int n10 = n4 - 1;
            lArray[n10] = lArray[n10] & l;
            ++n8;
        }
    }
}

