/*
 * Decompiled with CFR 0.152.
 */
package COM.xerox.digipaper.applet.WJRim;

import COM.xerox.digipaper.applet.WJRim.G3CodeTable;

public final class G4Tables {
    static short[][] g4Fax2DFSM;
    static short[][] g4Fax1DFSM;
    static boolean inited;
    static final int ACT_INCOMP = 0;
    static final int ACT_INVALID = 1;
    static final int ACT_EOL = 2;
    static final int ACT_RUNT = 3;
    static final int ACT_RUN = 66;
    static final int MODE_NULL = 0;
    static final int MODE_PASS = 1;
    static final int MODE_HORIZ = 2;
    static final int MODE_VERT_V0 = 6;
    static final int MODE_VERT_VR1 = 7;
    static final int MODE_VERT_VR2 = 8;
    static final int MODE_VERT_VR3 = 9;
    static final int MODE_VERT_VL1 = 5;
    static final int MODE_VERT_VL2 = 4;
    static final int MODE_VERT_VL3 = 3;
    static final int MODE_UNCOMP = 10;
    static final int MODE_ERROR = 11;
    static final int MODE_ERROR_1 = 12;
    static final int G3CODE_EOL = -1;
    static final int G3CODE_INVALID = -2;
    static final int G3CODE_EOF = -3;
    static final int G3CODE_INCOMP = -4;
    private static final byte[] g3whitelen;
    private static final short[] g3whitecode;
    private static final short[] g3whiterun;
    private static G3CodeTable g4FaxWhiteCodes;
    private static final byte[] g3blacklen;
    private static final short[] g3blackcode;
    private static final short[] g3blackrun;
    private static G3CodeTable g4FaxBlackCodes;
    private static byte[][] null_mode;
    private static byte[][] null_mode_next_state;
    private static short null_mode_prefix_count;
    private static int[] null_mode_prefix;
    private static byte[][] horiz_mode;
    private static byte[][] horiz_mode_next_state;
    private static int[] horiz_mode_prefix;
    private static byte[] horiz_mode_color;
    private static short horiz_mode_prefix_count;
    private static short[] hashtab;

    private static final int append_0(int n) {
        return n + 65536;
    }

    private static final int append_1(int n) {
        byte by = (byte)(n >> 16 & 0xF);
        return n + 65536 + (1 << 15 - by);
    }

    private static final short white_run_length(int n) {
        return g4FaxWhiteCodes.search(n);
    }

    private static final short black_run_length(int n) {
        return g4FaxBlackCodes.search(n);
    }

    private static final short find_null_mode_prefix(int n) {
        if (n == 0) {
            return 0;
        }
        short s = 8;
        while (s < null_mode_prefix_count) {
            if (n == null_mode_prefix[s]) {
                return s;
            }
            s = (short)(s + 1);
        }
        short s2 = null_mode_prefix_count;
        null_mode_prefix_count = (short)(s2 + 1);
        G4Tables.null_mode_prefix[s2] = n;
        return (short)(null_mode_prefix_count - 1);
    }

    private static final short hash(int n, byte by) {
        int n2 = n >> 16;
        int n3 = (n & 0xFFFF) >> 15 - n2;
        int n4 = (n3 << 13 - n2) + (1 << 12 - n2) + by;
        return (short)n4;
    }

    private static final short find_horiz_mode_prefix(int n, byte by) {
        short s = G4Tables.hash(n, by);
        if (hashtab[s] != 0) {
            return (short)(hashtab[s] - 1);
        }
        G4Tables.horiz_mode_prefix[G4Tables.horiz_mode_prefix_count] = n;
        G4Tables.horiz_mode_color[G4Tables.horiz_mode_prefix_count] = by;
        G4Tables.hashtab[s] = (short)(horiz_mode_prefix_count + 1);
        horiz_mode_prefix_count = (short)(horiz_mode_prefix_count + 1);
        return (short)(horiz_mode_prefix_count - 1);
    }

    private static final short null_mode_type(int n) {
        switch (n) {
            case 98304: {
                return 6;
            }
            case 221184: {
                return 7;
            }
            case 212992: {
                return 5;
            }
            case 204800: {
                return 2;
            }
            case 266240: {
                return 1;
            }
            case 396288: {
                return 8;
            }
            case 395264: {
                return 4;
            }
            case 460288: {
                return 9;
            }
            case 459776: {
                return 3;
            }
            case 524800: {
                return 11;
            }
            case 590592: {
                return 11;
            }
            case 656256: {
                return 11;
            }
            case 656320: {
                return 10;
            }
            case 458752: {
                return 12;
            }
        }
        return 0;
    }

    private static final void build_null_mode_tables() {
        null_mode_prefix_count = (short)8;
        short s = 0;
        while (s < null_mode_prefix_count) {
            int n = 0;
            while (n < 256) {
                short s2;
                int n2;
                if (s < 8) {
                    n2 = 0;
                    s2 = s;
                } else {
                    n2 = null_mode_prefix[s];
                    s2 = 0;
                }
                short s3 = 0;
                short s4 = s2;
                while (s4 < 8) {
                    n2 = (n & 1 << 7 - s4) != 0 ? G4Tables.append_1(n2) : G4Tables.append_0(n2);
                    s3 = G4Tables.null_mode_type(n2);
                    if (s3 != 0) break;
                    s4 = (short)(s4 + 1);
                }
                G4Tables.null_mode_next_state[s][n] = s3 != 0 ? (byte)(s4 + 1 & 7) : (byte)G4Tables.find_null_mode_prefix(n2);
                G4Tables.null_mode[s][n] = (byte)s3;
                n = (short)(n + 1);
            }
            s = (short)(s + 1);
        }
    }

    private static final void build_horiz_mode_tables() {
        horiz_mode_prefix_count = (short)16;
        short s = 0;
        while (s < horiz_mode_prefix_count) {
            int n = 0;
            while (n < 256) {
                short s2;
                int n2;
                byte by;
                if (s < 8) {
                    by = 0;
                    n2 = 0;
                    s2 = s;
                } else if (s < 16) {
                    by = 1;
                    n2 = 0;
                    s2 = (short)(s - 8);
                } else {
                    by = horiz_mode_color[s];
                    n2 = horiz_mode_prefix[s];
                    s2 = 0;
                }
                int n3 = 0;
                short s3 = s2;
                while (s3 < 8) {
                    int n4 = n2 = (n & 1 << 7 - s3) != 0 ? G4Tables.append_1(n2) : G4Tables.append_0(n2);
                    if (n2 == 786432) {
                        n2 = 720896;
                    }
                    if ((n3 = (int)(by == 0 ? G4Tables.white_run_length(n2) : G4Tables.black_run_length(n2))) != -4) break;
                    s3 = (short)(s3 + 1);
                }
                switch (n3) {
                    case -2: {
                        G4Tables.horiz_mode[s][n] = 1;
                        G4Tables.horiz_mode_next_state[s][n] = (byte)s3;
                        break;
                    }
                    case -1: {
                        G4Tables.horiz_mode[s][n] = 2;
                        G4Tables.horiz_mode_next_state[s][n] = (byte)(s3 + 1 & 7);
                        break;
                    }
                    default: {
                        G4Tables.horiz_mode[s][n] = (byte)(n3 < 64 ? 3 + n3 : 67 + n3 / 64);
                        G4Tables.horiz_mode_next_state[s][n] = (byte)(s3 + 1 & 7);
                        break;
                    }
                    case -4: {
                        G4Tables.horiz_mode[s][n] = 0;
                        G4Tables.horiz_mode_next_state[s][n] = (byte)(G4Tables.find_horiz_mode_prefix(n2, by) + (by == 0 ? 0 : -8));
                        break;
                    }
                }
                n = (short)(n + 1);
            }
            s = (short)(s + 1);
        }
    }

    private static final void convert_null_mode_tables() {
        g4Fax2DFSM = new short[null_mode_prefix_count][256];
        int n = 0;
        while (n < null_mode_prefix_count) {
            int n2 = 0;
            while (n2 < 256) {
                G4Tables.g4Fax2DFSM[n][n2] = (short)(null_mode[n][n2] << 8 | null_mode_next_state[n][n2] & 0xFF);
                ++n2;
            }
            ++n;
        }
    }

    private static final void convert_horiz_mode_tables() {
        g4Fax1DFSM = new short[horiz_mode_prefix_count][256];
        int n = 0;
        while (n < horiz_mode_prefix_count) {
            int n2 = 0;
            while (n2 < 256) {
                G4Tables.g4Fax1DFSM[n][n2] = (short)(horiz_mode[n][n2] << 8 | horiz_mode_next_state[n][n2] & 0xFF);
                ++n2;
            }
            ++n;
        }
    }

    static void init() {
        null_mode = new byte[20][256];
        null_mode_next_state = new byte[20][256];
        null_mode_prefix_count = 0;
        null_mode_prefix = new int[20];
        horiz_mode = new byte[230][256];
        horiz_mode_next_state = new byte[230][256];
        horiz_mode_prefix = new int[230];
        horiz_mode_color = new byte[230];
        horiz_mode_prefix_count = 0;
        hashtab = new short[16384];
        System.out.println("G4tables: null");
        G4Tables.build_null_mode_tables();
        G4Tables.convert_null_mode_tables();
        System.out.println("G4tables: horiz");
        G4Tables.build_horiz_mode_tables();
        G4Tables.convert_horiz_mode_tables();
        System.out.println("G4tables: done");
        null_mode_next_state = null;
        null_mode = null;
        horiz_mode_next_state = null;
        horiz_mode = null;
        null_mode_prefix = null;
        horiz_mode_prefix = null;
        horiz_mode_color = null;
        g4FaxWhiteCodes = null;
        g4FaxBlackCodes = null;
        hashtab = null;
        inited = true;
    }

    static {
        g3whitelen = new byte[]{8, 6, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 5, 5, 6, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 6, 9, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 9, 10, 11, 12};
        g3whitecode = new short[]{53, 7, 7, 8, 11, 12, 14, 15, 19, 20, 7, 8, 8, 3, 52, 53, 42, 43, 39, 12, 8, 23, 3, 4, 40, 43, 19, 36, 24, 2, 3, 26, 27, 18, 19, 20, 21, 22, 23, 40, 41, 42, 43, 44, 45, 4, 5, 10, 11, 82, 83, 84, 85, 36, 37, 88, 89, 90, 91, 74, 75, 50, 51, 52, 27, 18, 23, 55, 54, 55, 100, 101, 104, 103, 204, 205, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 152, 153, 154, 24, 155, 8, 12, 13, 18, 19, 20, 21, 22, 23, 28, 29, 30, 31, 1, 1, 1, 1, 0};
        g3whiterun = new short[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 128, 192, 256, 320, 384, 448, 512, 576, 640, 704, 768, 832, 896, 960, 1024, 1088, 1152, 1216, 1280, 1344, 1408, 1472, 1536, 1600, 1664, 1728, 1792, 1856, 1920, 1984, 2048, 2112, 2176, 2240, 2304, 2368, 2432, 2496, 2560, -1, -2, -2, -2, -2};
        g4FaxWhiteCodes = new G3CodeTable(g3whitelen, g3whitecode, g3whiterun);
        g3blacklen = new byte[]{10, 3, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 7, 8, 8, 9, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 10, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 9, 10, 11, 12};
        g3blackcode = new short[]{55, 2, 3, 2, 3, 3, 2, 3, 5, 4, 4, 5, 7, 4, 7, 24, 23, 24, 8, 103, 104, 108, 55, 40, 23, 24, 202, 203, 204, 205, 104, 105, 106, 107, 210, 211, 212, 213, 214, 215, 108, 109, 218, 219, 84, 85, 86, 87, 100, 101, 82, 83, 36, 55, 56, 39, 40, 88, 89, 43, 44, 90, 102, 103, 15, 200, 201, 91, 51, 52, 53, 108, 109, 74, 75, 76, 77, 114, 115, 116, 117, 118, 119, 82, 83, 84, 85, 90, 91, 100, 101, 8, 12, 13, 18, 19, 20, 21, 22, 23, 28, 29, 30, 31, 1, 1, 1, 1, 0};
        g3blackrun = g3whiterun;
        g4FaxBlackCodes = new G3CodeTable(g3blacklen, g3blackcode, g3blackrun);
    }
}

