/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

class SudokuTimer
extends JDialog
implements ActionListener {
    int time = 0;
    Timer timer = new Timer(1000, this);
    JLabel label = new JLabel("Elapsed time = 00:00:00");
    final JButton startStopButton = new JButton("Start");
    final Dimension startStopButtonSize = this.startStopButton.getPreferredSize();
    final JButton resetButton = new JButton("Reset");
    final JButton closeButton = new JButton("Hide");

    SudokuTimer(JFrame frame) {
        super((Frame)frame, "Timer");
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SudokuTimer.this.dispose();
            }
        });
        this.label.setAlignmentX(0.5f);
        Font timerFont = this.label.getFont();
        this.label.setFont(timerFont.deriveFont(16.0f));
        this.add(this.label);
        JPanel panel = new JPanel(new FlowLayout());
        this.startStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SudokuTimer.this.timer.isRunning()) {
                    SudokuTimer.this.stop();
                } else {
                    SudokuTimer.this.start();
                }
            }
        });
        panel.add(this.startStopButton);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SudokuTimer.this.reset();
            }
        });
        panel.add(this.resetButton);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SudokuTimer.this.setVisible(false);
            }
        });
        panel.add(this.closeButton);
        this.add(panel);
        this.setLocation(500, 200);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ++this.time;
        this.displayTime();
    }

    void start() {
        this.startStopButton.setText("Stop");
        this.startStopButton.setPreferredSize(this.startStopButtonSize);
        this.resetButton.setEnabled(false);
        this.timer.start();
    }

    void stop() {
        this.timer.stop();
        this.startStopButton.setText("Start");
        this.resetButton.setEnabled(true);
    }

    void reset() {
        this.stop();
        this.time = 0;
        this.displayTime();
    }

    void displayTime() {
        int t = this.time;
        int hours = t / 3600;
        int minutes = t % 3600 / 60;
        int seconds = t % 60;
        StringBuilder sb = new StringBuilder("Elapsed time = ");
        if (hours < 10) {
            sb.append("0");
        }
        sb.append(String.valueOf(hours) + ":");
        if (minutes < 10) {
            sb.append("0");
        }
        sb.append(String.valueOf(minutes) + ":");
        if (seconds < 10) {
            sb.append("0");
        }
        sb.append(seconds);
        this.label.setText(sb.toString());
    }
}

