/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.UIManager;
import sudoku.Board;
import sudoku.BoundedStack;
import sudoku.Cell;
import sudoku.Difficulty;
import sudoku.GUI;
import sudoku.Generate;
import sudoku.Heuristic;
import sudoku.InconsistencyException;
import sudoku.Solve;

class Sudoku {
    GUI gui;
    Board board = new Board();
    BoundedStack<Board> undoStack = new BoundedStack(100);
    Board resetValue = this.board.clone();
    static final int CURRENT_VERSION = 2007123022;
    static final int PREVIOUS_VERSION_0 = 2006022719;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Sudoku();
    }

    Sudoku() {
        this.gui = new GUI(this);
    }

    void create(Difficulty d) {
        Board c = Generate.generate(d);
        if (c == null) {
            this.gui.message("Unable to generate puzzle after 1000 trials");
            return;
        }
        this.undoStack.push(this.board);
        this.board = c;
        this.eraseAnnotations(false);
        this.resetValue = this.board.clone();
    }

    void clear() {
        this.undoStack.push(this.board.clone());
        int x = 0;
        while (x < 9) {
            int y = 0;
            while (y < 9) {
                this.board.cell((int)x, (int)y).possible = 0;
                this.board.cell((int)x, (int)y).committed = false;
                ++y;
            }
            ++x;
        }
    }

    Cell[] hint() {
        block7: {
            Cell[] d;
            Board c = this.board.clone();
            try {
                Sudoku.annotate(c);
            }
            catch (InconsistencyException ie) {
                this.gui.message("No solutions");
                return null;
            }
            for (Heuristic h : Heuristic.heuristics) {
                if ((h.tag & 7) == 0 || (d = h.hint(c)) == null) continue;
                return d;
            }
            try {
                if (Solve.solve(this.board) == null) break block7;
                for (Heuristic h : Heuristic.heuristics) {
                    d = h.hint(this.board);
                    if (d == null) continue;
                    return d;
                }
                this.gui.message("No hints available");
                return null;
            }
            catch (InconsistencyException ie) {
                this.gui.message("No hints available");
                return null;
            }
        }
        this.gui.message("Multiple solutions");
        return null;
    }

    void checkConsistency() {
        Board c = this.board.clone();
        try {
            Sudoku.annotate(c);
            if (Solve.solve(c) != null) {
                this.gui.message("Unique solution");
            } else {
                this.gui.message("Multiple solutions");
            }
        }
        catch (InconsistencyException ie) {
            this.gui.message("No solutions");
        }
    }

    void checkConsistencyWithAnnotations() {
        try {
            if (Solve.solve(this.board) != null) {
                this.gui.message("Unique solution");
            } else {
                this.gui.message("Multiple solutions");
            }
        }
        catch (InconsistencyException ie) {
            this.gui.message("No solutions with this annotation");
        }
    }

    void print() {
        int PRINT_MARGIN = 80;
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
                if (pageIndex > 0) {
                    return 1;
                }
                Sudoku.this.gui.display.drawGrid(graphics, 80);
                return 0;
            }
        });
        HashPrintRequestAttributeSet printAttributes = new HashPrintRequestAttributeSet();
        if (pj.printDialog(printAttributes)) {
            try {
                pj.print(printAttributes);
            }
            catch (PrinterException pe) {
                this.gui.message("Cannot print: " + pe.getMessage());
            }
        }
    }

    void solve() {
        Board solution = this.board.clone();
        try {
            Sudoku.annotate(solution);
            solution = Solve.solve(solution);
            if (solution == null) {
                this.gui.message("Multiple solutions");
                return;
            }
        }
        catch (InconsistencyException ie) {
            this.gui.message("No solution");
            return;
        }
        this.undoStack.push(this.board);
        this.board = solution;
        int y = 0;
        while (y < 9) {
            int x = 0;
            while (x < 9) {
                this.board.cell((int)x, (int)y).committed = true;
                ++x;
            }
            ++y;
        }
    }

    void applySelectedHeuristics(int tags) {
        this.gui.clearMessage();
        this.undoStack.push(this.board.clone());
        if (!Heuristic.apply(this.board, tags)) {
            this.gui.message("No change");
            this.board = this.undoStack.pop();
        } else {
            this.gui.undoItem.setEnabled(true);
        }
    }

    void reset() {
        this.board = this.resetValue.clone();
        this.undoStack.clear();
    }

    void setCheckpoint() {
        this.undoStack.push(this.board.clone());
        this.undoStack.push(null);
    }

    void rollBack() {
        if (!this.undoStack.rollBack()) {
            this.gui.message("No checkpoint set");
            return;
        }
        if (this.undoStack.isEmpty()) {
            this.reset();
        } else {
            this.board = this.undoStack.pop();
        }
    }

    void eraseAnnotations(boolean save) {
        if (save) {
            this.undoStack.push(this.board.clone());
        }
        int y = 0;
        while (y < 9) {
            int x = 0;
            while (x < 9) {
                if (!this.board.cell((int)x, (int)y).committed) {
                    this.board.cell((int)x, (int)y).possible = 0;
                }
                ++x;
            }
            ++y;
        }
    }

    void annotate() throws InconsistencyException {
        Board c = this.board.clone();
        Sudoku.annotate(this.board);
        this.undoStack.push(c);
    }

    static void annotate(Board cells) throws InconsistencyException {
        int y = 0;
        while (y < 9) {
            int x = 0;
            while (x < 9) {
                int c = 0;
                int z = 0;
                while (z < 9) {
                    if (z != x && cells.cell((int)z, (int)y).committed) {
                        c |= cells.cell((int)z, (int)y).possible;
                    }
                    if (z != y && cells.cell((int)x, (int)z).committed) {
                        c |= cells.cell((int)x, (int)z).possible;
                    }
                    int a = x / 3 * 3 + z / 3;
                    int b = y / 3 * 3 + z % 3;
                    if ((a != x || b != y) && cells.cell((int)a, (int)b).committed) {
                        c |= cells.cell((int)a, (int)b).possible;
                    }
                    ++z;
                }
                int p = (cells.cell((int)x, (int)y).committed ? cells.cell((int)x, (int)y).possible : 511) & ~c;
                if (p == 0) {
                    throw new InconsistencyException();
                }
                cells.cell((int)x, (int)y).possible = p;
                ++x;
            }
            ++y;
        }
    }

    void write(PrintStream out) {
        out.println(2007123022);
        StringBuilder s = new StringBuilder();
        int y = 0;
        while (y < 9) {
            int x = 0;
            while (x < 9) {
                s.append(this.board.cell((int)x, (int)y).possible << 1 | (this.board.cell((int)x, (int)y).committed ? 1 : 0));
                if (x < 8) {
                    s.append(" ");
                }
                ++x;
            }
            out.println(s.toString());
            s.setLength(0);
            ++y;
        }
        out.flush();
        out.close();
    }

    boolean read(File inFile) {
        this.undoStack.push(this.board);
        this.board = new Board();
        Scanner sc = null;
        boolean status = false;
        try {
            sc = new Scanner(inFile);
            int next = sc.nextInt();
            switch (next) {
                case 2006022719: 
                case 2007123022: {
                    int y = 0;
                    while (y < 9) {
                        int x = 0;
                        while (x < 9) {
                            next = sc.nextInt();
                            this.board.cell((int)x, (int)y).committed = (next & 1) != 0;
                            this.board.cell((int)x, (int)y).possible = next >> 1;
                            if (this.board.cell((int)x, (int)y).possible >= 512) {
                                throw new Exception("wrong format");
                            }
                            ++x;
                        }
                        ++y;
                    }
                    break;
                }
                default: {
                    int y = 0;
                    while (y < 9) {
                        int x = 8;
                        while (x >= 0) {
                            this.board.cell((int)x, (int)y).possible = next % 10 > 0 ? 1 << next % 10 - 1 : 0;
                            this.board.cell((int)x, (int)y).committed = this.board.cell((int)x, (int)y).possible > 0;
                            next /= 10;
                            --x;
                        }
                        if (next != 0) {
                            throw new Exception("too many columns");
                        }
                        if (y < 8) {
                            next = sc.nextInt();
                        }
                        ++y;
                    }
                    break block1;
                }
            }
            if (sc.hasNext()) {
                throw new Exception("too many rows");
            }
            status = true;
        }
        catch (FileNotFoundException e) {
            this.gui.message("File " + inFile.getAbsolutePath() + " not found");
        }
        catch (InputMismatchException e) {
            this.gui.message("Corrupt Sudoku file " + inFile.getAbsolutePath() + ": wrong format");
        }
        catch (NoSuchElementException e) {
            this.gui.message("Corrupt Sudoku file " + inFile.getAbsolutePath() + ": too few rows");
        }
        catch (Exception e) {
            String msg = "Corrupt Sudoku file " + inFile.getAbsolutePath() + (e.getMessage() == null ? "" : ": " + e.getMessage());
            this.gui.message(msg);
        }
        if (sc != null) {
            sc.close();
        }
        if (status) {
            this.resetValue = this.board.clone();
            this.undoStack.clear();
        } else {
            this.board = this.undoStack.pop();
        }
        return status;
    }
}

