/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import sudoku.Board;
import sudoku.Cell;
import sudoku.Heuristic;
import sudoku.InconsistencyException;

public class Solve {
    static Board solve(Board cells) throws InconsistencyException {
        Board c = cells.clone();
        Heuristic.apply(c, 127);
        Cell indet = Solve.allDetermined(c);
        if (indet == null) {
            return c;
        }
        Board d = null;
        int possible = indet.possible;
        int b = 1;
        while (b < 512) {
            block7: {
                if ((b & possible) != 0) {
                    indet.possible = b;
                    try {
                        Board e = Solve.solve(c);
                        if (e != null && d == null) {
                            d = e;
                            break block7;
                        }
                        return null;
                    }
                    catch (InconsistencyException inconsistencyException) {
                        // empty catch block
                    }
                }
            }
            b <<= 1;
        }
        if (d == null) {
            throw new InconsistencyException();
        }
        return d;
    }

    static Cell allDetermined(Board cells) throws InconsistencyException {
        int x = 0;
        while (x < 9) {
            int y = 0;
            while (y < 9) {
                if (cells.cell((int)x, (int)y).possible == 0) {
                    throw new InconsistencyException();
                }
                if (!cells.cell(x, y).determined()) {
                    return cells.cell(x, y);
                }
                ++y;
            }
            ++x;
        }
        return null;
    }

    static boolean isSolution(Board cells) throws InconsistencyException {
        int y;
        int x = 0;
        while (x < 9) {
            y = 0;
            while (y < 9) {
                if (!cells.cell((int)x, (int)y).committed) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 9) {
            y = 0;
            while (y < 9) {
                if (Cell.number(cells.cell((int)x, (int)y).possible) != 1) {
                    throw new InconsistencyException();
                }
                int z = 0;
                while (z < 9) {
                    if (z != x && cells.cell((int)z, (int)y).possible == cells.cell((int)x, (int)y).possible) {
                        throw new InconsistencyException();
                    }
                    if (z != y && cells.cell((int)x, (int)z).possible == cells.cell((int)x, (int)y).possible) {
                        throw new InconsistencyException();
                    }
                    int a = x / 3 * 3 + z / 3;
                    int b = y / 3 * 3 + z % 3;
                    if ((a != x || b != y) && cells.cell((int)a, (int)b).possible == cells.cell((int)x, (int)y).possible) {
                        throw new InconsistencyException();
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    static void commit(Board cells, Cell c) {
        if (!c.determined()) {
            throw new Error("Cell value not determined");
        }
        c.committed = true;
        int d = ~c.possible;
        int z = 0;
        while (z < 9) {
            if (z != c.x && !cells.cell((int)z, (int)c.y).committed) {
                cells.cell((int)z, (int)c.y).possible &= d;
            }
            if (z != c.y && !cells.cell((int)c.x, (int)z).committed) {
                cells.cell((int)c.x, (int)z).possible &= d;
            }
            int a = c.x / 3 * 3 + z / 3;
            int b = c.y / 3 * 3 + z % 3;
            if (!(a == c.x && b == c.y || cells.cell((int)a, (int)b).committed)) {
                cells.cell((int)a, (int)b).possible &= d;
            }
            ++z;
        }
    }
}

