/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import sudoku.Board;
import sudoku.Cell;
import sudoku.Heuristic;
import sudoku.Solve;

class HiddenRowSingles
extends Heuristic {
    HiddenRowSingles() {
        super("Hidden Row & Column Singles");
        this.tag = 4;
        this.toolTip = "Some number occurs in only one cell in a row or column";
    }

    @Override
    Cell[] find(Board cells, boolean change) {
        int x = 0;
        while (x < 9) {
            int y = 0;
            while (y < 9) {
                if (!cells.cell((int)x, (int)y).committed) {
                    int row;
                    int col = row = cells.cell((int)x, (int)y).possible;
                    int z = 0;
                    while (z < 9) {
                        if (z != x) {
                            row &= ~cells.cell((int)z, (int)y).possible;
                        }
                        if (z != y) {
                            col &= ~cells.cell((int)x, (int)z).possible;
                        }
                        ++z;
                    }
                    int single = Cell.number(row) == 1 ? row : 0;
                    if (Cell.number(single |= Cell.number(col) == 1 ? col : 0) == 1) {
                        Cell[] c = new Cell[]{cells.cell(x, y)};
                        if (change) {
                            cells.cell((int)x, (int)y).possible = single;
                            Solve.commit(cells, cells.cell(x, y));
                        }
                        return c;
                    }
                }
                ++y;
            }
            ++x;
        }
        return null;
    }
}

