/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.HashSet;
import sudoku.Board;
import sudoku.Cell;
import sudoku.Heuristic;

class HiddenRowDoubles
extends Heuristic {
    HiddenRowDoubles() {
        super("Hidden Row & Column Doubles");
        this.tag = 32;
        this.toolTip = "Some two numbers occur in only two cells in a row or column";
    }

    @Override
    Cell[] find(Board cells, boolean change) {
        int y;
        Cell[] p = null;
        HashSet<Cell> doubles = new HashSet<Cell>();
        int x = 0;
        while (x < 9) {
            y = 0;
            while (y < 9) {
                if (Cell.number(cells.cell((int)x, (int)y).possible) >= 2) {
                    doubles.add(cells.cell(x, y));
                }
                ++y;
            }
            ++x;
        }
        for (Cell c : doubles) {
            for (Cell d : doubles) {
                int b;
                int a;
                if (c.equals(d) || Cell.number(a = c.possible & d.possible) < 2) continue;
                if (c.y == d.y) {
                    b = a;
                    x = 0;
                    while (x < 9) {
                        if (x != c.x && x != d.x) {
                            b &= ~cells.cell((int)x, (int)c.y).possible;
                        }
                        ++x;
                    }
                    if (Cell.number(b) != 2) continue;
                    if (b != c.possible || b != d.possible) {
                        p = new Cell[]{c, d};
                        if (change) {
                            c.possible = b;
                            d.possible = b;
                        }
                        return p;
                    }
                }
                if (c.x != d.x) continue;
                b = a;
                y = 0;
                while (y < 9) {
                    if (y != c.y && y != d.y) {
                        b &= ~cells.cell((int)c.x, (int)y).possible;
                    }
                    ++y;
                }
                if (Cell.number(b) != 2 || b == c.possible && b == d.possible) continue;
                p = new Cell[]{c, d};
                if (change) {
                    c.possible = b;
                    d.possible = b;
                }
                return p;
            }
        }
        return null;
    }
}

