/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import sudoku.Board;
import sudoku.Cell;
import sudoku.Heuristic;
import sudoku.Solve;

class HiddenBoxSingles
extends Heuristic {
    HiddenBoxSingles() {
        super("Hidden Box Singles");
        this.tag = 2;
        this.toolTip = "Some number occurs in only one cell in the box";
    }

    @Override
    Cell[] find(Board cells, boolean change) {
        int x = 0;
        while (x < 9) {
            int y = 0;
            while (y < 9) {
                if (!cells.cell((int)x, (int)y).committed) {
                    int single;
                    int box = cells.cell((int)x, (int)y).possible;
                    int z = 0;
                    while (z < 9) {
                        int a = x / 3 * 3 + z / 3;
                        int b = y / 3 * 3 + z % 3;
                        if (a != x || b != y) {
                            box &= ~cells.cell((int)a, (int)b).possible;
                        }
                        ++z;
                    }
                    int n = single = Cell.number(box) == 1 ? box : 0;
                    if (Cell.number(single) == 1) {
                        Cell[] c = new Cell[]{cells.cell(x, y)};
                        if (change) {
                            cells.cell((int)x, (int)y).possible = single;
                            Solve.commit(cells, cells.cell(x, y));
                        }
                        return c;
                    }
                }
                ++y;
            }
            ++x;
        }
        return null;
    }
}

