/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.HashSet;
import sudoku.Board;
import sudoku.Cell;
import sudoku.Heuristic;

class HiddenBoxDoubles
extends Heuristic {
    HiddenBoxDoubles() {
        super("Hidden Box Doubles");
        this.tag = 16;
        this.toolTip = "Some two numbers occur in only two cells in a box";
    }

    @Override
    Cell[] find(Board cells, boolean change) {
        Cell[] p = null;
        HashSet<Cell> doubles = new HashSet<Cell>();
        int x = 0;
        while (x < 9) {
            int y = 0;
            while (y < 9) {
                if (Cell.number(cells.cell((int)x, (int)y).possible) >= 2) {
                    doubles.add(cells.cell(x, y));
                }
                ++y;
            }
            ++x;
        }
        for (Cell c : doubles) {
            for (Cell d : doubles) {
                int a;
                if (c.equals(d) || Cell.number(a = c.possible & d.possible) < 2 || c.x / 3 != d.x / 3 || c.y / 3 != d.y / 3) continue;
                int b = a;
                int z = 0;
                while (z < 9) {
                    int i = c.x / 3 * 3 + z / 3;
                    int j = c.y / 3 * 3 + z % 3;
                    if (!(i == c.x && j == c.y || i == d.x && j == d.y)) {
                        b &= ~cells.cell((int)i, (int)j).possible;
                    }
                    ++z;
                }
                if (Cell.number(b) != 2 || b == c.possible && b == d.possible) continue;
                p = new Cell[]{c, d};
                if (change) {
                    c.possible = b;
                    d.possible = b;
                }
                return p;
            }
        }
        return null;
    }
}

