/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.Vector;
import sudoku.Board;
import sudoku.Cell;
import sudoku.ExposedDoubles;
import sudoku.ExposedSingles;
import sudoku.HiddenBoxDoubles;
import sudoku.HiddenBoxSingles;
import sudoku.HiddenRowDoubles;
import sudoku.HiddenRowSingles;
import sudoku.Lines;

abstract class Heuristic {
    static final int EXPOSED_SINGLES = 1;
    static final int HIDDEN_BOX_SINGLES = 2;
    static final int HIDDEN_ROW_SINGLES = 4;
    static final int EXPOSED_DOUBLES = 8;
    static final int HIDDEN_BOX_DOUBLES = 16;
    static final int HIDDEN_ROW_DOUBLES = 32;
    static final int LINES = 64;
    static final int BRUTE_FORCE = 128;
    static final int ALL = 127;
    static final int SINGLES = 7;
    String name;
    String toolTip;
    int tag;
    static Vector<Heuristic> heuristics = new Vector();

    static {
        new HiddenBoxSingles();
        new ExposedSingles();
        new HiddenBoxDoubles();
        new Lines();
        new ExposedDoubles();
        new HiddenRowSingles();
        new HiddenRowDoubles();
    }

    abstract Cell[] find(Board var1, boolean var2);

    Heuristic(String name) {
        this.name = name;
        heuristics.add(this);
    }

    static boolean apply(Board cells, int tags) {
        boolean everChange = false;
        boolean outerChange = true;
        int i = 0;
        while (outerChange) {
            outerChange = false;
            for (Heuristic h : heuristics) {
                if ((tags & h.tag) == 0) continue;
                boolean innerChange = true;
                while (innerChange) {
                    innerChange = h.check(cells);
                    outerChange |= innerChange;
                    everChange |= innerChange;
                }
            }
            if (i++ != 100000) continue;
            throw new Error("Errant loop");
        }
        return everChange;
    }

    boolean check(Board cells) {
        return this.find(cells, true) != null;
    }

    Cell[] hint(Board cells) {
        return this.find(cells, false);
    }
}

