/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.Random;
import sudoku.Board;
import sudoku.Cell;
import sudoku.Difficulty;
import sudoku.Heuristic;
import sudoku.InconsistencyException;
import sudoku.Solve;
import sudoku.Sudoku;

public class Generate {
    static final int UNUSED = -1;
    static final int TRIED = -2;
    static int[][] grid = new int[9][9];
    static boolean[] colAvailable = new boolean[9];
    static boolean[] boxAvailable = new boolean[9];
    static final Random rand = new Random();

    static Board generate(Difficulty d) {
        Board last = null;
        int count = 0;
        while (last == null) {
            if (count++ >= 1000) {
                return null;
            }
            int[] perm = new int[81];
            int i = 80;
            while (i > 0) {
                int j = rand.nextInt(i + 1);
                int temp = perm[i] == 0 ? i : perm[i];
                perm[i] = perm[j] == 0 ? j : perm[j];
                perm[j] = temp;
                --i;
            }
            Cell[][] newGrid = new Cell[9][9];
            while (!Generate.fullGrid()) {
            }
            int i2 = 0;
            while (i2 < 9) {
                int j = 0;
                while (j < 9) {
                    newGrid[i2][j] = new Cell(i2, j);
                    newGrid[i2][j].commit(grid[i2][j]);
                    ++j;
                }
                ++i2;
            }
            Board c = new Board(newGrid);
            last = c.clone();
            int i3 = 0;
            while (i3 < 81) {
                int x = perm[i3] / 9;
                int y = perm[i3] % 9;
                if (c.cell((int)x, (int)y).committed) {
                    c.cell((int)x, (int)y).committed = false;
                    c.cell((int)(8 - x), (int)(8 - y)).committed = false;
                    Board e = c.clone();
                    try {
                        Sudoku.annotate(e);
                        Heuristic.apply(e, d.solvedBy);
                        if (Solve.allDetermined(e) == null) {
                            last = c.clone();
                        } else {
                            c = last.clone();
                        }
                    }
                    catch (InconsistencyException ie) {
                        throw new Error("Inconsistency detected");
                    }
                }
                ++i3;
            }
            c = last.clone();
            try {
                Sudoku.annotate(c);
                Heuristic.apply(c, d.notSolvedBy);
                if (Solve.allDetermined(c) != null) continue;
                last = null;
            }
            catch (InconsistencyException ie) {
                throw new Error("Inconsistency detected");
            }
        }
        return last;
    }

    /*
     * Unable to fully structure code
     */
    static boolean fullGrid() {
        y = 0;
        while (y < 9) {
            Generate.colAvailable[y] = true;
            Generate.boxAvailable[y] = true;
            x = 0;
            while (x < 9) {
                Generate.grid[x][y] = -1;
                ++x;
            }
            ++y;
        }
        k = 0;
        while (k < 9) {
            y = 0;
            ** GOTO lbl49
            {
                if (y == 0) {
                    return false;
                }
                x = 0;
                while (x < 9) {
                    if (Generate.grid[x][y] == -2) {
                        Generate.grid[x][y] = -1;
                    }
                    ++x;
                }
                --y;
                x = 0;
                while (x < 9) {
                    if (Generate.grid[x][y] == k) break;
                    ++x;
                }
                if (x == 9) {
                    throw new Error("Could not find k");
                }
                Generate.grid[x][y] = -2;
                Generate.colAvailable[x] = true;
                Generate.boxAvailable[Generate.box((int)x, (int)y)] = true;
                do {
                    if (Generate.availableCols(y) == 0) continue block3;
                    z = Generate.rand.nextInt(Generate.availableCols(y));
                    x = 0;
                    while (x < 9) {
                        if (Generate.available(x, y) && z-- == 0) break;
                        ++x;
                    }
                    if (x == 9) {
                        throw new Error("Could not find empty slot");
                    }
                    Generate.grid[x][y] = k;
                    Generate.colAvailable[x] = false;
                    Generate.boxAvailable[Generate.box((int)x, (int)y)] = false;
                    ++y;
lbl49:
                    // 2 sources

                } while (y < 9);
            }
            y = 0;
            while (y < 9) {
                Generate.colAvailable[y] = true;
                Generate.boxAvailable[y] = true;
                x = 0;
                while (x < 9) {
                    if (Generate.grid[x][y] == -2) {
                        Generate.grid[x][y] = -1;
                    }
                    ++x;
                }
                ++y;
            }
            ++k;
        }
        row = new int[9][9];
        col = new int[9][9];
        box = new int[9][9];
        k = 0;
        while (k < 9) {
            y = 0;
            while (y < 9) {
                x = 0;
                while (x < 9) {
                    if (Generate.grid[x][y] == k) {
                        v0 = col[x];
                        v1 = k;
                        v0[v1] = v0[v1] + 1;
                        v2 = row[y];
                        v3 = k;
                        v2[v3] = v2[v3] + 1;
                        v4 = box[Generate.box(x, y)];
                        v5 = k;
                        v4[v5] = v4[v5] + 1;
                    }
                    ++x;
                }
                ++y;
            }
            ++k;
        }
        k = 0;
        while (k < 9) {
            x = 0;
            while (x < 9) {
                if (row[x][k] != 1) {
                    throw new Error("Improper row");
                }
                if (col[x][k] != 1) {
                    throw new Error("Improper column");
                }
                if (box[x][k] != 1) {
                    throw new Error("Improper box");
                }
                ++x;
            }
            ++k;
        }
        return true;
    }

    static int availableCols(int y) {
        int s = 0;
        int x = 0;
        while (x < 9) {
            if (Generate.available(x, y)) {
                ++s;
            }
            ++x;
        }
        return s;
    }

    static boolean available(int x, int y) {
        return grid[x][y] == -1 && colAvailable[x] && boxAvailable[Generate.box(x, y)];
    }

    static int box(int x, int y) {
        return x / 3 * 3 + y / 3;
    }
}

