/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JWindow;
import javax.swing.Timer;
import sudoku.Board;
import sudoku.Cell;
import sudoku.Difficulty;
import sudoku.Heuristic;
import sudoku.InconsistencyException;
import sudoku.Solve;
import sudoku.Sudoku;
import sudoku.SudokuFileFilter;
import sudoku.SudokuTimer;

public class GUI {
    final JFrame frame = new JFrame("CS211 Sudoku");
    final JLabel messageArea;
    final DisplayCell[][] cells = new DisplayCell[9][9];
    final JCheckBox[] heuristics = new JCheckBox[Heuristic.heuristics.size()];
    final SudokuTimer timer = new SudokuTimer(this.frame);
    final JFileChooser fileChooser = new JFileChooser();
    final JMenu fileMenu = new JMenu("File");
    final JMenuItem saveItem = new JMenuItem("Save");
    final JMenuItem saveAsItem = new JMenuItem("Save As...");
    final JMenuItem undoItem = new JMenuItem("Undo");
    final JCheckBoxMenuItem checkConsistency = new JCheckBoxMenuItem("Always Check Consistency");
    final JCheckBoxMenuItem showCompleted = new JCheckBoxMenuItem("Show Completed Digits");
    final Sudoku client;
    final Display display;
    ButtonGroup difficultyGroup;
    boolean showAllAnnotations = true;
    BufferedImage logo = null;
    int[] pixels;
    int[] gradients;

    GUI(final Sudoku client) {
        this.client = client;
        this.display = new Display();
        this.frame.setDefaultCloseOperation(3);
        JMenuBar menuBar = new JMenuBar();
        this.fileChooser.addChoosableFileFilter(new SudokuFileFilter("Text files", "txt"));
        this.fileChooser.addChoosableFileFilter(new SudokuFileFilter("Sudoku files", "sdk"));
        JMenuItem item = new JMenuItem("New");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Difficulty d = Difficulty.valueOf(GUI.this.difficultyGroup.getSelection().getActionCommand());
                GUI.this.message("Creating " + d.toString().toLowerCase() + " puzzle, please wait");
                client.create(d);
                GUI.this.saveItem.setEnabled(false);
                GUI.this.undoItem.setEnabled(true);
                GUI.this.display.repaint();
                GUI.this.clearMessage();
                if (GUI.this.checkConsistency.isSelected()) {
                    client.checkConsistency();
                }
                GUI.this.timer.reset();
                GUI.this.timer.start();
            }
        });
        item.setToolTipText("Creates a new puzzle of specified difficulty");
        this.fileMenu.add(item);
        item = new JMenuItem("Open");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ok = GUI.this.fileChooser.showOpenDialog(GUI.this.frame);
                if (ok != 0) {
                    return;
                }
                File file = GUI.this.fileChooser.getSelectedFile();
                if (!client.read(file)) {
                    return;
                }
                GUI.this.saveItem.setEnabled(true);
                GUI.this.undoItem.setEnabled(false);
                GUI.this.display.repaint();
                GUI.this.message("Sudoku file " + file.getAbsolutePath() + " successfully read");
                if (GUI.this.checkConsistency.isSelected()) {
                    client.checkConsistency();
                }
                GUI.this.timer.reset();
                GUI.this.timer.start();
            }
        });
        this.fileMenu.add(item);
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.clearMessage();
                PrintStream out = null;
                File file = GUI.this.fileChooser.getSelectedFile();
                if (file == null || !file.exists()) {
                    GUI.this.saveAsItem.getActionListeners()[0].actionPerformed(e);
                    return;
                }
                try {
                    out = new PrintStream(file);
                }
                catch (FileNotFoundException exc) {
                    GUI.this.message("Cannot write file " + file.getAbsolutePath());
                    if (out != null) {
                        out.close();
                    }
                    return;
                }
                client.write(out);
                GUI.this.message("Sudoku file " + file.getAbsolutePath() + " successfully written");
            }
        });
        this.saveItem.setEnabled(false);
        this.fileMenu.add(this.saveItem);
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg;
                GUI.this.clearMessage();
                PrintStream out = null;
                int ok = GUI.this.fileChooser.showSaveDialog(GUI.this.frame);
                if (ok != 0) {
                    return;
                }
                File file = GUI.this.fileChooser.getSelectedFile();
                if (file.getAbsolutePath().lastIndexOf(".") < 0) {
                    String ext = ((SudokuFileFilter)GUI.this.fileChooser.getFileFilter()).extension;
                    file = new File(String.valueOf(file.getAbsolutePath()) + "." + ext);
                }
                if (file.exists() && (ok = JOptionPane.showConfirmDialog(GUI.this.frame, msg = "File " + file.getAbsolutePath() + " exists; overwrite?", "", 0)) != 0) {
                    return;
                }
                try {
                    out = new PrintStream(file);
                }
                catch (FileNotFoundException exc) {
                    GUI.this.message("Cannot write file " + file.getAbsolutePath());
                    if (out != null) {
                        out.close();
                    }
                    return;
                }
                client.write(out);
                GUI.this.message("Sudoku file " + file.getAbsolutePath() + " successfully written");
                GUI.this.saveItem.setEnabled(true);
            }
        });
        this.saveAsItem.setEnabled(true);
        this.fileMenu.add(this.saveAsItem);
        item = new JMenuItem("Print...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                client.print();
            }
        });
        item.setEnabled(true);
        this.fileMenu.add(item);
        this.fileMenu.addSeparator();
        item = new JMenuItem("Quit");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.fileMenu.add(item);
        menuBar.add(this.fileMenu);
        JMenu actionMenu = new JMenu("Action");
        this.undoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (client.undoStack.isEmpty()) {
                    throw new Error("Empty undo stack");
                }
                client.board = client.undoStack.pop();
                if (client.undoStack.isEmpty()) {
                    GUI.this.undoItem.setEnabled(false);
                }
                GUI.this.display.repaint();
                GUI.this.clearMessage();
                if (GUI.this.checkConsistency.isSelected()) {
                    client.checkConsistency();
                }
            }
        });
        this.undoItem.setEnabled(false);
        actionMenu.add(this.undoItem);
        item = new JMenuItem("Hint");
        final Timer hintTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.display.hint = null;
                GUI.this.display.repaint();
            }
        });
        hintTimer.setRepeats(false);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cell[] hint = client.hint();
                if (hint == null) {
                    return;
                }
                GUI.this.display.hint = hint;
                GUI.this.display.repaint();
                hintTimer.start();
            }
        });
        item.setToolTipText("Shows location where a heuristic would succeed");
        item.setEnabled(true);
        actionMenu.add(item);
        item = new JMenuItem("Solve");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                client.solve();
                GUI.this.undoItem.setEnabled(true);
                GUI.this.display.repaint();
            }
        });
        item.setEnabled(true);
        actionMenu.add(item);
        item = new JMenuItem("Reset");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                client.reset();
                GUI.this.undoItem.setEnabled(false);
                GUI.this.display.repaint();
                GUI.this.clearMessage();
                if (GUI.this.checkConsistency.isSelected()) {
                    client.checkConsistency();
                }
            }
        });
        item.setEnabled(true);
        actionMenu.add(item);
        item = new JMenuItem("Clear");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                client.clear();
                GUI.this.saveItem.setEnabled(false);
                GUI.this.undoItem.setEnabled(true);
                GUI.this.display.repaint();
                GUI.this.clearMessage();
                if (GUI.this.checkConsistency.isSelected()) {
                    client.checkConsistency();
                }
                GUI.this.timer.start();
            }
        });
        item.setToolTipText("Erases everything");
        actionMenu.add(item);
        actionMenu.addSeparator();
        item = new JMenuItem("Set Checkpoint");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                client.setCheckpoint();
                GUI.this.message("Checkpoint set");
            }
        });
        item.setToolTipText("Roll back will roll back to here");
        actionMenu.add(item);
        item = new JMenuItem("Roll back");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.clearMessage();
                client.rollBack();
                if (client.undoStack.isEmpty()) {
                    GUI.this.undoItem.setEnabled(false);
                }
                GUI.this.display.repaint();
            }
        });
        item.setToolTipText("Roll back to last checkpoint");
        actionMenu.add(item);
        actionMenu.addSeparator();
        item = new JMenuItem("Check Consistency");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                client.checkConsistency();
            }
        });
        item.setToolTipText("Checks for unique solution, ignoring current annotations");
        item.setEnabled(true);
        actionMenu.add(item);
        menuBar.add(actionMenu);
        JMenu heuristicsMenu = new JMenu("Heuristics");
        item = new JMenu("Apply Heuristic");
        for (Heuristic h : Heuristic.heuristics) {
            JMenuItem hMenuItem = new JMenuItem(h.name);
            hMenuItem.addActionListener(new HeuristicListener(h));
            hMenuItem.setToolTipText(h.toolTip);
            item.add(hMenuItem);
        }
        item.setToolTipText("Applies chosen heuristic once");
        item.setEnabled(true);
        heuristicsMenu.add(item);
        item = new JMenuItem("Apply Selected Heuristics");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int tags = 0;
                int i = 0;
                while (i < GUI.this.heuristics.length) {
                    if (GUI.this.heuristics[i].isSelected()) {
                        tags |= Heuristic.heuristics.elementAt((int)i).tag;
                    }
                    ++i;
                }
                client.applySelectedHeuristics(tags);
                GUI.this.display.repaint();
            }
        });
        item.setToolTipText("Applies selected heuristics repeatedly until no more changes");
        item.setEnabled(true);
        heuristicsMenu.add(item);
        int i = 0;
        for (Heuristic h : Heuristic.heuristics) {
            this.heuristics[i] = new JCheckBox(h.name);
            this.heuristics[i].setToolTipText(h.toolTip);
            this.heuristics[i++].setSelected(true);
        }
        item = new JMenuItem("Select Heuristics...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showConfirmDialog(GUI.this.frame, GUI.this.heuristics, "Select Heuristics", -1);
            }
        });
        item.setEnabled(true);
        heuristicsMenu.add(item);
        menuBar.add(heuristicsMenu);
        JMenu annotationsMenu = new JMenu("Annotations");
        item = new JMenuItem("Annotate");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    client.annotate();
                    GUI.this.undoItem.setEnabled(true);
                    GUI.this.display.repaint();
                }
                catch (InconsistencyException ie) {
                    GUI.this.message("Inconsistency detected");
                }
            }
        });
        item.setToolTipText("Calculate and display all possibilities not immediately eliminated by committed cells");
        annotationsMenu.add(item);
        item = new JMenuItem("Erase Annotations");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                client.eraseAnnotations(true);
                GUI.this.undoItem.setEnabled(true);
                GUI.this.display.repaint();
            }
        });
        annotationsMenu.add(item);
        item = new JMenuItem("Check Consistency");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                client.checkConsistencyWithAnnotations();
            }
        });
        item.setToolTipText("Checks for unique solution with current annotations");
        item.setEnabled(true);
        annotationsMenu.add(item);
        final JMenuItem showAnnotationsMenuItem = new JMenuItem("Hide Annotations");
        showAnnotationsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (showAnnotationsMenuItem.getText().equals("Show Annotations")) {
                    showAnnotationsMenuItem.setText("Hide Annotations");
                    GUI.this.showAllAnnotations = true;
                    GUI.this.display.repaint();
                } else {
                    showAnnotationsMenuItem.setText("Show Annotations");
                    GUI.this.showAllAnnotations = false;
                    GUI.this.display.repaint();
                }
            }
        });
        annotationsMenu.add(showAnnotationsMenuItem);
        menuBar.add(annotationsMenu);
        JMenu optionsMenu = new JMenu("Options");
        JMenu colorMenu = new JMenu("Color");
        ButtonGroup colorGroup = new ButtonGroup();
        ColorRadioButton c = new ColorRadioButton("White/Black", Color.white, Color.black);
        this.display.setBackground(c.background);
        this.display.setForeground(c.foreground);
        c.setSelected(true);
        colorGroup.add(c);
        colorGroup.add(new ColorRadioButton("Ithaca Sunset", new Color(204, 204, 204), new Color(0, 0, 0)));
        colorGroup.add(new ColorRadioButton("Spruce Forest", new Color(0, 45, 45), new Color(32, 196, 112)));
        colorGroup.add(new ColorRadioButton("Ocean Breeze", new Color(72, 200, 200), new Color(0, 20, 86)));
        colorGroup.add(new ColorRadioButton("681 Web Site", new Color(51, 51, 85), new Color(255, 255, 153)));
        colorGroup.add(new ColorRadioButton("682 Web Site", new Color(204, 204, 153), new Color(153, 0, 0)));
        colorGroup.add(new ColorRadioButton("Cornell", new Color(255, 255, 255), new Color(179, 27, 27)));
        colorGroup.add(new ColorRadioButton("Custom...", Color.lightGray, Color.lightGray));
        Enumeration<AbstractButton> e = colorGroup.getElements();
        while (e.hasMoreElements()) {
            colorMenu.add(e.nextElement());
        }
        optionsMenu.add(colorMenu);
        JMenu difficultyMenu = new JMenu("Difficulty");
        this.difficultyGroup = new ButtonGroup();
        item = new JRadioButtonMenuItem("Easy");
        item.setActionCommand("EASY");
        this.difficultyGroup.add(item);
        difficultyMenu.add(item);
        item.setSelected(true);
        item = new JRadioButtonMenuItem("Medium");
        item.setActionCommand("MEDIUM");
        this.difficultyGroup.add(item);
        difficultyMenu.add(item);
        item = new JRadioButtonMenuItem("Hard");
        item.setActionCommand("HARD");
        this.difficultyGroup.add(item);
        difficultyMenu.add(item);
        optionsMenu.add(difficultyMenu);
        item = new JMenuItem("Show Timer");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.timer.setVisible(true);
            }
        });
        item.setEnabled(true);
        optionsMenu.add(item);
        optionsMenu.addSeparator();
        this.showCompleted.setToolTipText("Show completed digits in a different color");
        this.showCompleted.setEnabled(true);
        this.showCompleted.setSelected(true);
        this.showCompleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.display.repaint();
            }
        });
        optionsMenu.add(this.showCompleted);
        this.checkConsistency.setToolTipText("Automatically report consistency after each commitment");
        this.checkConsistency.setEnabled(true);
        this.checkConsistency.setSelected(true);
        optionsMenu.add(this.checkConsistency);
        menuBar.add(optionsMenu);
        final Object[] helpMsg = new Object[]{"Fill in the table with the digits 1 through 9 with exactly one", "occurrence of each digit in each row, column, and 3x3 box.", "Left click to set a number.  Right click to toggle annotations.", " ", "Heuristics are subtractive on annotations, therefore the grid", "must be fully annotated for heuristics to work.", " "};
        JMenu helpMenu = new JMenu("Help");
        item = new JMenuItem("Help...", 72);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(GUI.this.frame, helpMsg, "CS211 Sudoku Help", 1);
            }
        });
        helpMenu.add(item);
        helpMenu.addSeparator();
        item = new JMenuItem("About...", 65);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] aboutMsg = new String[]{"CS211 Sudoku", "Version 2007.12.30.22:55"};
                JOptionPane.showMessageDialog(GUI.this.frame, aboutMsg, "CS211 Sudoku About", 1);
            }
        });
        helpMenu.add(item);
        menuBar.add(helpMenu);
        this.frame.setJMenuBar(menuBar);
        this.frame.add((Component)this.display, "Center");
        this.messageArea = new JLabel("", 2);
        this.messageArea.setBackground(Color.darkGray);
        this.frame.add((Component)this.messageArea, "South");
        this.clearMessage();
        this.frame.pack();
        this.frame.setLocation(200, 200);
        this.frame.setVisible(true);
        this.display.repaint();
    }

    void message(String s) {
        this.messageArea.setText(" " + s);
        this.messageArea.repaint();
    }

    void clearMessage() {
        this.message("");
    }

    class ColorRadioButton
    extends JRadioButtonMenuItem
    implements ActionListener {
        Color background;
        Color foreground;

        ColorRadioButton(String s, Color b, Color f) {
            super(s);
            this.background = b;
            this.foreground = f;
            this.setActionCommand(s);
            this.addActionListener(this);
            if (!s.equals("Custom...")) {
                this.setIcon(this.createIcon(b, f));
            }
        }

        Icon createIcon(Color background, Color foreground) {
            BufferedImage image = new BufferedImage(12, 12, 1);
            Graphics graphics = ((Image)image).getGraphics();
            graphics.setColor(background);
            graphics.fillRect(0, 0, 12, 12);
            graphics.setColor(foreground);
            graphics.fillRect(5, 0, 2, 12);
            graphics.fillRect(0, 5, 12, 2);
            return new ImageIcon(image);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int blue;
            int green;
            int red;
            if (e.getActionCommand().equals("Custom...")) {
                Color bc = JColorChooser.showDialog(GUI.this.frame, "Choose Background Color", GUI.this.display.getBackground());
                if (bc == null) {
                    return;
                }
                Color fc = JColorChooser.showDialog(GUI.this.frame, "Choose Foreground Color", GUI.this.display.getForeground());
                if (fc == null) {
                    return;
                }
                this.background = bc;
                this.foreground = fc;
                this.setIcon(this.createIcon(bc, fc));
            }
            GUI.this.display.setBackground(this.background);
            GUI.this.display.setForeground(this.foreground);
            int i = 0;
            while (i < GUI.this.pixels.length) {
                red = (GUI.this.gradients[i] * this.background.getRed() + (255 - GUI.this.gradients[i]) * this.foreground.getRed()) / 255;
                green = (GUI.this.gradients[i] * this.background.getGreen() + (255 - GUI.this.gradients[i]) * this.foreground.getGreen()) / 255;
                blue = (GUI.this.gradients[i] * this.background.getBlue() + (255 - GUI.this.gradients[i]) * this.foreground.getBlue()) / 255;
                GUI.this.pixels[i] = new Color(red, green, blue).getRGB();
                ++i;
            }
            GUI.this.logo.setRGB(0, 0, GUI.this.logo.getWidth(), GUI.this.logo.getHeight(), GUI.this.pixels, 0, GUI.this.logo.getWidth());
            red = (239 * this.background.getRed() + 16 * this.foreground.getRed()) / 255;
            green = (239 * this.background.getGreen() + 16 * this.foreground.getGreen()) / 255;
            blue = (239 * this.background.getBlue() + 16 * this.foreground.getBlue()) / 255;
            GUI.this.display.mixedColor = new Color(red, green, blue);
            red = (191 * this.background.getRed() + 64 * this.foreground.getRed()) / 255;
            green = (191 * this.background.getGreen() + 64 * this.foreground.getGreen()) / 255;
            blue = (191 * this.background.getBlue() + 64 * this.foreground.getBlue()) / 255;
            GUI.this.display.completedColor = new Color(red, green, blue);
        }
    }

    class Display
    extends JPanel {
        static final int SIZE = 51;
        static final int MARGIN = 61;
        static final int MAJOR_THICKNESS = 4;
        static final int MINOR_THICKNESS = 2;
        static final int GRADIENT = 16;
        static final int COMPLETED_GRADIENT = 64;
        final Font bigFont;
        final Font smallFont;
        final JPanel puzzlePanel;
        final PopupMenu popup;
        boolean showPossibilities;
        DisplayCell popupCell;
        int popupButton;
        int invertColor;
        Cell[] hint;
        Color mixedColor;
        Color completedColor;

        Display() {
            super(new BorderLayout());
            this.bigFont = new Font("SansSerif", 0, 42);
            this.smallFont = new Font("Monospaced", 0, 12);
            this.puzzlePanel = new JPanel(new GridLayout(9, 9, 0, 0));
            this.popup = new PopupMenu();
            this.showPossibilities = false;
            this.invertColor = -1;
            this.hint = null;
            JPanel panel = new JPanel();
            panel.setPreferredSize(new Dimension(61, 459));
            panel.setOpaque(false);
            this.add((Component)panel, "East");
            panel = new JPanel();
            panel.setPreferredSize(new Dimension(581, 61));
            panel.setOpaque(false);
            this.add((Component)panel, "North");
            panel = new JPanel();
            panel.setPreferredSize(new Dimension(61, 459));
            panel.setOpaque(false);
            this.add((Component)panel, "West");
            panel = new JPanel();
            panel.setPreferredSize(new Dimension(581, 61));
            panel.setOpaque(false);
            this.add((Component)panel, "South");
            this.puzzlePanel.setPreferredSize(new Dimension(459, 459));
            this.puzzlePanel.setOpaque(false);
            this.add((Component)this.puzzlePanel, "Center");
            int y = 0;
            while (y < 9) {
                int x = 0;
                while (x < 9) {
                    GUI.this.cells[x][y] = new DisplayCell(x, y);
                    this.puzzlePanel.add(GUI.this.cells[x][y]);
                    ++x;
                }
                ++y;
            }
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                GUI.this.logo = ImageIO.read(cl.getResourceAsStream("resources/Sudoku.gif"));
            }
            catch (Exception e) {
                throw new Error("Cannot find logo");
            }
            int w = GUI.this.logo.getWidth();
            int h = GUI.this.logo.getHeight();
            GUI.this.pixels = GUI.this.logo.getRGB(0, 0, w, h, new int[h * w], 0, w);
            GUI.this.logo = new BufferedImage(w, h, 2);
            GUI.this.logo.setRGB(0, 0, w, h, GUI.this.pixels, 0, w);
            GUI.this.gradients = new int[h * w];
            ColorModel colorModel = GUI.this.logo.getColorModel();
            int i = 0;
            while (i < GUI.this.gradients.length) {
                GUI.this.gradients[i] = colorModel.getRed(GUI.this.pixels[i]);
                ++i;
            }
            this.mixedColor = new Color(239, 239, 239);
            this.completedColor = new Color(191, 191, 191);
            this.setPreferredSize(new Dimension(581, 581));
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(this.mixedColor);
            graphics.fillRect(214, 61, 153, 153);
            graphics.fillRect(61, 214, 153, 153);
            graphics.fillRect(214, 367, 153, 153);
            graphics.fillRect(367, 214, 153, 153);
            if (GUI.this.showCompleted.isSelected()) {
                int y;
                int[] complete = new int[9];
                int x = 0;
                while (x < 9) {
                    y = 0;
                    while (y < 9) {
                        if (GUI.this.client.board.cell((int)x, (int)y).committed) {
                            int n = GUI.this.client.board.cell(x, y).value();
                            complete[n] = complete[n] + 1;
                        }
                        ++y;
                    }
                    ++x;
                }
                graphics.setColor(this.completedColor);
                x = 0;
                while (x < 9) {
                    y = 0;
                    while (y < 9) {
                        if (GUI.this.client.board.cell((int)x, (int)y).committed && complete[GUI.this.client.board.cell(x, y).value()] == 9) {
                            graphics.fillRect(61 + x * 51, 61 + y * 51, 51, 51);
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if (this.invertColor >= 0) {
                graphics.setColor(this.getForeground());
                int x = 0;
                while (x < 9) {
                    int y = 0;
                    while (y < 9) {
                        if (GUI.this.client.board.cell((int)x, (int)y).committed && GUI.this.client.board.cell(x, y).value() == this.invertColor) {
                            graphics.fillRect(61 + x * 51, 61 + y * 51, 51, 51);
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if (this.hint != null) {
                graphics.setColor(this.getForeground());
                Cell[] cellArray = this.hint;
                int n = this.hint.length;
                int n2 = 0;
                while (n2 < n) {
                    Cell c = cellArray[n2];
                    graphics.fillRect(61 + c.x * 51, 61 + c.y * 51, 51, 51);
                    ++n2;
                }
            }
            if (GUI.this.logo != null) {
                graphics.drawImage(GUI.this.logo, 3, 10, this.getBackground(), null);
            }
            this.drawGrid(graphics, 61);
        }

        void drawGrid(Graphics graphics, int margin) {
            graphics.setColor(this.getForeground());
            int x = 0;
            while (x <= 9) {
                int thickness = x % 3 == 0 ? 4 : 2;
                graphics.fillRect(margin - 2, margin + x * 51 - thickness / 2, 463, thickness);
                graphics.fillRect(margin + x * 51 - thickness / 2, margin - 2, thickness, 463);
                ++x;
            }
            x = 0;
            while (x < 9) {
                int y = 0;
                while (y < 9) {
                    GUI.this.cells[x][y].draw(graphics, margin);
                    ++y;
                }
                ++x;
            }
        }
    }

    class DisplayCell
    extends JPanel
    implements MouseListener {
        static final int SIZE = 51;
        final char[] digits = new char[]{' ', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        boolean showPossibilities = false;
        int x;
        int y;

        DisplayCell(int x, int y) {
            this.x = x;
            this.y = y;
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(51, 51));
            this.setOpaque(false);
        }

        Point getAbsoluteLocation() {
            int x = GUI.this.frame.getX() + GUI.this.frame.getRootPane().getX() + GUI.this.display.puzzlePanel.getX() + this.getX();
            int y = GUI.this.frame.getY() + GUI.this.frame.getRootPane().getY() + GUI.this.display.puzzlePanel.getY() + GUI.this.frame.getJMenuBar().getHeight() + this.getY();
            return new Point(x, y);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            GUI.this.display.popupButton = e.getButton();
            if (e.isMetaDown()) {
                if (GUI.this.client.board.cell((int)this.x, (int)this.y).committed) {
                    GUI.this.display.invertColor = GUI.this.client.board.cell(this.x, this.y).value();
                } else if (GUI.this.showAllAnnotations) {
                    GUI.this.display.popup.setLocation(this.getAbsoluteLocation());
                    GUI.this.display.popup.setVisible(true);
                    GUI.this.display.popupCell = this;
                } else {
                    this.showPossibilities = true;
                }
            } else if (!GUI.this.client.board.cell((int)this.x, (int)this.y).committed) {
                GUI.this.display.popup.setLocation(this.getAbsoluteLocation());
                GUI.this.display.popup.setVisible(true);
                GUI.this.display.popupCell = this;
            }
            GUI.this.display.repaint();
        }

        PopupMenuItem getMenuItem(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (GUI.this.display.popupCell == null) {
                return null;
            }
            if (x < 0 || x >= 51) {
                return null;
            }
            if (y < 0 || y >= 51) {
                return null;
            }
            int i = 3 * (y / 17) + x / 17;
            if (i < 0 || i > 8) {
                throw new Error("No such menu item " + i);
            }
            PopupMenuItem c = GUI.this.display.popup.popupMenuItems[i];
            if (c.value != i) {
                throw new Error("No such menu item " + i);
            }
            return c;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PopupMenuItem c = this.getMenuItem(e);
            if (c != null) {
                if (GUI.this.display.popupCell == null) {
                    return;
                }
                Cell cell = GUI.this.client.board.cell(GUI.this.display.popupCell.x, GUI.this.display.popupCell.y);
                if (cell.committed) {
                    throw new Error("Cell already committed");
                }
                GUI.this.client.undoStack.push(GUI.this.client.board.clone());
                GUI.this.undoItem.setEnabled(true);
                if (e.isMetaDown()) {
                    int b = 1 << c.value;
                    cell.possible = (cell.possible & b) != 0 ? (cell.possible &= ~b) : (cell.possible |= b);
                } else {
                    cell.commit(c.value);
                    Solve.commit(GUI.this.client.board, cell);
                    if (GUI.this.checkConsistency.isSelected()) {
                        GUI.this.client.checkConsistency();
                    }
                    try {
                        if (Solve.isSolution(GUI.this.client.board)) {
                            GUI.this.timer.stop();
                            GUI.this.message("Congratulations!");
                        }
                    }
                    catch (InconsistencyException ie) {
                        GUI.this.message("Not a solution");
                    }
                }
            }
            GUI.this.display.popup.setVisible(false);
            GUI.this.display.popupCell = null;
            this.showPossibilities = false;
            GUI.this.display.invertColor = -1;
            GUI.this.display.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        public void draw(Graphics graphics, int margin) {
            int xOffset = this.x * 51 + margin + 14;
            int yOffset = (this.y + 1) * 51 + margin - 10;
            if (GUI.this.client.board.cell((int)this.x, (int)this.y).committed && GUI.this.display.invertColor > -1 && GUI.this.client.board.cell(this.x, this.y).value() == GUI.this.display.invertColor) {
                graphics.setColor(GUI.this.display.getBackground());
            } else {
                graphics.setColor(GUI.this.display.getForeground());
            }
            if (!GUI.this.client.board.cell((int)this.x, (int)this.y).committed && (this.showPossibilities || GUI.this.showAllAnnotations)) {
                StringBuilder s = new StringBuilder();
                int b = 1;
                int z = 1;
                while (z < 10) {
                    s.append((GUI.this.client.board.cell((int)this.x, (int)this.y).possible & b) == b ? String.valueOf(z) : " ");
                    b <<= 1;
                    ++z;
                }
                char[] cr = s.toString().toCharArray();
                graphics.setFont(GUI.this.display.smallFont);
                int x1 = this.x * 51 + margin + 4;
                int y1 = this.y * 51 + margin + 14;
                graphics.drawChars(cr, 0, 1, x1, y1);
                graphics.drawChars(cr, 1, 1, x1 + 17, y1);
                graphics.drawChars(cr, 2, 1, x1 + 34, y1);
                graphics.drawChars(cr, 3, 1, x1, y1 + 15);
                graphics.drawChars(cr, 4, 1, x1 + 17, y1 + 15);
                graphics.drawChars(cr, 5, 1, x1 + 34, y1 + 15);
                graphics.drawChars(cr, 6, 1, x1, y1 + 30);
                graphics.drawChars(cr, 7, 1, x1 + 17, y1 + 30);
                graphics.drawChars(cr, 8, 1, x1 + 34, y1 + 30);
            } else {
                graphics.setFont(GUI.this.display.bigFont);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int c = GUI.this.client.board.cell((int)this.x, (int)this.y).committed ? GUI.this.client.board.cell(this.x, this.y).value() + 1 : 0;
                graphics.drawChars(this.digits, c, 1, xOffset, yOffset);
            }
        }
    }

    class HeuristicListener
    implements ActionListener {
        Heuristic h;

        HeuristicListener(Heuristic h) {
            this.h = h;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUI.this.clearMessage();
            Board c = GUI.this.client.board.clone();
            if (!this.h.check(GUI.this.client.board)) {
                GUI.this.message("No change");
                return;
            }
            GUI.this.client.undoStack.push(c);
            GUI.this.undoItem.setEnabled(true);
            GUI.this.display.repaint();
        }
    }

    class PopupMenu
    extends JWindow {
        PopupMenuItem[] popupMenuItems = new PopupMenuItem[9];

        PopupMenu() {
            this.setLayout(new GridLayout(3, 3, 0, 0));
            this.setSize(new Dimension(51, 51));
            int x = 0;
            while (x < 9) {
                this.popupMenuItems[x] = new PopupMenuItem(this, x);
                this.add(this.popupMenuItems[x]);
                ++x;
            }
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                PopupMenuItem[] popupMenuItemArray = this.popupMenuItems;
                int n = this.popupMenuItems.length;
                int n2 = 0;
                while (n2 < n) {
                    PopupMenuItem p = popupMenuItemArray[n2];
                    p.hover = false;
                    ++n2;
                }
            }
            super.setVisible(visible);
        }
    }

    class PopupMenuItem
    extends JPanel
    implements MouseListener {
        static final int SIZE = 17;
        final int value;
        final char[] label;
        boolean hover = false;

        PopupMenuItem(PopupMenu menu, int value) {
            this.value = value;
            this.label = String.valueOf(value + 1).toCharArray();
            this.setSize(new Dimension(17, 17));
            this.addMouseListener(this);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(this.hover ? GUI.this.display.completedColor : GUI.this.display.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(GUI.this.display.getForeground());
            graphics.setFont(GUI.this.display.smallFont);
            graphics.drawChars(this.label, 0, 1, 5, 12);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.hover = true;
            GUI.this.display.popup.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.hover = false;
            GUI.this.display.popup.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }
}

