/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.HashSet;
import sudoku.Board;
import sudoku.Cell;
import sudoku.Heuristic;

class ExposedDoubles
extends Heuristic {
    ExposedDoubles() {
        super("Exposed Doubles");
        this.tag = 8;
        this.toolTip = "Two cells in the same box, row, or column with same two numbers and no others";
    }

    @Override
    Cell[] find(Board cells, boolean change) {
        int y;
        Cell[] p = null;
        HashSet<Cell> doubles = new HashSet<Cell>();
        int x = 0;
        while (x < 9) {
            y = 0;
            while (y < 9) {
                if (Cell.number(cells.cell((int)x, (int)y).possible) == 2) {
                    doubles.add(cells.cell(x, y));
                }
                ++y;
            }
            ++x;
        }
        for (Cell c : doubles) {
            for (Cell d : doubles) {
                int b;
                if (c.equals(d)) continue;
                if (c.possible == d.possible && c.y == d.y) {
                    x = 0;
                    while (x < 9) {
                        if (x != c.x && x != d.x && (b = cells.cell((int)x, (int)c.y).possible & ~c.possible) != cells.cell((int)x, (int)c.y).possible) {
                            p = new Cell[]{c, d};
                            if (change) {
                                cells.cell((int)x, (int)c.y).possible = b;
                            }
                            return p;
                        }
                        ++x;
                    }
                }
                if (c.possible == d.possible && c.x == d.x) {
                    y = 0;
                    while (y < 9) {
                        if (y != c.y && y != d.y && (b = cells.cell((int)c.x, (int)y).possible & ~c.possible) != cells.cell((int)c.x, (int)y).possible) {
                            p = new Cell[]{c, d};
                            if (change) {
                                cells.cell((int)c.x, (int)y).possible = b;
                            }
                            return p;
                        }
                        ++y;
                    }
                }
                if (c.possible != d.possible || c.x / 3 != d.x / 3 || c.y / 3 != d.y / 3) continue;
                int z = 0;
                while (z < 9) {
                    int b2;
                    int i = c.x / 3 * 3 + z / 3;
                    int j = c.y / 3 * 3 + z % 3;
                    if (!(i == c.x && j == c.y || i == d.x && j == d.y || (b2 = cells.cell((int)i, (int)j).possible & ~c.possible) == cells.cell((int)i, (int)j).possible)) {
                        p = new Cell[]{c, d};
                        if (change) {
                            cells.cell((int)i, (int)j).possible = b2;
                        }
                        return p;
                    }
                    ++z;
                }
            }
        }
        return p;
    }
}

