/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

class Cell {
    int x;
    int y;
    boolean committed = false;
    boolean showPossibilities = false;
    int possible;

    Cell(int x, int y) {
        this.x = x;
        this.y = y;
    }

    void commit(int value) {
        this.committed = true;
        this.possible = 1 << value;
    }

    public Cell clone() {
        Cell cell = new Cell(this.x, this.y);
        cell.committed = this.committed;
        cell.possible = this.possible;
        return cell;
    }

    boolean determined() {
        return Cell.number(this.possible) == 1;
    }

    int value() {
        int s = 0;
        while (s < 9) {
            if (this.possible == 1 << s) {
                return s;
            }
            ++s;
        }
        return -1;
    }

    public boolean equals(Cell c) {
        return this.x == c.x && this.y == c.y;
    }

    static int bitValue(int b) {
        int z = 0;
        while (z < 9) {
            if (b == 1 << z) {
                return z;
            }
            ++z;
        }
        return -1;
    }

    static int number(int b) {
        int c = 0;
        while (b != 0) {
            if ((b & 1) == 1) {
                ++c;
            }
            b >>= 1;
        }
        return c;
    }
}

