/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.util.EmptyStackException;
import java.util.Vector;

public class BoundedStack<E> {
    Vector<E> elements;
    int top = 0;
    int bottom = 0;

    BoundedStack(int capacity) {
        this.elements = new Vector(capacity);
        this.elements.setSize(capacity);
    }

    void push(E item) {
        this.top = (this.top + 1) % this.elements.size();
        if (this.top == this.bottom) {
            this.bottom = (this.bottom + 1) % this.elements.size();
        }
        this.elements.setElementAt(item, this.top);
    }

    E pop() {
        if (this.top == this.bottom) {
            throw new EmptyStackException();
        }
        E item = this.elements.elementAt(this.top);
        this.top = (this.top - 1) % this.elements.size();
        if (item != null) {
            return item;
        }
        return this.pop();
    }

    boolean isEmpty() {
        int t = this.top;
        while (t != this.bottom && this.elements.elementAt(t) == null) {
            t = (t + this.elements.size() - 1) % this.elements.size();
        }
        return t == this.bottom;
    }

    boolean rollBack() {
        int t = this.top;
        while (t != this.bottom && this.elements.elementAt(t) != null) {
            t = (t - 1) % this.elements.size();
        }
        if (t == this.bottom) {
            return false;
        }
        this.top = t;
        return true;
    }

    void clear() {
        this.top = this.bottom;
    }
}

