/*
 * Decompiled with CFR 0.152.
 */
package rubik.geometry;

import rubik.geometry.Matrix;
import rubik.geometry.TwoDPoint;

public class ThreeDPoint {
    public double x;
    public double y;
    public double z;
    public static final ThreeDPoint ZERO = new ThreeDPoint(0.0, 0.0, 0.0);

    public ThreeDPoint(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ThreeDPoint plus(ThreeDPoint p) {
        return new ThreeDPoint(this.x + p.x, this.y + p.y, this.z + p.z);
    }

    public ThreeDPoint minus(ThreeDPoint p) {
        return new ThreeDPoint(this.x - p.x, this.y - p.y, this.z - p.z);
    }

    public double dotProduct(ThreeDPoint p) {
        return this.x * p.x + this.y * p.y + this.z * p.z;
    }

    public double length() {
        return Math.sqrt(this.dotProduct(this));
    }

    public double cos(ThreeDPoint p) {
        return this.dotProduct(p) / this.length() * p.length();
    }

    public TwoDPoint project(Matrix orientation, ThreeDPoint viewerPosition) {
        return orientation.transpose().mult(this).project(viewerPosition);
    }

    public TwoDPoint project(ThreeDPoint viewerPosition) {
        double retinalDistance = 1.0;
        double alpha = retinalDistance / (viewerPosition.x - this.x);
        return new TwoDPoint(this.y * alpha, this.z * alpha);
    }

    public boolean behind(ThreeDPoint p) {
        assert (!this.equals(ZERO));
        return p.minus(this).dotProduct(this) > 0.0;
    }

    public boolean visible(ThreeDPoint viewerPosition) {
        ThreeDPoint forward = new ThreeDPoint(-0.05, 0.0, 0.0);
        return forward.dotProduct(this.minus(viewerPosition.plus(forward))) >= 0.0;
    }

    public ThreeDPoint scale(double d) {
        return new ThreeDPoint(this.x * d, this.y * d, this.z * d);
    }

    public ThreeDPoint interpolate(ThreeDPoint t, Double a) {
        return new ThreeDPoint(a * this.x + (1.0 - a) * t.x, a * this.y + (1.0 - a) * t.y, a * this.z + (1.0 - a) * t.z);
    }

    public void round() {
        this.x = Math.rint(this.x);
        this.y = Math.rint(this.y);
        this.z = Math.rint(this.z);
    }

    public int hashCode() {
        return (int)(this.x + 3.0 * this.y + 7.0 * this.z);
    }

    public boolean equals(Object o) {
        try {
            ThreeDPoint op = (ThreeDPoint)o;
            return this.x == op.x && this.y == op.y && this.z == op.z;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return String.format("[%.0f %.0f %.0f]", this.x, this.y, this.z);
    }
}

