/*
 * Decompiled with CFR 0.152.
 */
package rubik.geometry;

import rubik.geometry.ThreeDPoint;

public class Matrix {
    public ThreeDPoint x;
    public ThreeDPoint y;
    public ThreeDPoint z;
    public static final Matrix IDENTITY = new Matrix();

    public Matrix(ThreeDPoint x, ThreeDPoint y, ThreeDPoint z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Matrix() {
        this(new ThreeDPoint(1.0, 0.0, 0.0), new ThreeDPoint(0.0, 1.0, 0.0), new ThreeDPoint(0.0, 0.0, 1.0));
    }

    public Matrix(int[][] m) {
        this(new ThreeDPoint(m[0][0], m[0][1], m[0][2]), new ThreeDPoint(m[1][0], m[1][1], m[1][2]), new ThreeDPoint(m[2][0], m[2][1], m[2][2]));
    }

    public ThreeDPoint mult(ThreeDPoint p) {
        return new ThreeDPoint(this.x.dotProduct(p), this.y.dotProduct(p), this.z.dotProduct(p));
    }

    public Matrix mult(Matrix m) {
        Matrix mT = m.transpose();
        return new Matrix(this.mult(mT.x), this.mult(mT.y), this.mult(mT.z)).transpose();
    }

    public Matrix transpose() {
        return new Matrix(new ThreeDPoint(this.x.x, this.y.x, this.z.x), new ThreeDPoint(this.x.y, this.y.y, this.z.y), new ThreeDPoint(this.x.z, this.y.z, this.z.z));
    }

    public void round() {
        this.x.round();
        this.y.round();
        this.z.round();
    }

    public int hashCode() {
        return this.x.hashCode() + 3 * this.y.hashCode() + 7 * this.z.hashCode();
    }

    public boolean equals(Object o) {
        try {
            Matrix m = (Matrix)o;
            return this.x.equals(m.x) && this.y.equals(m.y) && this.z.equals(m.z);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return String.format("%s\n%s\n%s", this.x, this.y, this.z);
    }
}

