/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import rubik.Clip;
import rubik.Cube;
import rubik.CubeGroup;
import rubik.MessageEvent;
import rubik.Planner;
import rubik.RubikGroup;
import rubik.geometry.Matrix;
import rubik.geometry.ThreeDPoint;
import rubik.geometry.TwoDPoint;

public class State {
    final Clip click = new Clip("click.wav");
    final Clip tada = new Clip("tada.wav");
    final Random random = new Random();
    final Stack<Move> history = new Stack();
    double rAngle = 0.0;
    Move rMove = Move.FL;
    boolean solving = false;
    boolean undoing = false;
    boolean brake = false;
    double distanceVelocity = 0.0;
    Matrix orientation = new Matrix();
    Matrix gamma = new Matrix();
    Matrix delta = new Matrix();
    TwoDPoint velocity = new TwoDPoint(0, 0);
    double viewerDistance = 13.0;
    ThreeDPoint viewerPosition = new ThreeDPoint(this.viewerDistance, 0.0, 0.0);
    static final ThreeDPoint BASE_LIGHT_SOURCE = new ThreeDPoint(10.0, 20.0, -30.0);
    static final int INIT_SPEED = 32;
    static final int MAX_SPEED = 64;
    static final int MIN_SPEED = 1;
    double rAngleDelta = this.setSpeed(32);
    private static final Matrix permuteAxes = new Matrix(new ThreeDPoint(0.0, 0.0, 1.0), new ThreeDPoint(1.0, 0.0, 0.0), new ThreeDPoint(0.0, 1.0, 0.0));
    Matrix rMatrix = State.rMatrix(Plane.FRONT, 0.0);
    private static Map<ThreeDPoint, Plane> planes = new HashMap<ThreeDPoint, Plane>();
    private static Map<Plane, Map<Boolean, Move>> moves = new HashMap<Plane, Map<Boolean, Move>>();

    private static Matrix xMatrix(double angle) {
        return new Matrix(new ThreeDPoint(1.0, 0.0, 0.0), new ThreeDPoint(0.0, Math.cos(angle), Math.sin(angle)), new ThreeDPoint(0.0, -Math.sin(angle), Math.cos(angle)));
    }

    private static Matrix yMatrix(double angle) {
        return permuteAxes.mult(State.xMatrix(angle).mult(permuteAxes.transpose()));
    }

    private static Matrix zMatrix(double angle) {
        return permuteAxes.transpose().mult(State.xMatrix(angle).mult(permuteAxes));
    }

    static Matrix rMatrix(Plane plane, double angle) {
        switch (plane.ordinal()) {
            case 0: {
                return State.xMatrix(angle);
            }
            case 1: {
                return State.xMatrix(angle).transpose();
            }
            case 2: {
                return State.yMatrix(angle);
            }
            case 3: {
                return State.yMatrix(angle).transpose();
            }
            case 4: {
                return State.zMatrix(angle);
            }
        }
        return State.zMatrix(angle).transpose();
    }

    boolean rotating(Cube cube) {
        return this.rAngle != 0.0 && State.inRotationPlane(cube, this.rMove.getPlane());
    }

    static boolean inRotationPlane(Cube cube, Plane plane) {
        return plane.normal.behind(cube.center);
    }

    void update() {
        double theta = Math.atan2(this.velocity.y, this.velocity.x);
        double r = this.velocity.x * this.velocity.x + this.velocity.y * this.velocity.y;
        this.gamma.y.y = Math.cos(theta);
        this.gamma.y.z = -Math.sin(theta);
        this.gamma.z.y = Math.sin(theta);
        this.gamma.z.z = Math.cos(theta);
        this.delta.x.x = Math.cos(r);
        this.delta.x.y = -Math.sin(r);
        this.delta.y.x = Math.sin(r);
        this.delta.y.y = Math.cos(r);
        this.orientation = this.orientation.mult(this.gamma.mult(this.delta.mult(this.gamma.transpose())));
        this.viewerDistance += this.distanceVelocity;
        this.viewerPosition.x = this.viewerDistance;
        if (this.rAngle == 0.0) {
            return;
        }
        if (Math.abs(this.rAngle) >= 1.5707963267948966) {
            this.stopRotation();
        } else {
            this.rAngle += Math.signum(this.rAngle) * this.rAngleDelta;
            this.rMatrix = State.rMatrix(this.rMove.getPlane(), this.rAngle);
        }
    }

    int solve() {
        if (this.solving || this.rAngle > 0.0) {
            return 0;
        }
        this.solving = true;
        List<Move> solution = new Planner(this).solve();
        this.history.clear();
        int i = solution.size() - 1;
        while (i >= 0) {
            this.history.push(solution.get(i));
            --i;
        }
        if (this.history.isEmpty()) {
            return 0;
        }
        Move move = this.history.pop();
        this.startRotation(move, true);
        return solution.size();
    }

    int solveImmediately() {
        if (this.solving || this.rAngle > 0.0) {
            return 0;
        }
        List<Move> solution = new Planner(this).solve();
        this.history.clear();
        this.moves(solution);
        return solution.size();
    }

    void startRotation(Move move, boolean ignoreOrientation) {
        if (this.rAngle != 0.0) {
            return;
        }
        this.rMove = ignoreOrientation ? move : move.getRelative(this.orientation);
        this.rAngle = move.inverse ? -this.rAngleDelta : this.rAngleDelta;
        this.rMatrix = State.rMatrix(this.rMove.getPlane(), this.rAngle);
    }

    void stopRotation() {
        this.move(this.rMove);
        this.rAngle = 0.0;
        this.rMatrix = Matrix.IDENTITY;
        this.click.play();
        if (this.solving) {
            String s = String.format("%d moves remaining", this.history.size());
            new MessageEvent(s).fire();
        }
        if (this.solved()) {
            this.history.clear();
            this.undoing = false;
            this.solving = false;
            this.tada.play();
        } else if (this.undoing) {
            this.undoing = false;
            this.solving = false;
        } else if (this.solving) {
            if (this.history.isEmpty()) {
                this.solving = false;
            } else {
                this.startRotation(this.history.pop(), true);
            }
        } else {
            this.history.add(this.rMove.inverse());
        }
    }

    void move(Move move) {
        Matrix m = move.getMatrix();
        CubeGroup cg = CubeGroup.elements.get(m);
        for (Cube c : Cube.cubes.values()) {
            c.oldPosition = c.position;
        }
        for (Cube c : Cube.cubes.values()) {
            if (!State.inRotationPlane(c, move.getPlane())) continue;
            Cube source = Cube.cubes.get(m.transpose().mult(c.center));
            c.position = source.oldPosition.mult(cg.inverse());
        }
    }

    void moves(Iterable<Move> moves) {
        for (Move move : moves) {
            this.move(move);
            this.history.add(move.inverse());
        }
    }

    void undo() throws EmptyStackException {
        if (this.solving) {
            return;
        }
        Move move = this.history.pop();
        this.undoing = true;
        this.startRotation(move, true);
    }

    boolean solved() {
        for (Cube c : Cube.cubes.values()) {
            if (c.type == Cube.Type.CENTER || c.type == Cube.Type.FACE || c.position.equals(CubeGroup.IDENTITY)) continue;
            return false;
        }
        return true;
    }

    void reset() {
        for (Cube c : Cube.cubes.values()) {
            c.position = CubeGroup.elements.get(Matrix.IDENTITY);
        }
        this.history.clear();
        this.solving = false;
        this.undoing = false;
    }

    double setSpeed(int value) {
        this.rAngleDelta = Math.PI * (double)value / 1024.0;
        return this.rAngleDelta;
    }

    RubikGroup getGroup() {
        return new RubikGroup(this);
    }

    String debug() {
        RubikGroup rg = new RubikGroup(this.history);
        HashSet<Cube> s = new HashSet<Cube>();
        for (Cube c : Cube.cubes.values()) {
            if (c.type != Cube.Type.CORNER && c.type != Cube.Type.EDGE) continue;
            s.add(c);
        }
        Set<Set<Cube>> orbits = rg.orbits(s);
        String st = "";
        for (Set<Cube> o : orbits) {
            st = String.valueOf(st) + " " + o.size();
        }
        return st;
    }

    /*
     * Unable to fully structure code
     */
    String test() {
        this.reset();
        next = 0;
        last = 0;
        i = 0;
        ** GOTO lbl15
        {
            next = this.random.nextInt(Move.values().length);
            do {
                if (next == last) continue block0;
                last = next;
                move = Move.values()[next];
                this.move(move);
                this.history.add(move.inverse());
                ++i;
lbl15:
                // 2 sources

            } while (i < 20);
        }
        m = this.solveImmediately();
        return String.valueOf(m) + " moves";
    }

    static enum Move {
        FR(Plane.FRONT, true),
        BR(Plane.BACK, true),
        RR(Plane.RIGHT, true),
        LR(Plane.LEFT, true),
        DR(Plane.DOWN, true),
        UR(Plane.UP, true),
        FL(Plane.FRONT, false),
        BL(Plane.BACK, false),
        RL(Plane.RIGHT, false),
        LL(Plane.LEFT, false),
        DL(Plane.DOWN, false),
        UL(Plane.UP, false);

        private Plane plane;
        private boolean inverse;
        private Matrix matrix;

        private Move(Plane plane, boolean inverse) {
            this.plane = plane;
            this.inverse = inverse;
            Matrix matrix = this.matrix = inverse ? plane.getMatrix().transpose() : plane.getMatrix();
            if (inverse) {
                moves.put(plane, new HashMap());
            }
            ((Map)moves.get((Object)plane)).put(inverse, this);
        }

        Matrix getMatrix() {
            return this.matrix;
        }

        Plane getPlane() {
            return this.plane;
        }

        static Move move(Plane plane, boolean inverse) {
            return (Move)((Object)((Map)moves.get((Object)plane)).get(inverse));
        }

        Move getRelative(Matrix orientation) {
            return Move.move(this.plane.getRelative(orientation), this.inverse);
        }

        Move inverse() {
            return Move.move(this.plane, !this.inverse);
        }

        Move conjugate(CubeGroup f) {
            ThreeDPoint p = f.inverse().apply(this.plane.normal);
            return Move.move(Plane.getPlane(p), this.inverse);
        }

        static List<Move> conjugateSequence(Iterable<Move> moves, CubeGroup f) {
            ArrayList<Move> clist = new ArrayList<Move>();
            for (Move m : moves) {
                clist.add(m.conjugate(f));
            }
            return clist;
        }
    }

    static enum Plane {
        FRONT,
        BACK,
        RIGHT,
        LEFT,
        DOWN,
        UP;

        private ThreeDPoint normal = Cube.normals[this.ordinal()];
        private Matrix matrix = State.rMatrix(this, 1.5707963267948966);

        private Plane() {
            this.matrix.round();
            planes.put(this.normal, this);
        }

        Plane getRelative(Matrix m) {
            ThreeDPoint p = m.mult(this.normal);
            Plane closest = this;
            Plane[] planeArray = Plane.values();
            int n = planeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Plane q = planeArray[n2];
                if (p.cos(q.normal) > p.cos(closest.normal)) {
                    closest = q;
                }
                ++n2;
            }
            return closest;
        }

        Matrix getMatrix() {
            return this.matrix;
        }

        static Plane getPlane(ThreeDPoint normal) {
            return (Plane)((Object)planes.get(normal));
        }
    }
}

