/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import java.awt.Color;
import java.awt.Polygon;
import java.util.HashMap;
import java.util.Map;
import rubik.BSPTreeNode;
import rubik.Cube;
import rubik.State;
import rubik.geometry.ThreeDPoint;

public class Square {
    static Map<ThreeDPoint, Square> elements = new HashMap<ThreeDPoint, Square>();
    Cube cube;
    ThreeDPoint center;
    ThreeDPoint normal;
    Color color;
    static final ThreeDPoint[][] baseCorners = new ThreeDPoint[][]{{new ThreeDPoint(0.0, 1.0, 1.0), new ThreeDPoint(0.0, -1.0, 1.0), new ThreeDPoint(0.0, -1.0, -1.0), new ThreeDPoint(0.0, 1.0, -1.0)}, {new ThreeDPoint(1.0, 0.0, 1.0), new ThreeDPoint(-1.0, 0.0, 1.0), new ThreeDPoint(-1.0, 0.0, -1.0), new ThreeDPoint(1.0, 0.0, -1.0)}, {new ThreeDPoint(1.0, 1.0, 0.0), new ThreeDPoint(-1.0, 1.0, 0.0), new ThreeDPoint(-1.0, -1.0, 0.0), new ThreeDPoint(1.0, -1.0, 0.0)}};
    ThreeDPoint[] corners = new ThreeDPoint[4];
    ThreeDPoint[] subCorners = new ThreeDPoint[4];
    ThreeDPoint[] orientedCorners = new ThreeDPoint[4];

    Square(Cube cube, ThreeDPoint center, ThreeDPoint normal) {
        this.cube = cube;
        this.center = center;
        this.normal = normal;
        int cornersIndex = normal.x != 0.0 ? 0 : (normal.y != 0.0 ? 1 : 2);
        int i = 0;
        while (i < 4) {
            this.corners[i] = center.plus(baseCorners[cornersIndex][i]);
            this.subCorners[i] = center.plus(baseCorners[cornersIndex][i].scale(0.9));
            ++i;
        }
        elements.put(center, this);
        if (cube.type == Cube.Type.CENTER) {
            if (center.x != 0.0) {
                BSPTreeNode.xRoot.insert(this);
            } else if (center.y != 0.0) {
                BSPTreeNode.yRoot.insert(this);
            } else {
                BSPTreeNode.zRoot.insert(this);
            }
        } else {
            BSPTreeNode.xRoot.insert(this);
            BSPTreeNode.yRoot.insert(this);
            BSPTreeNode.zRoot.insert(this);
        }
    }

    Polygon project(State state, boolean foreground) {
        Polygon p = new Polygon();
        int i = 0;
        while (i < 4) {
            ThreeDPoint corner;
            ThreeDPoint threeDPoint = corner = foreground ? this.subCorners[i] : this.corners[i];
            if (state.rotating(this.cube)) {
                corner = state.rMatrix.mult(corner);
            }
            this.orientedCorners[i] = state.orientation.transpose().mult(corner);
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (this.orientedCorners[i].visible(state.viewerPosition)) {
                this.orientedCorners[i].project(state.viewerPosition).place(p);
            } else {
                ThreeDPoint s;
                if (this.orientedCorners[(i + 3) % 4].visible(state.viewerPosition)) {
                    s = this.truncate(this.orientedCorners[(i + 3) % 4], this.orientedCorners[i], state.viewerPosition);
                    s.project(state.viewerPosition).place(p);
                }
                if (this.orientedCorners[(i + 1) % 4].visible(state.viewerPosition)) {
                    s = this.truncate(this.orientedCorners[(i + 1) % 4], this.orientedCorners[i], state.viewerPosition);
                    s.project(state.viewerPosition).place(p);
                }
            }
            ++i;
        }
        return p;
    }

    ThreeDPoint truncate(ThreeDPoint s, ThreeDPoint t, ThreeDPoint vp) {
        ThreeDPoint forward = new ThreeDPoint(-0.05, 0.0, 0.0);
        vp = vp.plus(forward);
        double a = vp.minus(t).dotProduct(vp);
        double b = s.minus(t).dotProduct(vp);
        double alpha = b == 0.0 ? 0.0 : a / b;
        return s.interpolate(t, alpha);
    }

    boolean behind(ThreeDPoint p) {
        return p.minus(this.center).dotProduct(this.normal) > 0.0;
    }

    void setColor(Color color) {
        this.color = color;
    }
}

