/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import rubik.Cube;
import rubik.CubeGroup;
import rubik.State;
import rubik.geometry.Matrix;

public class RubikGroup {
    Map<Cube, CubeGroup> dest = new HashMap<Cube, CubeGroup>();
    static Map<State.Move, RubikGroup> generators = new HashMap<State.Move, RubikGroup>();
    static RubikGroup IDENTITY = new RubikGroup();

    static {
        State.Move[] moveArray = State.Move.values();
        int n = moveArray.length;
        int n2 = 0;
        while (n2 < n) {
            State.Move move = moveArray[n2];
            generators.put(move, new RubikGroup(move));
            ++n2;
        }
    }

    RubikGroup(Iterable<State.Move> moves) {
        this();
        for (State.Move move : moves) {
            this.compose(generators.get((Object)move));
        }
    }

    RubikGroup(State state) {
        Collection<Cube> cubes = Cube.cubes.values();
        for (Cube c : cubes) {
            if (c.type != Cube.Type.CORNER && c.type != Cube.Type.EDGE) continue;
            Cube source = c.position.apply(c);
            this.dest.put(source, c.position.inverse());
        }
        assert (this.dest.size() == 20);
    }

    RubikGroup(State.Move move) {
        Matrix m = move.getMatrix();
        CubeGroup cg = CubeGroup.elements.get(m);
        for (Cube c : Cube.cubes.values()) {
            if (c.type != Cube.Type.CORNER && c.type != Cube.Type.EDGE) continue;
            this.dest.put(c, State.inRotationPlane(c, move.getPlane()) ? cg : CubeGroup.IDENTITY);
        }
        assert (this.dest.size() == 20);
    }

    private RubikGroup() {
        for (Cube c : Cube.cubes.values()) {
            if (c.type != Cube.Type.CORNER && c.type != Cube.Type.EDGE) continue;
            this.dest.put(c, CubeGroup.IDENTITY);
        }
        assert (this.dest.size() == 20);
    }

    private RubikGroup(RubikGroup rg) {
        this.dest.putAll(rg.dest);
    }

    Cube apply(Cube c) {
        return this.dest.get(c).apply(c);
    }

    public int hashCode() {
        int hc = 11;
        for (CubeGroup cg : this.dest.values()) {
            hc = hc + 7 * hc++ * cg.hashCode();
        }
        return hc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        try {
            Cube c;
            RubikGroup rg = (RubikGroup)obj;
            Iterator<Cube> iterator = this.dest.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.dest.get(c = iterator.next()).equals(rg.dest.get(c)));
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void compose(RubikGroup rg) {
        for (Cube c : this.dest.keySet()) {
            CubeGroup cg1 = this.dest.get(c);
            CubeGroup cg2 = rg.dest.get(cg1.apply(c));
            this.dest.put(c, cg2.mult(cg1));
        }
    }

    public void compose(State.Move m) {
        this.compose(generators.get((Object)m));
    }

    public RubikGroup inverse() {
        RubikGroup rg = new RubikGroup();
        for (Cube c : this.dest.keySet()) {
            CubeGroup cg = this.dest.get(c);
            rg.dest.put(cg.apply(c), cg.inverse());
        }
        return rg;
    }

    public RubikGroup conjugate(RubikGroup f) {
        RubikGroup fm = f.inverse();
        fm.compose(this);
        fm.compose(f);
        return fm;
    }

    public int order() {
        RubikGroup accum = new RubikGroup(this);
        int n = 1;
        while (!accum.equals(IDENTITY)) {
            accum.compose(this);
            ++n;
        }
        return n;
    }

    boolean parity(Set<Cube> s) {
        boolean b = false;
        Set<Set<Cube>> orbits = this.orbits(s);
        for (Set<Cube> t : orbits) {
            if (t.size() % 2 != 0) continue;
            boolean bl = b = !b;
        }
        return b;
    }

    Set<Set<Cube>> orbits(Set<Cube> s) {
        HashSet<Set<Cube>> orbits = new HashSet<Set<Cube>>();
        while (!s.isEmpty()) {
            HashSet<Cube> t = new HashSet<Cube>();
            Cube c = s.iterator().next();
            s.remove(c);
            t.add(c);
            Cube d = this.apply(c);
            while (d != c) {
                assert (s.contains(d));
                s.remove(d);
                t.add(d);
                d = this.apply(d);
            }
            orbits.add(t);
        }
        return orbits;
    }
}

