/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rubik.BSPTreeNode;
import rubik.BSPVisitor;
import rubik.Cube;
import rubik.CubeGroup;
import rubik.GUI;
import rubik.Square;
import rubik.State;
import rubik.geometry.ThreeDPoint;

public class Rubik {
    static final String VERSION = "1.3";
    static final boolean DEBUG = false;
    State state;
    GUI gui;
    ThreeDPoint viewerPosition;
    ThreeDPoint rViewerPosition;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Rubik().animate();
    }

    Rubik() {
        CubeGroup.create();
        Cube.create();
        this.state = new State();
        this.gui = new GUI(this, this.state);
        SwingUtilities.invokeLater(this.gui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void animate() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            Object object = this.state;
            synchronized (object) {
                this.state.update();
            }
            this.viewerPosition = this.state.orientation.mult(this.state.viewerPosition);
            this.rViewerPosition = this.state.rMatrix.transpose().mult(this.viewerPosition);
            object = this.gui.image;
            synchronized (object) {
                this.gui.drawBackground();
                BSPTreeNode.roots.get((Object)this.state.rMove.getPlane()).enumerate(new BSPVisitor<Object>(){

                    @Override
                    public Object visit(Square s, Object accum) {
                        Rubik.this.gui.render(s);
                        return accum;
                    }

                    @Override
                    public ThreeDPoint viewpoint(Square s) {
                        return Rubik.this.state.rotating(s.cube) ? Rubik.this.rViewerPosition : Rubik.this.viewerPosition;
                    }
                }, null);
            }
            this.gui.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

