/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rubik.Cube;
import rubik.CubeGroup;
import rubik.RubikGroup;
import rubik.State;

public class Planner {
    final State state;
    static final State.Move[][] topEdgeSolutions;
    static final State.Move[][] topCornerSolutions;
    static final State.Move[][] sideSolutions;
    static final State.Move[][] bottomEdgeSolutions;
    static final List<State.Move> bottomCross;
    static final List<State.Move> bottomTri;
    static final List<State.Move> bottomTriReflection;
    static final List<State.Move> bottomTriInverse;
    static final List<State.Move> bottomRotate;
    static final List<State.Move> bottomRotateInverse;
    static final CubeGroup left;
    static final CubeGroup right;
    static final CubeGroup opposite;
    static final Map<CubeGroup, List<State.Move>> topEdgeMoves;
    static final Map<CubeGroup, List<State.Move>> topCornerMoves;
    static final Map<CubeGroup, List<State.Move>> sideMoves;
    static final Map<CubeGroup, List<State.Move>> bottomEdgeMoves;
    static final Map<CubeGroup, List<State.Move>> bottomCornerMoves;
    static final Cube topEdgeSource;
    static final Cube topCornerSource;
    static final Cube sideSource;
    static final Cube bottomEdgeSource;
    static final Cube bottomCornerSource;
    static final Cube[] bottomEdges;
    static final Cube[] bottomCorners;
    RubikGroup rg;
    final List<State.Move> solution = new ArrayList<State.Move>();

    static {
        State.Move[] moveArray;
        topEdgeSolutions = new State.Move[][]{new State.Move[0], {State.Move.FL, State.Move.UR, State.Move.LL, State.Move.UL}, {State.Move.RL, State.Move.UL, State.Move.RR, State.Move.UR}, {State.Move.RL, State.Move.FL}, {State.Move.LL, State.Move.UR, State.Move.LR, State.Move.UL}, {State.Move.LR, State.Move.FR}, {State.Move.BL, State.Move.UL, State.Move.UL, State.Move.BR, State.Move.UR, State.Move.UR}, {State.Move.BL, State.Move.UL, State.Move.RL, State.Move.UR}, {State.Move.FL}, {State.Move.FR}, {State.Move.UL, State.Move.RL, State.Move.UR}, {State.Move.UL, State.Move.RR, State.Move.UR}, {State.Move.UR, State.Move.LL, State.Move.UL}, {State.Move.UR, State.Move.LR, State.Move.UL}, {State.Move.UL, State.Move.UL, State.Move.BL, State.Move.UR, State.Move.UR}, {State.Move.UL, State.Move.UL, State.Move.BR, State.Move.UR, State.Move.UR}, {State.Move.FL, State.Move.FL}, {State.Move.DL, State.Move.FL, State.Move.FL}, {State.Move.DR, State.Move.FL, State.Move.FL}, {State.Move.DL, State.Move.DL, State.Move.FL, State.Move.FL}, {State.Move.FL, State.Move.UL, State.Move.RR, State.Move.UR}, {State.Move.DL, State.Move.FL, State.Move.UL, State.Move.RR, State.Move.UR}, {State.Move.DR, State.Move.FL, State.Move.UL, State.Move.RR, State.Move.UR}, {State.Move.DL, State.Move.DL, State.Move.FL, State.Move.UL, State.Move.RR, State.Move.UR}};
        topCornerSolutions = new State.Move[][]{new State.Move[0], {State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL, State.Move.RL, State.Move.DL, State.Move.DL, State.Move.RR}, {State.Move.RL, State.Move.DL, State.Move.DL, State.Move.RR, State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL}, {State.Move.FR, State.Move.BL, State.Move.DL, State.Move.FL, State.Move.BR}, {State.Move.RR, State.Move.DR, State.Move.RL, State.Move.FR, State.Move.DR, State.Move.DR, State.Move.FL}, {State.Move.RR, State.Move.DR, State.Move.RL, State.Move.RL, State.Move.DL, State.Move.DL, State.Move.RR}, {State.Move.RL, State.Move.LR, State.Move.DR, State.Move.RR, State.Move.LL}, {State.Move.FL, State.Move.DL, State.Move.FR, State.Move.RL, State.Move.DL, State.Move.DL, State.Move.RR}, {State.Move.FL, State.Move.DL, State.Move.FR, State.Move.FR, State.Move.DR, State.Move.DR, State.Move.FL}, {State.Move.FR, State.Move.BR, State.Move.DL, State.Move.DL, State.Move.FL, State.Move.BL}, {State.Move.LL, State.Move.DL, State.Move.LR, State.Move.FR, State.Move.DL, State.Move.FL}, {State.Move.BR, State.Move.DR, State.Move.BL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.FR, State.Move.DL, State.Move.FL}, {State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL}, {State.Move.DL, State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL}, {State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL}, {State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.RL, State.Move.DR, State.Move.DR, State.Move.RR}, {State.Move.DR, State.Move.RL, State.Move.DR, State.Move.DR, State.Move.RR}, {State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.FR, State.Move.DL, State.Move.FL, State.Move.RL, State.Move.DL, State.Move.DL, State.Move.RR, State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL}, {State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL, State.Move.RL, State.Move.DL, State.Move.DL, State.Move.RR, State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL}, {State.Move.RL, State.Move.DR, State.Move.RR, State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL, State.Move.RL, State.Move.DL, State.Move.DL, State.Move.RR}, {State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR, State.Move.FR, State.Move.DL, State.Move.DL, State.Move.FL, State.Move.RL, State.Move.DL, State.Move.DL, State.Move.RR}};
        sideSolutions = new State.Move[][]{{State.Move.RL, State.Move.DR, State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL}, {State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL}, {State.Move.DL, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.DR, State.Move.RL, State.Move.DR, State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL}, {State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.DL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL}, {State.Move.DL, State.Move.DL, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, new State.Move[0], {State.Move.FR, State.Move.DR, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DL, State.Move.RR, State.Move.DL, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.FL, State.Move.DL, State.Move.FR, State.Move.DR, State.Move.LR, State.Move.DR, State.Move.LL, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.LR, State.Move.DR, State.Move.LL, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.FR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.LL, State.Move.DL, State.Move.LR, State.Move.DR, State.Move.BR, State.Move.DR, State.Move.BL, State.Move.DR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.BR, State.Move.DR, State.Move.BL, State.Move.DL, State.Move.LL, State.Move.DL, State.Move.LR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.BL, State.Move.DL, State.Move.BR, State.Move.DR, State.Move.RR, State.Move.DR, State.Move.RL, State.Move.DL, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}, {State.Move.RR, State.Move.DR, State.Move.RL, State.Move.DL, State.Move.BL, State.Move.DL, State.Move.BR, State.Move.DR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.RR}};
        bottomEdgeSolutions = new State.Move[][]{new State.Move[0], {State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.RL}, {State.Move.RR, State.Move.FR, State.Move.DR, State.Move.FL, State.Move.DL, State.Move.RL}, {State.Move.LL, State.Move.DL, State.Move.FL, State.Move.DR, State.Move.FR, State.Move.LR}, {State.Move.LL, State.Move.FL, State.Move.DL, State.Move.FR, State.Move.DR, State.Move.LR}, {State.Move.FR, State.Move.DR, State.Move.LR, State.Move.DL, State.Move.LL, State.Move.FL, State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.RL}, {State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.RL, State.Move.LL, State.Move.DL, State.Move.FL, State.Move.DR, State.Move.FR, State.Move.LR}, {State.Move.BL, State.Move.LL, State.Move.DL, State.Move.LR, State.Move.DR, State.Move.BR, State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.RL}};
        bottomCross = Arrays.asList(State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.RL, State.Move.LL, State.Move.FL, State.Move.DL, State.Move.FR, State.Move.DR, State.Move.LR, State.Move.RR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.FL, State.Move.RL);
        bottomTri = Arrays.asList(State.Move.FR, State.Move.BL, State.Move.DL, State.Move.BR, State.Move.DR, State.Move.FL, State.Move.DL, State.Move.BL, State.Move.DR, State.Move.BR);
        bottomTriReflection = Arrays.asList(State.Move.LR, State.Move.DR, State.Move.LL, State.Move.DL, State.Move.RL, State.Move.DR, State.Move.LR, State.Move.DL, State.Move.LL, State.Move.RR);
        bottomTriInverse = Arrays.asList(State.Move.BL, State.Move.DL, State.Move.BR, State.Move.DR, State.Move.FR, State.Move.DL, State.Move.BL, State.Move.DR, State.Move.BR, State.Move.FL);
        bottomRotate = Arrays.asList(State.Move.FL, State.Move.UR, State.Move.UR, State.Move.FR, State.Move.RR, State.Move.UL, State.Move.UL, State.Move.RL, State.Move.DR, State.Move.RR, State.Move.UR, State.Move.UR, State.Move.RL, State.Move.FL, State.Move.UL, State.Move.UL, State.Move.FR, State.Move.DL);
        bottomRotateInverse = Arrays.asList(State.Move.DR, State.Move.FL, State.Move.UR, State.Move.UR, State.Move.FR, State.Move.RR, State.Move.UL, State.Move.UL, State.Move.RL, State.Move.DL, State.Move.RR, State.Move.UR, State.Move.UR, State.Move.RL, State.Move.FL, State.Move.UL, State.Move.UL, State.Move.FR);
        left = CubeGroup.elements.get(State.Move.UL.getMatrix());
        right = left.inverse();
        opposite = left.mult(left);
        topEdgeMoves = new HashMap<CubeGroup, List<State.Move>>();
        topCornerMoves = new HashMap<CubeGroup, List<State.Move>>();
        sideMoves = new HashMap<CubeGroup, List<State.Move>>();
        bottomEdgeMoves = new HashMap<CubeGroup, List<State.Move>>();
        bottomCornerMoves = new HashMap<CubeGroup, List<State.Move>>();
        topEdgeSource = Cube.cubeAt(2, 0, -2);
        topCornerSource = Cube.cubeAt(2, 2, -2);
        sideSource = Cube.cubeAt(2, 2, 0);
        bottomEdgeSource = Cube.cubeAt(2, 0, 2);
        bottomCornerSource = Cube.cubeAt(2, 2, 2);
        bottomEdges = new Cube[]{Cube.cubeAt(2, 0, 2), Cube.cubeAt(0, 2, 2), Cube.cubeAt(-2, 0, 2), Cube.cubeAt(0, -2, 2)};
        bottomCorners = new Cube[]{Cube.cubeAt(2, 2, 2), Cube.cubeAt(-2, -2, 2), Cube.cubeAt(-2, 2, 2), Cube.cubeAt(2, -2, 2)};
        State.Move[][] moveArray2 = topEdgeSolutions;
        int n = topEdgeSolutions.length;
        int n2 = 0;
        while (n2 < n) {
            moveArray = moveArray2[n2];
            Planner.setup(topEdgeMoves, topEdgeSource, Arrays.asList(moveArray));
            ++n2;
        }
        moveArray2 = topCornerSolutions;
        n = topCornerSolutions.length;
        n2 = 0;
        while (n2 < n) {
            moveArray = moveArray2[n2];
            Planner.setup(topCornerMoves, topCornerSource, Arrays.asList(moveArray));
            ++n2;
        }
        moveArray2 = sideSolutions;
        n = sideSolutions.length;
        n2 = 0;
        while (n2 < n) {
            moveArray = moveArray2[n2];
            Planner.setup(sideMoves, sideSource, Arrays.asList(moveArray));
            ++n2;
        }
        moveArray2 = bottomEdgeSolutions;
        n = bottomEdgeSolutions.length;
        n2 = 0;
        while (n2 < n) {
            moveArray = moveArray2[n2];
            Planner.setup(bottomEdgeMoves, bottomEdgeSource, Arrays.asList(moveArray));
            ++n2;
        }
        Planner.setup(bottomCornerMoves, bottomCornerSource, new ArrayList());
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomRotate);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomRotateInverse);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTri);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTri, bottomRotate);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTri, bottomRotateInverse);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTriInverse);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTriInverse, bottomRotate);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTriInverse, bottomRotateInverse);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTriReflection);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTriReflection, bottomRotate);
        Planner.setup(bottomCornerMoves, bottomCornerSource, bottomTriReflection, bottomRotateInverse);
    }

    static void setup(Map<CubeGroup, List<State.Move>> options, Cube source, List<State.Move> ... moves) {
        ArrayList<State.Move> sol = new ArrayList<State.Move>();
        List<State.Move>[] listArray = moves;
        int n = moves.length;
        int n2 = 0;
        while (n2 < n) {
            List<State.Move> m = listArray[n2];
            sol.addAll(m);
            ++n2;
        }
        CubeGroup cg = new RubikGroup(sol).inverse().dest.get(source);
        options.put(cg, sol);
    }

    Planner(State state) {
        this.state = state;
    }

    void solveOne(Map<CubeGroup, List<State.Move>> phaseSolutions, CubeGroup f, Cube source) {
        CubeGroup g = this.rg.dest.get(f.apply(source));
        CubeGroup h = g.conjugate(f);
        List<State.Move> moves = phaseSolutions.get(h);
        moves = State.Move.conjugateSequence(moves, f.inverse());
        this.append(moves);
    }

    void solveFour(Map<CubeGroup, List<State.Move>> phaseSolutions, Cube source) {
        this.solveOne(phaseSolutions, CubeGroup.IDENTITY, source);
        this.solveOne(phaseSolutions, right, source);
        this.solveOne(phaseSolutions, opposite, source);
        this.solveOne(phaseSolutions, left, source);
    }

    List<State.Move> solve() {
        this.rg = this.state.getGroup();
        this.solution.clear();
        this.solveFour(topEdgeMoves, topEdgeSource);
        this.solveFour(topCornerMoves, topCornerSource);
        this.solveFour(sideMoves, sideSource);
        Set<Cube> s = this.asSet(bottomEdges);
        if (this.rg.parity(s)) {
            this.append(State.Move.DL);
        }
        this.solveOne(bottomEdgeMoves, CubeGroup.IDENTITY, bottomEdgeSource);
        this.solveOne(bottomEdgeMoves, opposite, bottomEdgeSource);
        if (!this.rg.dest.get(Cube.cubeAt(0, 2, 2)).equals(CubeGroup.IDENTITY)) {
            this.append(bottomCross);
        }
        this.solveFour(bottomCornerMoves, bottomCornerSource);
        this.simplify(this.solution);
        return this.solution;
    }

    void append(State.Move move) {
        this.rg.compose(move);
        this.solution.add(move);
    }

    void append(List<State.Move> moves) {
        this.rg.compose(new RubikGroup(moves));
        this.solution.addAll(moves);
    }

    void simplify(List<State.Move> list) {
        int oldSize = list.size() + 1;
        while (list.size() < oldSize) {
            oldSize = list.size();
            int i = 0;
            while (i < list.size()) {
                if (i < list.size() - 1 && list.get(i).equals((Object)list.get(i + 1).inverse())) {
                    list.remove(i + 1);
                    list.remove(i);
                    if (i > 0) {
                        --i;
                    }
                }
                if (i < list.size() - 2 && list.get(i).equals((Object)list.get(i + 1)) && list.get(i).equals((Object)list.get(i + 2))) {
                    list.remove(i + 2);
                    list.remove(i + 1);
                    State.Move m = list.remove(i);
                    list.add(i, m.inverse());
                    i -= Math.min(i, 2);
                }
                ++i;
            }
        }
    }

    <T> Set<T> asSet(T[] array) {
        HashSet<T> s = new HashSet<T>();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            s.add(item);
            ++n2;
        }
        return s;
    }
}

