/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Random;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rubik.Cube;
import rubik.MessageEvent;
import rubik.MessageEventListener;
import rubik.Rubik;
import rubik.Square;
import rubik.State;
import rubik.geometry.ThreeDPoint;
import rubik.geometry.TwoDPoint;

public class GUI
extends JFrame
implements Runnable {
    Random random = new Random();
    Rubik rubik;
    State state;
    GUI gui;
    final int WINDOW_SIZE = 500;
    final int ORIGIN = 250;
    boolean fill = true;
    Image image;
    Image backgroundImage;
    Graphics2D buffer;
    TwoDPoint dragOrigin = null;
    final JPanel canvas = new JPanel(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Image image = GUI.this.image;
            synchronized (image) {
                g.drawImage(GUI.this.image, 0, 0, GUI.this.canvas);
            }
        }
    };
    final JLabel messageArea = new JLabel();

    GUI(Rubik rubik, State state) {
        super("Rubik's Cube");
        this.rubik = rubik;
        this.state = state;
        this.gui = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        final JFileChooser fileChooser = new JFileChooser();
        JMenuItem menuItem = new JMenuItem("Open...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ok = fileChooser.showOpenDialog(GUI.this.canvas);
                if (ok != 0) {
                    return;
                }
                File file = fileChooser.getSelectedFile();
                Scanner sc = null;
                try {
                    sc = new Scanner(file);
                }
                catch (FileNotFoundException fnf) {
                    JOptionPane.showMessageDialog(GUI.this.canvas, "File not found");
                }
                try {
                    Cube.decode(sc);
                    GUI.this.message("File successfully read");
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(GUI.this.canvas, "Could not read input file");
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg;
                PrintStream out = null;
                int ok = fileChooser.showSaveDialog(GUI.this.canvas);
                if (ok != 0) {
                    return;
                }
                File file = fileChooser.getSelectedFile();
                if (file.exists() && (ok = JOptionPane.showConfirmDialog(GUI.this.canvas, msg = "File " + file.getAbsolutePath() + " exists; overwrite?", "", 0)) != 0) {
                    return;
                }
                try {
                    try {
                        out = new PrintStream(new FileOutputStream(file));
                        out.println(Cube.encode());
                        GUI.this.message("File successfully written");
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(GUI.this.canvas, "Cannot write file " + file.getAbsolutePath());
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Quit");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Action");
        menuItem = new JMenuItem("Undo");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GUI.this.state.undo();
                    GUI.this.clearMessage();
                }
                catch (EmptyStackException ese) {
                    GUI.this.message("Nothing to undo");
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Scramble...");
        final SpinnerNumberModel spinnerModel = new SpinnerNumberModel(3, 1, 99, 1);
        final JSpinner spinner = new JSpinner(spinnerModel);
        spinner.setPreferredSize(new Dimension(10, 27));
        menuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                result = JOptionPane.showOptionDialog(GUI.this.gui, spinner, "Select number of moves", 2, 3, null, null, null);
                if (result == -1 || result == 2) {
                    return;
                }
                n = spinnerModel.getNumber().intValue();
                next = 0;
                last = 0;
                i = 0;
                ** GOTO lbl24
                {
                    next = GUI.this.random.nextInt(State.Move.values().length);
                    do {
                        if (next == last) continue block3;
                        last = next;
                        move = State.Move.values()[next];
                        var8_8 = GUI.this.state;
                        synchronized (var8_8) {
                            GUI.this.state.move(move);
                            GUI.this.state.history.add(move.inverse());
                        }
                        ++i;
lbl24:
                        // 2 sources

                    } while (i < n);
                }
                GUI.this.message(String.valueOf(n) + " random moves performed");
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Reset");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.state.reset();
                GUI.this.clearMessage();
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menuItem = new JMenuItem("Solve");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.message(String.valueOf(GUI.this.state.solve()) + " moves");
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menuItem = new JMenuItem("Solve Immediately");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.message(String.valueOf(GUI.this.state.solveImmediately()) + " moves");
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        menuItem = new JMenuItem("Debug");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.message(GUI.this.state.debug());
            }
        });
        menuBar.add(menu);
        menu = new JMenu("Options");
        menuItem = new JMenuItem("Color...");
        final ButtonGroup buttons = new ButtonGroup();
        class PreviewPanel
        extends JPanel {
            public PreviewPanel() {
                this.setPreferredSize(new Dimension(400, 50));
                this.setSize(this.getPreferredSize());
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
            }
        }
        final PreviewPanel previewPanel = new PreviewPanel();
        class ColorPanel
        extends JRadioButton {
            Color color;

            public ColorPanel(int index, final ButtonGroup buttonGroup) {
                this.setPreferredSize(new Dimension(40, 40));
                this.color = Cube.colors[index];
                buttonGroup.add(this);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        buttonGroup.setSelected(this.getModel(), true);
                    }
                });
            }

            @Override
            public void paint(Graphics g) {
                g.setColor(this.isSelected() ? Color.BLACK : this.color);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isSelected()) {
                    g.setColor(this.color);
                    g.fillRect(3, 3, this.getWidth() - 6, this.getHeight() - 6);
                }
            }
        }
        final HashMap<ButtonModel, ColorPanel> buttonMap = new HashMap<ButtonModel, ColorPanel>();
        final JColorChooser colorChooser = new JColorChooser();
        colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel buttonModel = buttons.getSelection();
                if (buttonModel == null) {
                    return;
                }
                ColorPanel cp = (ColorPanel)buttonMap.get(buttonModel);
                cp.color = colorChooser.getColor();
            }
        });
        int i = 0;
        while (i < 6) {
            ColorPanel cp = new ColorPanel(i, buttons);
            previewPanel.add(cp);
            buttonMap.put(cp.getModel(), cp);
            ++i;
        }
        colorChooser.setPreviewPanel(previewPanel);
        final JDialog colorDialog = JColorChooser.createDialog(this.canvas, "Choose colors", false, colorChooser, new ActionListener(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int i = 0;
                while (i < 6) {
                    ColorPanel cp = (ColorPanel)previewPanel.getComponent(i);
                    Cube.colors[i] = cp.color;
                    ++i;
                }
                Cube.setAllColors();
            }
        }, null);
        try {
            Container c = (Container)colorChooser.getParent().getComponent(1);
            JButton b = (JButton)c.getComponent(2);
            assert (b.getText().equals("Reset"));
            b.removeActionListener(b.getActionListeners()[0]);
            b.addActionListener(new ActionListener(){
                {
                }

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int i = 0;
                    while (i < 6) {
                        ColorPanel cp = (ColorPanel)previewPanel.getComponent(i);
                        cp.color = Cube.colors[i];
                        previewPanel.repaint();
                        ++i;
                    }
                }
            });
        }
        catch (Exception c) {
            // empty catch block
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorDialog.setVisible(true);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Speed...");
        final JSlider slider = new JSlider(0, 1, 64, 32);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GUI.this.state.setSpeed(slider.getValue());
            }
        });
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog speedDialog = new JDialog(GUI.this.gui, "Set speed of rotation", false);
                speedDialog.setResizable(false);
                speedDialog.setLayout(new FlowLayout(1));
                speedDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent event) {
                        speedDialog.dispose();
                    }
                });
                JLabel label = new JLabel("Slow");
                speedDialog.add(label);
                speedDialog.add(slider);
                label = new JLabel("Fast");
                speedDialog.add(label);
                speedDialog.setLocationRelativeTo(GUI.this.gui);
                speedDialog.pack();
                speedDialog.setVisible(true);
            }
        });
        menu.add(menuItem);
        final JCheckBoxMenuItem mute = new JCheckBoxMenuItem("Mute");
        mute.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GUI.this.state.click.setEnabled(!mute.isSelected());
                GUI.this.state.tada.setEnabled(!mute.isSelected());
            }
        });
        menu.add(mute);
        menuBar.add(menu);
        menu = new JMenu("Help");
        menuItem = new JMenuItem("Get Help...", 72);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] helpMsg = new String[]{"Drag with the mouse to rotate the cube.", "Shift to brake.", "Keys turn the faces:", "s - front (closest to viewer)", "e - back", "w - top", "a - left", "d - right", "x - bottom", "Faces turn counterclockwise.", "Shift to turn clockwise.", "Arrow keys zoom in and out.", "Menu items are self-explanatory."};
                JOptionPane.showMessageDialog(GUI.this.gui, helpMsg, "Rubik's Cube Help", 1);
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("About...", 65);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] aboutMsg = new String[]{"Rubik's Cube", "CS2110 Fall 2011 Assignment 4", "Version 1.3", "Java program \u00a9 2011 Cornell University\n\n", "Rubik\u00ae and Rubik's Cube\u00ae are registered trademarks", "of Seven Towns Limited, which is the exclusive worldwide", "licensee of copyright for images of the Rubik's Cube", "puzzle and the puzzle itself.\n\n", "The use of Rubik's Cube in this context is deemed to be", "fair use under the Copyright Act of 1976, 17 U.S.C. \u00a7107."};
                JOptionPane.showMessageDialog(GUI.this.gui, aboutMsg, "About CS2110 Rubik", 1);
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    GUI.this.fill = !GUI.this.fill;
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    GUI.this.state.velocity = TwoDPoint.ZERO;
                    GUI.this.dragOrigin = GUI.this.mousePosition(e);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double scaleFactor = -0.002;
                if (GUI.this.state.brake) {
                    return;
                }
                if (GUI.this.dragOrigin == null) {
                    GUI.this.dragOrigin = GUI.this.mousePosition(e);
                } else {
                    TwoDPoint pos = GUI.this.mousePosition(e);
                    double dist = pos.distance(GUI.this.dragOrigin);
                    if (dist < 10.0) {
                        return;
                    }
                    GUI.this.state.velocity = pos.minus(GUI.this.dragOrigin).scalarMult(-0.002);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: {
                        GUI.this.state.distanceVelocity = 0.1;
                        break;
                    }
                    case 40: {
                        GUI.this.state.distanceVelocity = -0.1;
                        break;
                    }
                    case 16: {
                        GUI.this.state.brake = true;
                        GUI.this.state.velocity = TwoDPoint.ZERO;
                        break;
                    }
                    case 72: {
                        System.out.println(Cube.encode());
                        break;
                    }
                    case 65: {
                        GUI.this.state.startRotation(e.isShiftDown() ? State.Move.LR : State.Move.LL, false);
                        break;
                    }
                    case 68: {
                        GUI.this.state.startRotation(e.isShiftDown() ? State.Move.RR : State.Move.RL, false);
                        break;
                    }
                    case 69: {
                        GUI.this.state.startRotation(e.isShiftDown() ? State.Move.BR : State.Move.BL, false);
                        break;
                    }
                    case 83: {
                        GUI.this.state.startRotation(e.isShiftDown() ? State.Move.FR : State.Move.FL, false);
                        break;
                    }
                    case 87: {
                        GUI.this.state.startRotation(e.isShiftDown() ? State.Move.UR : State.Move.UL, false);
                        break;
                    }
                    case 88: {
                        GUI.this.state.startRotation(e.isShiftDown() ? State.Move.DR : State.Move.DL, false);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: 
                    case 40: {
                        GUI.this.state.distanceVelocity = 0.0;
                        break;
                    }
                    case 16: {
                        GUI.this.state.brake = false;
                    }
                }
            }
        });
        MessageEvent.addMessageEventListener(new MessageEventListener(){

            @Override
            public void eventOccurred(MessageEvent event) {
                GUI.this.message(event.msg);
            }
        });
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setLocation(this.getLocation().x - 250, this.getLocation().y - 250);
        this.canvas.setPreferredSize(new Dimension(500, 500));
        this.add((Component)this.canvas, "Center");
        this.messageArea.setPreferredSize(new Dimension(500, 20));
        this.add((Component)this.messageArea, "South");
        this.pack();
        this.setVisible(true);
        this.image = this.createImage(500, 500);
        this.buffer = (Graphics2D)this.image.getGraphics();
        this.buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.buffer.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        this.buffer.translate(250, 250);
        this.backgroundImage = this.createImage(500, 500);
        Graphics bg = this.backgroundImage.getGraphics();
        boolean daytime = (Calendar.getInstance().get(11) + 6) % 24 >= 12;
        String fileName = daytime ? "resources/images/clouds.jpg" : "resources/images/stars.jpg";
        try {
            this.backgroundImage = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream(fileName));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bg.translate(250, 250);
        Rubik rubik = this.rubik;
        synchronized (rubik) {
            this.rubik.notify();
        }
    }

    void message(String msg) {
        this.messageArea.setText(" " + msg);
    }

    void clearMessage() {
        this.message("");
    }

    private TwoDPoint mousePosition(MouseEvent e) {
        return new TwoDPoint(e.getX() - 250, e.getY() - 250);
    }

    void render(Square s) {
        Polygon pBack = s.project(this.state, false);
        Polygon pFront = s.project(this.state, true);
        if (pBack.npoints <= 2 || pFront.npoints <= 2) {
            return;
        }
        ThreeDPoint lightSource = this.state.rotating(s.cube) ? this.state.rMatrix.transpose().mult(this.state.orientation.mult(State.BASE_LIGHT_SOURCE)) : this.state.orientation.mult(State.BASE_LIGHT_SOURCE);
        Color color = s.cube.position.apply((Square)s).color;
        float intensity = this.fill ? (float)((lightSource.cos(s.normal) + 1.0) / 2.0) : 1.0f;
        float r = intensity * (float)color.getRed() / 256.0f;
        float g = intensity * (float)color.getGreen() / 256.0f;
        float b = intensity * (float)color.getBlue() / 256.0f;
        if (this.fill) {
            this.buffer.setColor(Color.BLACK);
            this.buffer.fillPolygon(pBack);
            this.buffer.setColor(new Color(r, g, b));
            this.buffer.fillPolygon(pFront);
        } else {
            this.buffer.setColor(new Color(r, g, b));
            this.buffer.drawPolygon(pBack);
        }
    }

    void drawBackground() {
        this.buffer.drawImage(this.backgroundImage, -250, -250, this.canvas);
    }
}

