/*
 * Decompiled with CFR 0.152.
 */
package rubik;

import java.util.HashMap;
import java.util.Map;
import rubik.Cube;
import rubik.Square;
import rubik.geometry.Matrix;
import rubik.geometry.ThreeDPoint;

public class CubeGroup {
    public static CubeGroup IDENTITY;
    private Matrix matrix;
    private static final int[][] evenReflections;
    private static final int[][] oddReflections;
    private static final int[][] evenPermutations;
    private static final int[][] oddPermutations;
    static final Map<Matrix, CubeGroup> elements;

    static {
        evenReflections = new int[][]{{1, 1, 1}, {1, -1, -1}, {-1, 1, -1}, {-1, -1, 1}};
        oddReflections = new int[][]{{-1, -1, -1}, {-1, 1, 1}, {1, -1, 1}, {1, 1, -1}};
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 2;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        evenPermutations = nArrayArray;
        int[][] nArrayArray2 = new int[3][];
        int[] nArray4 = new int[3];
        nArray4[1] = 2;
        nArray4[2] = 1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 2;
        nArrayArray2[1] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 2;
        nArray6[1] = 1;
        nArrayArray2[2] = nArray6;
        oddPermutations = nArrayArray2;
        elements = new HashMap<Matrix, CubeGroup>();
    }

    private CubeGroup(int[] perm, int[] refl) {
        int[][] m = new int[3][3];
        int j = 0;
        while (j < 3) {
            int k = perm[j];
            m[k][j] = refl[k];
            m[k][(j + 1) % 3] = 0;
            m[k][(j + 2) % 3] = 0;
            ++j;
        }
        this.matrix = new Matrix(m);
        elements.put(this.matrix, this);
    }

    static void create() {
        int i = 0;
        while (i < 12) {
            new CubeGroup(evenPermutations[i / 4], evenReflections[i % 4]);
            new CubeGroup(oddPermutations[i / 4], oddReflections[i % 4]);
            ++i;
        }
        IDENTITY = elements.get(Matrix.IDENTITY);
    }

    CubeGroup mult(CubeGroup cg) {
        return elements.get(this.matrix.mult(cg.matrix));
    }

    CubeGroup inverse() {
        return elements.get(this.matrix.transpose());
    }

    ThreeDPoint apply(ThreeDPoint p) {
        return this.matrix.mult(p);
    }

    Square apply(Square s) {
        return Square.elements.get(this.apply(s.center));
    }

    Cube apply(Cube c) {
        return Cube.cubes.get(this.apply(c.center));
    }

    CubeGroup conjugate(CubeGroup f) {
        return f.inverse().mult(this).mult(f);
    }

    public int hashCode() {
        return this.matrix.hashCode();
    }

    public boolean equals(Object obj) {
        try {
            CubeGroup cg = (CubeGroup)obj;
            return this.matrix.equals(cg.matrix);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.matrix.toString();
    }
}

